/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.ws;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.Pair;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.info.EnemyTargetingInfo;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.info.battle.BattleInfo;
import dsekercioglu.mega.rMove.info.battle.BattleSummary;
import dsekercioglu.mega.rMove.sim.Wave;
import dsekercioglu.mega.rMove.ws.path.Path;
import dsekercioglu.mega.rMove.ws.path.PathGenerator;
import dsekercioglu.mega.rMove.ws.path.State;
import dsekercioglu.mega.rMove.ws.path.aacalc.FancyDistancer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import robocode.AdvancedRobot;

public class WaveSurfingGT {
    private final double SMOOTH_FACTOR;
    private static final int SECOND_WAVE_BINS = 51;
    private static final double SECOND_WAVE_WEIGHT = 0.2;
    private final AdvancedRobot ROBOT;
    private Wave currentSurfWave = null;
    private Wave[] oldSurfWaves = new Wave[2];
    private double[] secondWaveDangers;
    private double minSecondWaveDanger;
    private final PathGenerator PATH_GENERATOR;
    private Path currentPath;
    private boolean waveUpdate;
    List<Path> allPaths = new ArrayList<Path>();

    public WaveSurfingGT(AdvancedRobot robot, double smoothFactor) {
        this.ROBOT = robot;
        this.SMOOTH_FACTOR = smoothFactor;
        double battleFieldWidth = robot.getBattleFieldWidth();
        double battleFieldHeight = robot.getBattleFieldHeight();
        this.PATH_GENERATOR = new PathGenerator(battleFieldWidth, battleFieldHeight);
        this.PATH_GENERATOR.setPathGenerator(new FancyDistancer(battleFieldWidth, battleFieldHeight));
    }

    public void run() {
        this.currentPath = null;
        this.waveUpdate = true;
    }

    public void surf(List<Wave> waves, BattleInfo battleInfo, BattleSummary battleSummary) {
        boolean wavesOnAir;
        this.currentSurfWave = null;
        Object surfWave2 = null;
        Object[] surfWaves = this.getSurfWaves(waves, battleInfo.getBotLocation());
        if (!Arrays.equals(surfWaves, this.oldSurfWaves)) {
            this.waveUpdate = true;
        }
        this.oldSurfWaves = surfWaves;
        if (surfWaves != null) {
            this.currentSurfWave = surfWaves[0];
            if (surfWaves.length > 1) {
                surfWave2 = surfWaves[1];
            }
            wavesOnAir = true;
        } else {
            wavesOnAir = false;
            EnemyTargetingInfo enemyTargetingInfo = new EnemyTargetingInfo(battleInfo.getEnemyLocation(), battleInfo.getAbsoluteBearing() + Math.PI);
            this.currentSurfWave = new Wave(enemyTargetingInfo, new WaveData(battleSummary, 3.0), battleSummary, 0);
            surfWave2 = new Wave(enemyTargetingInfo, new WaveData(battleSummary, 3.0), battleSummary, -16);
            ArrayList<GuessFactor> headOn = new ArrayList<GuessFactor>();
            headOn.add(new GuessFactor(0.0, 1.0, 0));
            this.currentSurfWave.setGuessFactors(headOn);
            ((Wave)surfWave2).setGuessFactors(headOn);
        }
        if (surfWave2 != null) {
            this.secondWaveDangers = this.getSecondWaveDangers((Wave)surfWave2, battleInfo.getBotLocation(), battleInfo);
        }
        if (!wavesOnAir || this.waveUpdate || !this.currentPath.hasNext()) {
            Path pathToTake;
            double startVelocity = battleInfo.getBotVelocity();
            double startHeading = battleInfo.getBotHeading();
            State currentState = new State((Point2D.Double)battleInfo.getBotLocation().clone(), startVelocity, startHeading, 0);
            State enemyState = new State((Point2D.Double)battleInfo.getEnemyLocation().clone(), battleInfo.getEnemyVelocity(), battleInfo.getEnemyHeading(), 0);
            this.allPaths.clear();
            ArrayList<Path> paths = new ArrayList<Path>();
            if (wavesOnAir) {
                paths.addAll(this.PATH_GENERATOR.generateSimpleDistancingPaths(currentState, enemyState, this.currentSurfWave, 2));
                if (paths.isEmpty()) {
                    paths.addAll(this.PATH_GENERATOR.generateRunAwayPaths(currentState, enemyState, this.currentSurfWave, 0));
                }
            } else {
                paths.addAll(this.PATH_GENERATOR.generateRunAwayPaths(currentState, enemyState, this.currentSurfWave, 0));
            }
            if ((pathToTake = this.safestPath(paths, enemyState, this.currentSurfWave, (Wave)surfWave2, battleInfo, true)) == null) {
                System.out.println("NO SOLUTIONS FOUND");
            } else {
                this.allPaths.addAll(paths);
                this.currentPath = pathToTake;
                this.currentPath.reset();
                this.waveUpdate = false;
            }
        }
        if (this.currentPath != null && this.currentPath.hasNext()) {
            double[] moveInstructions = this.currentPath.next();
            double velocity = moveInstructions[0];
            double direction = Math.signum(velocity);
            this.ROBOT.setMaxVelocity(direction * velocity);
            this.ROBOT.setAhead(direction * 36.0);
            this.ROBOT.setTurnRightRadians(moveInstructions[1]);
        } else {
            System.out.println("NO PATH GENERATED IN TIME");
            this.ROBOT.setMaxVelocity(0.0);
        }
    }

    public Path safestPath(List<Path> paths, State enemyState, Wave firstWave, Wave secondWave, BattleInfo battleInfo, boolean useIntersection) {
        ArrayList<Pair<PathIntersectionDanger, Double>> orderedPaths = new ArrayList<Pair<PathIntersectionDanger, Double>>();
        Path pathToTake = null;
        double lowestDanger = Double.POSITIVE_INFINITY;
        for (Path path : paths) {
            int index = path.numberOfStates() - 1;
            ArrayList<State> intersection = new ArrayList<State>();
            if (useIntersection) {
                State state = path.getState(index);
                while (!state.isIntersecting() && index > 0) {
                    state = path.getState(--index);
                }
                while (state.isIntersecting() && index >= 0) {
                    intersection.add(state);
                    state = path.getState(index);
                    --index;
                }
            } else {
                intersection.add(path.getState(index));
            }
            double danger = this.getDanger(firstWave, intersection, battleInfo);
            double positionalDanger = this.getPositionalDanger(intersection, battleInfo);
            if (secondWave == null) {
                if (!((danger *= positionalDanger) < lowestDanger)) continue;
                pathToTake = path;
                lowestDanger = danger;
                continue;
            }
            orderedPaths.add(new Pair<PathIntersectionDanger, Double>(new PathIntersectionDanger(path, intersection, positionalDanger), danger));
        }
        if (secondWave == null) {
            return pathToTake;
        }
        Collections.sort(orderedPaths);
        for (Pair pair : orderedPaths) {
            double danger = (Double)pair.getComparable();
            PathIntersectionDanger pid = (PathIntersectionDanger)pair.getObject();
            List intersection = pid.INTERSECTION;
            if ((danger + this.minSecondWaveDanger) * pid.DANGER > lowestDanger) break;
            Path path = ((PathIntersectionDanger)pair.getObject()).PATH;
            danger += this.getCachedDanger(secondWave, (State)intersection.get(intersection.size() - 1), battleInfo, this.secondWaveDangers);
            if (!((danger *= pid.DANGER) < lowestDanger)) continue;
            lowestDanger = danger;
            pathToTake = path;
        }
        return pathToTake;
    }

    public void onWaveUpdate() {
        this.waveUpdate = true;
    }

    private int getTimeLeft(Wave wave, Point2D.Double location) {
        return (int)Math.ceil((wave.getSource().distance(location) - 18.0 - wave.getDistanceTraveled()) / wave.getWaveVelocity());
    }

    private Wave[] getSurfWaves(List<Wave> waves, Point2D.Double location) {
        ArrayList<Pair<Wave, Integer>> orderedWaves = new ArrayList<Pair<Wave, Integer>>();
        for (Wave wave : waves) {
            int timeLeft = this.getTimeLeft(wave, location);
            if (timeLeft < 0) continue;
            Pair<Wave, Integer> pair = new Pair<Wave, Integer>(wave, timeLeft);
            orderedWaves.add(pair);
        }
        if (orderedWaves.isEmpty()) {
            return null;
        }
        if (orderedWaves.size() == 1) {
            return new Wave[]{(Wave)((Pair)orderedWaves.get(0)).getObject()};
        }
        if (orderedWaves.size() == 2) {
            Wave wave0 = (Wave)((Pair)orderedWaves.get(0)).getObject();
            Wave wave1 = (Wave)((Pair)orderedWaves.get(1)).getObject();
            if (this.getTimeLeft(wave0, location) < this.getTimeLeft(wave1, location)) {
                return new Wave[]{wave0, wave1};
            }
            return new Wave[]{wave1, wave0};
        }
        Collections.sort(orderedWaves);
        return new Wave[]{(Wave)((Pair)orderedWaves.get(0)).getObject(), (Wave)((Pair)orderedWaves.get(1)).getObject()};
    }

    private Point2D.Double[] getSimulatedMEA(State currentState, State enemyState, Wave surfWave, int deltaTime) {
        Path[] paths = this.PATH_GENERATOR.getExtremePaths(currentState, enemyState, surfWave, deltaTime);
        return new Point2D.Double[]{paths[0].getLastState().getLocation(), paths[1].getLastState().getLocation()};
    }

    private double getPositionalDanger(List<State> intersection, BattleInfo battleInfo) {
        double distance = intersection.get(0).getLocation().distance(battleInfo.getEnemyLocation()) - 36.0;
        return 100.0 / distance;
    }

    private double getEscapeSafety(State currentState, BattleInfo battleInfo, BattleSummary battleSummary) {
        EnemyTargetingInfo enemyTargetingInfo = new EnemyTargetingInfo(battleInfo.getEnemyLocation(), battleInfo.getAbsoluteBearing() + Math.PI);
        Wave meaWave = new Wave(enemyTargetingInfo, new WaveData(battleSummary, 3.0), battleSummary, 0);
        State enemyState = new State(battleInfo.getEnemyLocation(), 0.0, battleInfo.getEnemyHeading(), 0);
        Point2D.Double[] meaPoints = this.getSimulatedMEA(currentState, enemyState, meaWave, 0);
        double startGuessFactor = meaWave.getGuessFactor(meaPoints[0].x, meaPoints[0].y);
        double endGuessFactor = meaWave.getGuessFactor(meaPoints[1].x, meaPoints[1].y);
        return Math.abs(endGuessFactor - startGuessFactor) * meaWave.getMEA();
    }

    private double getDanger(Wave surfWave, List<State> intersection, BattleInfo battleInfo) {
        double hitProbability = this.calculateDanger(intersection, surfWave);
        return hitProbability * (surfWave.getWaveDamage() + surfWave.getWavePower() * 3.0);
    }

    private double getCachedDanger(Wave wave, State state, BattleInfo battleInfo, double[] secondWaveDangers) {
        double secondWaveDanger = Double.POSITIVE_INFINITY;
        Point2D.Double[] pointsMEA = this.getSimulatedMEA(state, new State(battleInfo.getEnemyLocation(), battleInfo.getEnemyVelocity(), battleInfo.getEnemyHeading(), state.getDeltaTime()), wave, state.getDeltaTime());
        double startGuessFactor = wave.getGuessFactor(pointsMEA[0].x, pointsMEA[0].y);
        double endGuessFactor = wave.getGuessFactor(pointsMEA[1].x, pointsMEA[1].y);
        double temp = startGuessFactor;
        startGuessFactor = Math.min(temp, endGuessFactor);
        endGuessFactor = Math.max(temp, endGuessFactor);
        int startBin = Math.max((int)((startGuessFactor + 1.0) / 2.0 * 50.0), 0);
        int endBin = Math.min((int)((endGuessFactor + 1.0) / 2.0 * 50.0), 50);
        for (int i = startBin; i <= endBin; ++i) {
            secondWaveDanger = Math.min(secondWaveDanger, secondWaveDangers[i]);
        }
        return secondWaveDanger;
    }

    private double calculateDanger(List<State> botIntersection, Wave wave) {
        double[] guessFactors = this.calculateInterval(botIntersection, wave);
        return wave.getDanger(guessFactors[0], guessFactors[1], this.SMOOTH_FACTOR);
    }

    private double[] calculateInterval(List<State> botIntersection, Wave wave) {
        double maxGuessFactor = Double.NEGATIVE_INFINITY;
        double minGuessFactor = Double.POSITIVE_INFINITY;
        for (State state : botIntersection) {
            List<Point2D.Double> intersectingPoints = state.getIntersection();
            if (intersectingPoints == null) {
                intersectingPoints = this.getDefaultIntersection(state.getLocation());
            }
            for (Point2D.Double intersectingPoint : intersectingPoints) {
                double guessFactor = wave.getGuessFactor(intersectingPoint.x, intersectingPoint.y);
                maxGuessFactor = Math.max(maxGuessFactor, guessFactor);
                minGuessFactor = Math.min(minGuessFactor, guessFactor);
            }
        }
        return new double[]{minGuessFactor, maxGuessFactor};
    }

    private double[] calculateDefaultInterval(List<Point2D.Double> botIntersection, Wave wave) {
        double maxGuessFactor = Double.NEGATIVE_INFINITY;
        double minGuessFactor = Double.POSITIVE_INFINITY;
        for (Point2D.Double intersectingPoint : botIntersection) {
            double guessFactor = wave.getGuessFactor(intersectingPoint.x, intersectingPoint.y);
            maxGuessFactor = Math.max(maxGuessFactor, guessFactor);
            minGuessFactor = Math.min(minGuessFactor, guessFactor);
        }
        return new double[]{minGuessFactor, maxGuessFactor};
    }

    private List<Point2D.Double> getDefaultIntersection(Point2D.Double location) {
        ArrayList<Point2D.Double> intersectionPoints = new ArrayList<Point2D.Double>();
        for (int x = -18; x <= 18; x += 36) {
            for (int y = -18; y <= 18; y += 36) {
                Point2D.Double cornerPosition = new Point2D.Double(location.x + (double)x, location.y + (double)y);
                intersectionPoints.add(cornerPosition);
            }
        }
        return intersectionPoints;
    }

    private double[] getSecondWaveDangers(Wave wave, Point2D.Double botLocation, BattleInfo battleInfo) {
        this.minSecondWaveDanger = Double.POSITIVE_INFINITY;
        double botWidth = FastMath.atan(25.0 / wave.getSource().distance(botLocation)) / wave.getMEA();
        double[] dangers = new double[51];
        for (int i = 0; i < 51; ++i) {
            double danger;
            double currentGuessFactor = (double)i * 2.0 / 50.0 - 1.0;
            double hitProbability = wave.getDanger(currentGuessFactor - botWidth, currentGuessFactor + botWidth, this.SMOOTH_FACTOR);
            dangers[i] = danger = hitProbability * (wave.getWaveDamage() + wave.getWavePower() * 3.0) * 0.2;
            this.minSecondWaveDanger = Math.min(danger, this.minSecondWaveDanger);
        }
        return dangers;
    }

    public void onPaint(Graphics2D g) {
        if (this.currentPath != null) {
            ArrayList<State> intersectingStates = new ArrayList<State>();
            double maxDistance = 0.0;
            for (int i = 0; i < this.currentPath.numberOfStates(); ++i) {
                if (!this.currentPath.getState(i).isIntersecting()) continue;
                intersectingStates.add(this.currentPath.getState(i));
                maxDistance = Math.max(maxDistance, this.currentPath.getState(i).getLocation().distance(this.currentSurfWave.getSource()));
            }
            double[] guessFactors = this.calculateInterval(intersectingStates, this.currentSurfWave);
            g.setColor(Color.WHITE);
            for (double guessFactor : guessFactors) {
                double angle = this.currentSurfWave.getAbsoluteBearing() + this.currentSurfWave.getLateralDirection() * this.currentSurfWave.getMEA() * guessFactor;
                Point2D.Double estimatedIntersectionPoint = MoveUtils.project(this.currentSurfWave.getSource(), angle, maxDistance);
                g.drawLine((int)(this.currentSurfWave.getSource().x + 0.5), (int)(this.currentSurfWave.getSource().y + 0.5), (int)(estimatedIntersectionPoint.x + 0.5), (int)(estimatedIntersectionPoint.y + 0.5));
            }
            g.setColor(Color.MAGENTA);
            for (int i = 1; i < this.currentPath.numberOfStates(); ++i) {
                State currentState = this.currentPath.getState(i);
                State previousState = this.currentPath.getState(i - 1);
                Point2D.Double location = currentState.getLocation();
                Point2D.Double previousLocaton = previousState.getLocation();
                g.drawLine((int)(previousLocaton.x + 0.5), (int)(previousLocaton.y + 0.5), (int)(location.x + 0.5), (int)(location.y + 0.5));
            }
            Point2D.Double targetLocation = this.currentPath.getState(this.currentPath.numberOfStates() - 1).getLocation();
            g.drawRect((int)(targetLocation.x - 17.5), (int)(targetLocation.y - 17.5), 36, 36);
        }
    }

    private static class PathIntersectionDanger {
        private final Path PATH;
        private final List<State> INTERSECTION;
        private final double DANGER;

        public PathIntersectionDanger(Path path, List<State> intersection, double danger) {
            this.PATH = path;
            this.INTERSECTION = intersection;
            this.DANGER = danger;
        }
    }
}

