/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.GravityListener$$Lambda$1;
import execution.GravityListener$$Lambda$4;
import execution.GravityListener$$Lambda$5;
import execution.GravityListener$$Lambda$6;
import execution.INotifiable;
import execution.Message;
import execution.MessageRouter;
import execution.Painter;
import execution.Sequencer;
import grav.BattlefieldCollection;
import grav.GravityCollection;
import grav.RobotCollection;
import java.awt.geom.Point2D;
import math.Vect2d;
import robocode.util.Utils;
import sim.Bot;
import sim.Data;
import sim.Stat;

public class GravityListener
implements INotifiable {
    private GravityCollection _gravity;
    private Sequencer _sequencer;
    private Painter _painter;

    public GravityListener(Sequencer sequencer, Painter painter) {
        this._sequencer = sequencer;
        this._painter = painter;
    }

    @Override
    public void Initialize(MessageRouter router) {
        router.Subscribe(Message.Kind.Update, GravityListener$$Lambda$1.lambdaFactory$(this));
        router.Subscribe(Message.Kind.RoundStarted, GravityListener$$Lambda$4.lambdaFactory$(this));
        router.Subscribe(Message.Kind.PaintEnabled, GravityListener$$Lambda$5.lambdaFactory$(this));
        router.Subscribe(Message.Kind.PaintDisabled, GravityListener$$Lambda$6.lambdaFactory$(this));
    }

    private final void Update(Message message) {
        Bot robot = Data.Robots.Self;
        Vect2d vector = this._gravity.GetEffectiveGravity(message.time);
        Point2D.Double location = new Point2D.Double();
        location.setLocation(robot.Position);
        vector.movePoint(location);
        this.goTo(location, robot, message.time);
    }

    private final void OnPaintEnabled(Message message) {
        this._painter.Register(this._gravity);
    }

    private final void OnPaintDisabled(Message message) {
        this._painter.UnRegister(this._gravity);
    }

    private final void OnRoundStarted(Message message) {
        this._gravity = new GravityCollection();
        this._gravity.Add(new BattlefieldCollection());
        this._gravity.Add(new RobotCollection());
    }

    private void goTo(Point2D.Double point, Bot robot, long time) {
        double x = point.getX() - robot.Position.getX();
        double y = point.getY() - robot.Position.getY();
        double angleToTarget = Math.atan2(x, y);
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - robot.Get(Stat.HEADING)));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        this._sequencer.turn.set(turnAngle);
        if (targetAngle == turnAngle) {
            this._sequencer.move.set(distance);
        } else {
            this._sequencer.move.set(-distance);
        }
    }

    static /* synthetic */ void access$lambda$0(GravityListener gravityListener, Message message) {
        gravityListener.Update(message);
    }

    static /* synthetic */ void access$lambda$1(GravityListener gravityListener, Message message) {
        gravityListener.OnRoundStarted(message);
    }

    static /* synthetic */ void access$lambda$2(GravityListener gravityListener, Message message) {
        gravityListener.OnPaintEnabled(message);
    }

    static /* synthetic */ void access$lambda$3(GravityListener gravityListener, Message message) {
        gravityListener.OnPaintDisabled(message);
    }
}

