/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.turning;

import benhorner.utility.units.Bearing;
import benhorner.utility.units.Units;

public class Variable {
    private Bearing min;
    private Bearing max;

    public Variable(Bearing min, Bearing max) {
        assert (Units.lessOrEqual(min, max));
        this.min = min;
        this.max = max;
    }

    public Bearing getMin() {
        return this.min;
    }

    public Bearing getMax() {
        return this.max;
    }

    public boolean increaseMinTo(Bearing new_min) {
        boolean result = Units.less(this.min, new_min);
        if (result) {
            this.min = new_min;
        }
        assert (Units.lessOrEqual(this.min, this.max));
        return result;
    }

    public boolean decreaseMaxTo(Bearing new_max) {
        boolean result = Units.less(new_max, this.max);
        if (result) {
            this.max = new_max;
        }
        assert (Units.lessOrEqual(this.min, this.max));
        return result;
    }

    public boolean isBound() {
        return this.min.equals(this.max);
    }

    public String toString() {
        return "[" + this.min + " " + this.max + "]";
    }
}

