/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.utils;

import java.awt.geom.Point2D;

public class EuclideanVector {
    public double x;
    public double y;

    public EuclideanVector(double x, double y) {
        this.set(x, y);
    }

    public EuclideanVector(Point2D.Double p1, Point2D.Double p2) {
        this.set(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public static EuclideanVector getPolarVector(double r, double angle) {
        return new EuclideanVector(r * Math.cos(angle), r * Math.sin(angle));
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double[] get() {
        return new double[]{this.x, this.y};
    }

    public void add(EuclideanVector v) {
        this.x += v.x;
        this.y += v.y;
    }

    public static EuclideanVector add(EuclideanVector v1, EuclideanVector v2) {
        return new EuclideanVector(v1.x + v2.x, v1.y + v2.y);
    }

    public void sub(EuclideanVector v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public static EuclideanVector sub(EuclideanVector v1, EuclideanVector v2) {
        return new EuclideanVector(v1.x - v2.x, v1.y - v2.y);
    }

    public void mul(double r) {
        this.x *= r;
        this.y *= r;
    }

    public static EuclideanVector mul(EuclideanVector v1, double r) {
        return new EuclideanVector(v1.x * r, v1.y * r);
    }

    public void div(double r) {
        this.x /= r;
        this.y /= r;
    }

    public static EuclideanVector div(EuclideanVector v1, double r) {
        return new EuclideanVector(v1.x / r, v1.y / r);
    }

    public double dot(EuclideanVector v) {
        return this.x * v.x + this.y * v.y;
    }

    public static EuclideanVector dot(EuclideanVector v1, EuclideanVector v2) {
        return new EuclideanVector(v1.x * v2.x, v1.y * v2.y);
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        this.div(this.mag());
    }

    public static EuclideanVector normalize(EuclideanVector v) {
        return EuclideanVector.div(v, v.mag());
    }

    public double getAngle() {
        return Math.atan2(this.y, this.x);
    }

    public double angleBetween(EuclideanVector vec) {
        return vec.getAngle() - this.getAngle();
    }

    public static double angleBetween(EuclideanVector v1, EuclideanVector v2) {
        return v2.getAngle() - v1.getAngle();
    }

    public String getString() {
        return String.valueOf(this.x) + ", " + this.y;
    }
}

