/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.gun;

import java.util.ArrayList;
import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.gun.Graph;
import vuen.fractal.gun.Gun;
import vuen.fractal.gun.Gunner;
import vuen.fractal.gun.SegmentGunGL;
import vuen.fractal.gun.Wave;
import vuen.fractal.gun.WaveHandler;
import vuen.fractal.gun.Waver;
import vuen.fractal.gun.axis.Acceleration;
import vuen.fractal.gun.axis.Axis;
import vuen.fractal.gun.axis.Distance;
import vuen.fractal.gun.axis.Lateral;
import vuen.fractal.gun.axis.Time;
import vuen.fractal.gun.axis.TimeSelf;
import vuen.fractal.util.BotMath;

public class SegmentGun
implements Gun,
WaveHandler {
    FractalE robot;
    Memory memory;
    Gunner gunner;
    public int enemy;
    SegmentGunGL gungl;
    public Waver waver;
    public Axis[] axis;
    Object data;
    boolean set;
    double angle;
    public static final double ANGLE_DIVISION = 1.0;
    public static final int ANGLE_AMOUNT = 70;
    public int totalbins = (int)Math.round(70.0) * 2 + 1;
    public static final double MIN_DATA_AMOUNT = 50.0;
    public static final double LOG_DATA_DIV = 5.0;
    ArrayList bins = new ArrayList();

    public SegmentGun(FractalE robot, Memory memory, Gunner gunner, int enemy) {
        this.robot = robot;
        this.memory = memory;
        this.gunner = gunner;
        this.enemy = enemy;
        this.waver = new Waver(robot, memory, this, enemy);
        this.axis = new Axis[5];
        this.axis[0] = new Distance();
        this.axis[1] = new Time();
        this.axis[4] = new Acceleration();
        this.axis[3] = new Lateral();
        this.axis[2] = new TimeSelf();
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].create(robot, memory, this, enemy);
        }
        robot.println("Creating Segmentation Tree for enemy " + enemy + " (depth: " + this.axis.length + ")");
        this.data = this.createAxis(0, new int[this.axis.length]);
        if (FractalE.glgraph) {
            this.gungl = new SegmentGunGL(FractalE.renderer, this);
        }
    }

    public Object createAxis(int a, int[] axis) {
        if (a == axis.length) {
            int[] newaxis = new int[axis.length];
            for (int i = 0; i < axis.length; ++i) {
                newaxis[i] = axis[i];
            }
            return new Graph(new float[this.totalbins + 1], newaxis, 0.0f);
        }
        int n = this.axis[a].getAmountOfBins() + 1;
        Object[] data = new Object[n];
        for (int i = 0; i < n; ++i) {
            axis[a] = i;
            data[i] = this.createAxis(a + 1, axis);
        }
        return data;
    }

    public void init() {
        this.set = false;
        if (FractalE.glgraph) {
            this.gungl.init();
        }
    }

    public void go() {
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].go();
        }
        this.waver.go();
    }

    public void shoot() {
        Packet enemy;
        this.set = false;
        if (this.robot.getGunHeat() <= this.robot.getGunCoolingRate() * 4.0 && !this.set && (enemy = this.memory.getPacket(this.memory.getTarget())) != null) {
            this.set = true;
            float[] bin = this.getBins();
            if (FractalE.glgraph) {
                this.gungl.draw(bin);
            }
            int angle = (int)Math.round(70.0);
            float value = 0.0f;
            for (int i = 0; i < this.totalbins; ++i) {
                if (!(bin[i] > value)) continue;
                angle = i;
                value = bin[i];
            }
            this.angle = (double)angle * 1.0 - 70.0;
            double newheading = enemy.heading + 90.0 * (BotMath.sign(enemy.velocity) - 1.0);
            double origin = BotMath.anglePoints(enemy.x, enemy.y, this.robot.getX(), this.robot.getY());
            double sign = BotMath.sign(BotMath.normalRelativeAngle(newheading - origin));
            this.angle *= sign;
            if (enemy.energy < 0.001) {
                this.angle = 0.0;
            }
        }
        if ((enemy = this.memory.getPacket(this.memory.getTarget())) != null) {
            this.robot.setTurnGunRight(BotMath.normalRelativeAngle(BotMath.anglePoints(enemy.x, enemy.y, this.robot.getX(), this.robot.getY()) - this.robot.getGunHeading() + this.angle));
            if (this.robot.getGunHeat() == 0.0) {
                if (BotMath.distancePoints(enemy.x, enemy.y, this.robot.getX(), this.robot.getY()) < 100.0) {
                    this.robot.setFire(1.0);
                } else if (this.robot.getEnergy() > 5.0 && this.robot.getGunTurnRemaining() < 1.0) {
                    this.robot.setFire(3.0);
                }
            }
        }
    }

    public float[] getBins() {
        Graph graph = null;
        Graph curmax = null;
        int curdim = -1;
        int i = 0;
        for (i = 0; i <= this.axis.length; ++i) {
            this.bins.clear();
            this.getCombos(this.bins, 0, i, this.data);
            for (int j = 0; j < this.bins.size(); ++j) {
                graph = (Graph)this.bins.get(j);
                if (!((double)graph.bin[this.totalbins] < 50.0)) continue;
                this.bins.remove(j--);
            }
            if (this.bins.size() <= 0) continue;
            curmax = this.sumBins(this.bins);
            curdim = i;
            break;
        }
        if (FractalE.glgraph) {
            this.gungl.setDepth(this.axis.length - curdim);
        }
        if (this.bins.size() == 0 || curmax == null) {
            return new float[this.totalbins + 1];
        }
        return curmax.bin;
    }

    public void getCombos(ArrayList bins, int depth, int freeDimensions, Object data) {
        if (depth == this.axis.length) {
            if (freeDimensions == 0) {
                bins.add((Graph)data);
            }
        } else {
            if (this.axis[depth].getBin() > -1) {
                this.getCombos(bins, depth + 1, freeDimensions, ((Object[])data)[this.axis[depth].getBin()]);
            }
            if (freeDimensions > 0) {
                this.getCombos(bins, depth + 1, freeDimensions - 1, ((Object[])data)[this.axis[depth].getAmountOfBins()]);
            }
        }
    }

    public Graph sumBins(ArrayList bins) {
        Graph graph = new Graph(new float[this.totalbins + 1], new int[this.axis.length], 0.0f);
        for (int num = 0; num < bins.size(); ++num) {
            int i;
            Graph temp = (Graph)bins.get(num);
            float bla = 0.0f;
            for (i = 0; i < this.axis.length; ++i) {
                bla += this.axis[i].getReliability(temp.axis[i]);
            }
            if (graph.reliability < bla) {
                graph.reliability = bla;
            }
            for (i = 0; i <= this.totalbins; ++i) {
                int n = i;
                graph.bin[n] = graph.bin[n] + temp.bin[i] / temp.bin[this.totalbins] * Math.max(bla, 0.0f);
            }
        }
        return graph;
    }

    public int[] getBinVals() {
        int[] bins = new int[this.axis.length];
        for (int i = 0; i < this.axis.length; ++i) {
            bins[i] = this.axis[i].getBin();
        }
        return bins;
    }

    public void doWave(Wave wave) {
        double angle = wave.getAngle();
        if (wave.wasEnemyStopped()) {
            this.add(angle, 0.5f, 0, wave, this.data);
            this.add(-angle, 0.5f, 0, wave, this.data);
        } else {
            this.add(angle, 1.0f, 0, wave, this.data);
        }
    }

    public void add(double angle, float amount, int depth, Wave wave, Object data) {
        if (depth == this.axis.length) {
            Graph graph = (Graph)data;
            float deviation = (float)(Math.toDegrees(30.0 / wave.getSize()) / 1.0);
            float pos = (float)((angle + 70.0) / 1.0);
            int max = (int)Math.min(Math.ceil(pos + 3.0f * deviation), (double)(this.totalbins - 1));
            for (int i = (int)Math.max(Math.floor(pos - 3.0f * deviation), 0.0); i <= max; ++i) {
                int n = i;
                graph.bin[n] = graph.bin[n] + (float)(1.0 / Math.sqrt(Math.PI * 2) / (double)deviation * Math.exp(-Math.pow((float)i - pos, 2.0) / 2.0 / (double)deviation / (double)deviation));
            }
            int n = this.totalbins;
            graph.bin[n] = graph.bin[n] + amount;
        } else {
            int i = wave.bins[depth];
            if (i > -1) {
                this.add(angle, amount, depth + 1, wave, ((Object[])data)[i]);
            }
            this.add(angle, amount, depth + 1, wave, ((Object[])data)[this.axis[depth].getAmountOfBins()]);
        }
    }
}

