package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;

public class SurfBufferG  extends SurfBuffer {
	private static double[][][][][][]surfStats = new double[BasicWaveSurfer.SEG_BULLET_POWER][BasicWaveSurfer.SEG_WALL_PROXIMITY][BasicWaveSurfer.SEG_ACCEL][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.SEG_DISTANCE][BasicWaveSurfer.BINS];
	public SurfBufferG(int weight) {
		super(weight);
	}
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegBulletPower(),wave.getSegWallProximity(), wave.getSegAccel(),wave.getSegAdvancingVelocity(),wave.getSegInitialDistance()));
	}
	
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 5)
			throw new IllegalArgumentException("args length must be 5");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]][args[3]][args[4]], this.getWeight());
	}

}
