package simonton.guns;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import simonton.utils.Util;

/*
 * Che - by Corbos (corbin@scatterbright.com)
 * 		my first mini
 * 
 * Thanks to everyone at robowiki.net. 
 * 
 * 1.0	Movement inspired by Tityus/RaikoMicro-type random oscillation
 * 		Gun == indexed pattern matcher
 * 1.1	Fixed a rammer bug
 * 1.2	Added a 'best of' selection to matched patterns. Too slow.
 */

public class CheGun extends Gun {

	private double _shotPower;
	private double _x;
	private double _y;
	
	// enemy info================
	private double _lastHeading = Double.MIN_VALUE;
	private double _lastVelocity;
	private long _lastScan;
	private Point2D.Double _enemyPosition;
	private double _lastEnemyDistance;

	// pattern matcher===================
	private PatternNode[] _nodeIndexes = new PatternNode[512];
	private PatternNode _head;
	private int _scanCount = 0;
	private static final double TEN_DEGREES = 10 * Math.PI / 180;
	private static final double TWENTY_DEGREES = TEN_DEGREES * 2;
	private static final char BREAK_SCAN = '\uffff';
	private static final int DEPTH = 20;
	private static final int MAX_DEPTH = 75;

	public void run() {
		super.run();

		insert(new PatternNode(BREAK_SCAN, _scanCount++, 0, 0));
	}

	public void onScannedRobot(ScannedRobotEvent sre) {
		super.onScannedRobot(sre);

		double heading = sre.getHeadingRadians();
		double velocity = sre.getVelocity();
		_x = getX();
		_y = getY();
		_lastEnemyDistance = sre.getDistance();
		double enemyHeading = getHeadingRadians() + sre.getBearingRadians();
		_enemyPosition = new Point2D.Double(Math.sin(enemyHeading)
				* _lastEnemyDistance + _x, Math.cos(enemyHeading)
				* _lastEnemyDistance + _y);

		if (sre.getEnergy() > 0 && _lastHeading != Double.MIN_VALUE) {

			double ticks = (double) (getTime() - _lastScan);
			double headingDelta = Utils.normalRelativeAngle(heading
					- _lastHeading)
					/ ticks;
			double velocityDelta = (velocity - _lastVelocity) / ticks;

			for (double i = 1; i < ticks + 1; i++) {
				record(_lastVelocity + velocityDelta * i, headingDelta);
			}
		}

		// ==============
		_lastScan = getTime();
		_lastHeading = heading;
		_lastVelocity = velocity;

		_shotPower = getNextBulletPower();

		//if(getGunHeat() < 0.5){
			Point2D.Double nextLocation = project(sre.getHeadingRadians(),
					20 - 3 * _shotPower);
			if (nextLocation != null) {
				_enemyPosition = nextLocation;
			}
		//}
		setTurnGunRightRadians(Utils.normalRelativeAngle(Math.atan2(
				_enemyPosition.x - _x, _enemyPosition.y - _y)
				- getGunHeadingRadians()));

	}

	/*
	 * =================================================================================
	 * Pattern matcher - 512 character alphabet Basically a doubly-linked
	 * sequence with linked indexes, pretty fast. Lots of work to do.
	 * =================================================================================
	 */
	public void record(double velocity, double headingDelta) {
		int index = (((int) ((velocity + 8) * 15 / 16) << 5) | ((int) ((headingDelta + TEN_DEGREES) * 31 / TWENTY_DEGREES)));
		PatternNode node = new PatternNode((char) index, _scanCount++,
				velocity, headingDelta);
		insert(node);
		node.IndexRef = _nodeIndexes[index];
		_nodeIndexes[index] = node;
	}

	private void insert(PatternNode node) {
		node.SequenceRef = _head;
		_head = node;
		if (node.SequenceRef != null) {
			node.SequenceRef.ReverseSequenceRef = node;
		}
	}

	public Point2D.Double project(double currentHeading, double bulletVelocity) {

		PatternNode cursor;
		PatternNode currentSymbol = _head;
		PatternNode t, p;
		PatternNode indexSymbol = _head.IndexRef;
		PatternNode[] bestNodes = new PatternNode[DEPTH];
		int depth;

		while (indexSymbol != null
				&& currentSymbol.Index - indexSymbol.Index < 50000) {

			cursor = indexSymbol;
			depth = 0;

			while (currentSymbol.Index - indexSymbol.Index > 25
					&& currentSymbol != null && cursor != null
					&& currentSymbol.Symbol == cursor.Symbol
					&& depth < MAX_DEPTH) {
				currentSymbol = currentSymbol.SequenceRef;
				cursor = cursor.SequenceRef;
				depth++;
			}

			// crappy bubble sort deal that needs to go.
			// expedient, i guess
			if (depth > 0) {
				p = indexSymbol;
				p.Depth = depth;
				for (int i = 0; i < DEPTH; i++) {
					if (bestNodes[i] == null) {
						bestNodes[i] = p;
						break;
					}
					if (p.Depth > bestNodes[i].Depth) {
						t = bestNodes[i];
						bestNodes[i] = p;
						p = t;
					}
				}
			}

			currentSymbol = _head;
			indexSymbol = indexSymbol.IndexRef;
		}

		for (int i = 0; i < DEPTH && bestNodes[i] != null; i++) {

			double projectedTime = 0;
			double enemyX = _enemyPosition.x;
			double enemyY = _enemyPosition.y;
			double ch = currentHeading;

			bestNodes[i] = bestNodes[i].ReverseSequenceRef;
			while (bestNodes[i] != null
					&& Point2D.distance(_x, _y, enemyX, enemyY) > projectedTime
							* bulletVelocity
					&& bestNodes[i].Symbol != BREAK_SCAN) {
				ch += bestNodes[i].HeadingDelta;
				enemyX += Math.sin(ch) * bestNodes[i].Velocity;
				enemyY += Math.cos(ch) * bestNodes[i].Velocity;
				projectedTime++;
				bestNodes[i] = bestNodes[i].ReverseSequenceRef;
			}
			if (bestNodes[i] != null && bestNodes[i].Symbol != BREAK_SCAN) {
				return new Point2D.Double(enemyX, enemyY);
			}
		}
		return null;
	}

	private static class PatternNode {

		public PatternNode IndexRef;
		public PatternNode SequenceRef;
		public PatternNode ReverseSequenceRef;
		public char Symbol;
		public double Velocity;
		public double HeadingDelta;
		public int Index;
		public int Depth;

		public PatternNode(char s, int index, double v, double hd) {
			Symbol = s;
			Index = index;
			Velocity = v;
			HeadingDelta = hd;
		}
	}
}
