package hamilton;

import robocode.*;

public class VirtualWave extends Condition 
{
	AdvancedRobot r;
	Target t;
	double firingTime;
	double bulletVelocity;
	Coordinate origin;
	
	double targetOriginalDistance;
	double targetAbsoluteBearing;
	double targetRelativeHeading;
	double targetVelocity;
	double targetAcceleration;
	double targetChangeInHeading;
	
	double linearPrediction;
	double maxLinearPrediction;
	
	public VirtualWave(AdvancedRobot someR, Target someT, double someTime, Coordinate someOrigin, double someFirepower)
	{
		r = someR;
		t = someT;
		firingTime = someTime;
		bulletVelocity = 20 - (someFirepower * 3);
		origin = someOrigin;
		
		targetOriginalDistance = origin.distanceFrom(t.getCoordinates());
		targetAbsoluteBearing = origin.absoluteBearingTo(t.getCoordinates());
		targetRelativeHeading = Calculator.relativeAngle(t.getAbsoluteHeading() - targetAbsoluteBearing);
		targetVelocity = t.getAbsoluteVelocity();
		targetAcceleration = t.acceleration;
		targetChangeInHeading = t.changeInHeading;
		
		linearPrediction = Math.asin(Math.sin(targetRelativeHeading) * 8 / bulletVelocity);
		maxLinearPrediction = Math.asin(8 / bulletVelocity);
		
		r.addCustomEvent(this);
	}
	
	public boolean test()
	{
		double elapsedTime = t.getTimeStamp() - firingTime;

		double radius = (elapsedTime * bulletVelocity);
		
		double targetDistance = origin.distanceFrom(t.getCoordinates());
		
		double difference = Math.abs(targetDistance - radius);
		
		if (difference <= r.getWidth())
		{
			double currentAbsoluteBearing = origin.absoluteBearingTo(t.getCoordinates());
			double theta = Calculator.relativeAngle(currentAbsoluteBearing - targetAbsoluteBearing);
			
			double factor = .5 - (theta / (maxLinearPrediction * 2));
			
			// System.out.println(targetOriginalDistance + "," + targetRelativeHeading + "," + targetVelocity + "," + targetAcceleration + "," + targetChangeInHeading + ","+ linearPrediction + "," + maxLinearPrediction + "," + theta + "," + factor);
			
			r.removeCustomEvent(this);
		}

		else if (radius > targetDistance)
		{
			r.removeCustomEvent(this);
		}
		
		return false;
	}
}
