package davidalves.net;

import java.awt.Color;
import java.awt.geom.Point2D;

import robocode.*;

public class DuelistNanoMelee extends AdvancedRobot
{	
	//Minimum distance from wall
	static final double wallMargin = 22.0;
	
	//How far from the corner our corner movement should be
	static final double cornerMargin = 125.0;
	
	//How long each movement should be, in ticks
	static final int movementTimer = 20;
	
	public void run()
	{	
		/*
		 * I gave up a lot to get them in here this time, but I refuse to leave out my colors. :-)
		 */
		
		setColors(Color.darkGray, Color.darkGray, Color.cyan);
		
		do{
			turnRadarRightRadians(1);
		}while(true);

	}

	public void onScannedRobot(ScannedRobotEvent e)
	{
		double b, myX, myY, destinationX, destinationY, turnAngle, normalizedTurnAngle;
		
		/*
		 * Drive back and forth between (25, 125) and (125, 25)
		 */
		
		destinationY = 2.0 * wallMargin + cornerMargin - (destinationX = wallMargin + cornerMargin * ((getTime() / movementTimer) % 2));
		
		/*
		 * Flip the destination point horizontally or vertically so that we use the closest corner.
		 */
		
		if((myX = getX()) > 500.0)
			destinationX = getBattleFieldWidth() - destinationX;

		if((myY = getY()) > 500.0)
			destinationY = getBattleFieldHeight() - destinationY;
		
		/*
		 * Standard code to drive to a destination. Thanks to nano and Dummy for helping me squeeze it down
		 * to such a tiny size! :-)
		 */
		
		setTurnRightRadians(normalizedTurnAngle = Math.atan(Math.tan(turnAngle = ((Math.atan2(destinationX - myX, destinationY - myY) - (b = getHeadingRadians())) + (7.0 * Math.PI)) % (2.0 * Math.PI) - Math.PI)));
		
		setAhead((turnAngle == normalizedTurnAngle ? 100.0 : -100.0));
		
		/*
		 * By using this code for a large radar arc, we'll always be switching to the closest target, since
		 * ScannedRobotEvents are sorted by distance (closest first) and we end our turn after reacting to 
		 * the first one. Since we're in the corner all the time, a 45 degree scan arc is plenty - no need to
		 * sweep the radar.
		 */
		
		setTurnRadarRightRadians(3.0 * Math.sin((b += e.getBearingRadians()) - getRadarHeadingRadians()));
		
		/*
		 * Shoot directly at the target. So what if we don't hit bullet dodgers? They're no good
		 * in melee anyway. :-) 
		 */
		
		setTurnGunRightRadians(Math.sin(b - getGunHeadingRadians()));
		
		
		//Testing if we have enough energy to fire actually seems to lower our score on average, 
		//so just fire all the time. I love things that save space and work better. :-)
		
		fire(getEnergy() * 25.0 / e.getDistance());
	}
}
