/*
 * EnemyCache.java
 *
 * Created on 15 maart 2004, 8:51
 */

package vic;
import robocode.*;
/**
 *
 * @author  Vic Stewart
 */
public class EnemyCache extends Base
{
    double currentHeading;
    double currentVelocity, lastVelocity;
    double enemyX, enemyY;
    double energy;
    long lastScanTime;
    long streakTime = 0;
    

    boolean PosDir=true, PreviousPosDir=true;
    void scanned(long time, double velocity, double heading, double bearing, double distance, double meX, double meY, double meHeading, double pEnergy)
    {
        energy = pEnergy;
        
        lastScanTime = time;
        lastVelocity = currentVelocity;
        
            //streaktime: time in same direction
        if(velocity > 0)
        {
            PosDir = true;
            currentHeading = heading;
            currentVelocity = velocity;
        }
        else if(velocity == 0)
        {
            PosDir = PreviousPosDir;
            if(PosDir)
            {
                currentHeading = heading;
                currentVelocity = velocity;
            }
            else
            {
                currentHeading  = reverseHeading(heading);
                currentVelocity = -velocity;
            }
        }
        else
        {
            PosDir = false;
            currentHeading  = reverseHeading(heading);
            currentVelocity = -velocity;
        }
        
            //time since last velocity change
        if(Math.round(currentVelocity) != Math.round(lastVelocity))
        {
            streakTime = 0;
        }
        else
        {
            streakTime++;
        }
        PreviousPosDir = PosDir;
        
        enemyX = calcX(meX, meHeading + bearing, distance);
        enemyY = calcY(meY, meHeading + bearing, distance);
        enemyX += (Math.sin(currentHeading) * currentVelocity);
        enemyY += (Math.cos(currentHeading) * currentVelocity);
        checkInBattlefield(enemyX,enemyY);
    }
    
    double calcX(double meX, double bearing, double distance)
    {
        return meX + (Math.sin(bearing) * distance);
    }
    
    double calcY(double meY, double bearing, double distance)
    {
        return meY + (Math.cos(bearing) * distance);
    }
    double getX()
    {
        return enemyX;
    }
    double getY()
    {
        return enemyY;
    }
    double getDistance(double x, double y)
    {
        return getDistance(enemyX, enemyY, x, y);
    }
    double getCurrentHeading()
    {
        return currentHeading;
    }
    double getEnergy()
    {
        return energy;
    }    
    
    void checkInBattlefield(double x, double y)
    {
        if (x < getHalfRobotWidth()                         ) x = getHalfRobotWidth();
        if (x > getBattlefieldWidth()  - getHalfRobotWidth()) x = getBattlefieldWidth() - getHalfRobotWidth();
        if (y < getHalfRobotWidth()                         ) y = getHalfRobotWidth();
        if (y > getBattlefieldHeight() - getHalfRobotWidth()) y = getBattlefieldHeight() - getHalfRobotWidth();
    }
    
    double reverseHeading(double heading)
    {
        if(heading > Math.toRadians(180))
        {
            return heading - Math.toRadians(180);
        }
        else
        {
            return heading + Math.toRadians(180);
        }
    }
    
    void adjustTime(long time)
    {
        enemyX += (Math.sin(currentHeading) * currentVelocity * (double)(time-lastScanTime));
        enemyY += (Math.cos(currentHeading) * currentVelocity * (double)(time-lastScanTime));
        checkInBattlefield(enemyX,enemyY);
        lastScanTime = time;
    }
}
