package blir.mini.oops;

import robocode.*;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.Queue;

import static robocode.util.Utils.*;

/**
 * Splooshlu - a robot by Travis Bruce
 */
public class Splooshlu extends AdvancedRobot {

	private static final double D = 36D;
	private static final double theta = Math.PI / 3D;
	// private static final double DP = D / Math.cos(theta);

	private final Queue<Double> enemyPowerHistory = new LinkedList<Double>();
	private final Queue<Integer> tdHist = new LinkedList<Integer>();
	private int myShots, myHits, lastMyHits;
	private int enemyShots, enemyHits, lastEnemyHits;
	private int td, tf, tb;
	private int dir = 1;
	private boolean wall/* , rbt */;
	private double enemyEnergy = 100D;
	private double avgPower;
	private boolean fireMode, dodgeMode = true;

	/**
	 * run: Splooshlu's default behavior
	 */
	@Override
	public void run() {
		setColors(Color.BLACK, Color.GREEN, Color.GREEN, Color.GREEN, null);
		setAdjustRadarForRobotTurn(true);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		for (;;) {
			if (getRadarTurnRemaining() == 0) {
				// should only happen if we lose track of them, which should
				// never happen
				setTurnRadarRight(Double.POSITIVE_INFINITY);
			}
			// check if we're too close to the wall (50 pixels)
			wall = checkwall(50, true);
			execute();
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	@Override
	public void onScannedRobot(ScannedRobotEvent e) {

		// rbt = d(e.getDistance());

		// absolute bearing
		double absBear = getHeadingRadians() + e.getBearingRadians();

		// track them with our radar
		double radarTurn = normalRelativeAngle(absBear
				- getRadarHeadingRadians());
		radarTurn += (radarTurn < 0 ? -1 : 1)
				* Math.atan(36.0 / e.getDistance());
		setTurnRadarRightRadians(radarTurn);

		double enemyPower = enemyEnergy - e.getEnergy();
		boolean enemyFired = enemyPower > 0 && enemyPower <= 3;

		avgPower = avgQueue(enemyPowerHistory, new Double(enemyPower),
				enemyFired);
		double dodgeRate = enemyShots == 0 ? 1D : dodgeRate();
		double hitRate = myShots == 0 ? 1D : hitRate();

		td = (int) avgQueue(tdHist, dodge(getVelocity(), D), true);
		double shortestDistance = Rules.getBulletSpeed(avgPower) * td;
		tf = (int) Math.round((1D + enemyPower / 5) / 0.1D);
		tb = (int) Math.round(e.getDistance()
				/ Rules.getBulletSpeed(enemyPower));
		double longestDistance = 2D * Rules.getBulletSpeed(avgPower) * tf;

		if (hitRate < 0.10D && myShots > 10) {
			out.println("Switching firing modes.");
			fireMode = !fireMode;
			myShots = 0;
			myHits = 0;
		}

		if (dodgeRate < 0.90D && enemyShots > 5) {
			out.println("Switching dodge modes.");
			dodgeMode = !dodgeMode;
			enemyShots = 0;
			enemyHits = 0;
		}

		if (enemyFired) {
			enemyShots++;
			// out.printf("Enemy Fired! (TD=%d,TF=%d,TB=%d,Dodge=%b,Fire=%b)\n",
			// td, tf, tb, dodgeMode, fireMode);
			if (dodgeMode && !checkwall(75, false) && td < tb) {
				changeDir("bullet");
			}
		}

		enemyEnergy = e.getEnergy();

		setTurnRightRadians(normalRelativeAngle(e.getBearingRadians()
				+ Math.PI
				/ 2D
				+ dir
				* (e.getDistance() > shortestDistance ? (e.getDistance() < longestDistance ? 0
						: -theta)
						: theta)));

		double power = e.getDistance() < shortestDistance ? Rules.MAX_BULLET_POWER
				: Math.min(
						Math.max(
								(20D - e.getDistance()
										/ dodge(e.getVelocity(), D)) / 3D,
								Rules.MIN_BULLET_POWER)
								+ 2D * hitRate, Rules.MAX_BULLET_POWER);

		double maxLead = Math.asin(e.getVelocity()
				* Math.sin(Math.PI - absBear + e.getHeadingRadians())
				/ Rules.getBulletSpeed(getEnergy() > power ? power
						: getEnergy()));
		setTurnGunRightRadians(normalRelativeAngle(absBear
				- getGunHeadingRadians() - (fireMode ? maxLead : 0)));

		if (getGunHeat() == 0) {
			// out.printf("To arms! (TD=%d,TB=%d) ", dodge(e.getVelocity(), D),
			// (int) Math.round(e.getDistance()
			// / Rules.getBulletSpeed(power)));
			// out.printf("Hit Rate: %.2f ", hitRate);
			// out.printf("Dodge Rate: %.2f ", dodgeRate);
			// out.printf("Average Power: %.1f ", avgPower);
			// out.printf("Power: %.3f", power);
			// out.println();
			myShots++;
		}

		// fire!
		setFire(power);

		// all power ahead!
		setAhead(dir * 32);

		absBear = normalRelativeAngle(absBear);
		r = (int) shortestDistance;
		r2 = (int) longestDistance;
		x = (int) (getX() + Math.sin(absBear) * e.getDistance());
		y = (int) (getY() + Math.cos(absBear) * e.getDistance());
	}

	@Override
	public void onHitWall(HitWallEvent e) {
		changeDir("hit wall");
	}

	/*
	 * private boolean d(double d) { if (d < 150) { // we're close to the robot
	 * (within 150 pixels) if (!rbt) { // we're not already escaping the robot,
	 * so let's change // direction changeDir("robot"); } return true; } return
	 * false; }
	 */

	private boolean checkwall(int d, boolean changeDir) {
		if (getX() < d || getY() < d || getBattleFieldWidth() - getX() < d
				|| getBattleFieldHeight() - getY() < d) {
			// we're close to the wall
			if (!wall && changeDir) {
				// we're not already escaping the wall, so let's change
				// direction
				changeDir("wall");
			}
			return true;
		}
		return false;
	}

	private void changeDir(String reason) {
		// out.printf("changing dir due to %s\n", reason);
		dir = -dir;
	}

	@Override
	public void onHitByBullet(HitByBulletEvent e) {
		if (!checkwall(75, false)) {
			enemyHits++;
		}
	}

	@Override
	public void onBulletHit(BulletHitEvent e) {
		myHits++;
	}

	private int dodge(double velocity, double d) {
		double untilZero = Math.abs(velocity) / Rules.DECELERATION;
		double dDuringDecel = 0.5D * Rules.DECELERATION * untilZero * untilZero;
		d += dDuringDecel;
		double untilMax = Math.abs(Rules.MAX_VELOCITY) / Rules.ACCELERATION;
		double dDuringAccel = 0.5D * Rules.ACCELERATION * untilMax * untilMax;
		if (dDuringAccel > d) {
			return (int) Math.round(untilZero + untilMax);
		}
		double untilD = (d - dDuringAccel) / Rules.MAX_VELOCITY;
		return (int) Math.round(untilZero + untilMax + untilD);
	}

	private static <T extends Number> double avgQueue(Queue<T> queue, T entry,
			boolean b) {
		if (b) {
			if (queue.size() == 10) {
				queue.poll();
			}
			queue.offer(entry);
		}
		double sum = 0;
		for (Number d : queue) {
			sum += d.doubleValue();
		}
		return sum / 10D;
	}

	private double hitRate() {
		double hitRate = (double) myHits / myShots;
		if (myShots == 10) {
			lastMyHits = myHits;
		}
		if (myShots == 20) {
			myShots = 10;
			myHits -= lastMyHits;
		}
		return hitRate;
	}

	private double dodgeRate() {
		double dodgeRate = (double) enemyHits / enemyShots;
		if (enemyShots == 10) {
			lastEnemyHits = enemyHits;
		}
		if (enemyShots == 20) {
			enemyShots = 10;
			enemyHits -= lastEnemyHits;
		}
		return 1D - dodgeRate;
	}

	private int x, y, r, r2;

	@Override
	public void onPaint(Graphics2D g) {
		g.setColor(Color.ORANGE);
		g.drawOval(x - r, y - r, 2 * r, 2 * r);
		g.setColor(Color.RED);
		g.drawOval(x - r2, y - r2, 2 * r2, 2 * r2);
	}
}
