package theo;
import robocode.*;
import java.awt.Color;
import java.util.*;
import java.awt.geom.*;
import java.awt.Graphics2D;

/**
 * QuarkSoup - a robot by Theo
 */

//Maybe only aim right when we're about to shoot
public class QuarkSoup extends AdvancedRobot implements SetTypes
{

	final boolean isTC = false;
	final boolean isMC = false;

	Opponent enemy;
	Utilities utils;
	HeatWave gWave;
	DodgeWave sWave;
	
	final Color purple = Color.getHSBColor(0.8f, 0.9f, 0.8f);
	final Color puce = new Color(190,255,0);
	
	Random duck = new Random();
	
	Rectangle2D.Double playField;
	
	///OUR STATS///
	double x,y,bPower;
	Point2D.Double position;
	double heading, velocity;
	int lastDirection;

	public boolean setTypes(QuarkSoup qS){
		try {
			
			enemy = new Opponent();
			utils = new Utilities(qS, enemy);
			gWave = new HeatWave(qS, enemy, utils);
			sWave = new DodgeWave(qS, enemy, utils);
			
			return false;

		}
		catch (Exception e){
			out.println(e.getMessage());
		} return true;
	}

	public void run() {
		// Initialization of the robot should be put here

		setColors(puce,purple,puce);
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		playField = new Rectangle2D.Double(18,18,getBattleFieldWidth()-36,getBattleFieldHeight()-36);
		
		setTypes(this);

		
		while(true) {
			//This: abnormalCode-->movement
			turnRadarRight(Double.POSITIVE_INFINITY);
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		enemy.energy = e.getEnergy();
		
		updateSelf();
		
		enemy.distance = e.getDistance();
		enemy.heading = e.getHeadingRadians();
		enemy.velocity = e.getVelocity();
		enemy.bearing = e.getBearingRadians();
		enemy.heading = e.getHeadingRadians();
		
		enemy.absBearing = heading + enemy.bearing;
		enemy.absBearing = utils.normaliseBearing(enemy.absBearing);
		
		enemy.position = utils.getEnemyPosition(enemy.distance, enemy.absBearing);
		
		enemy.lateralHeading = utils.normaliseAngle(enemy.heading - enemy.absBearing);
		enemy.lateralVelocity = enemy.velocity * Math.sin(enemy.lateralHeading);
		
		if(enemy.lateralVelocity!=0){
			enemy.lateralDirection = (int)(utils.sign(enemy.lateralVelocity));
			lastDirection = new Double(enemy.lateralDirection).intValue();
		}
		else{ enemy.lateralDirection = (int)lastDirection; }
		
		
		
		double radarOffset = utils.normaliseBearing(
				utils.normaliseAngle(enemy.absBearing)-
				utils.normaliseAngle(getRadarHeadingRadians()));
		setTurnRadarRightRadians(radarOffset*2);
		
		sWave.update();
		gWave.update();
	
	}
	
	public void updateSelf(){
		heading = getHeadingRadians();
		velocity = getVelocity();
		x = getX(); y = getY();
		position = new Point2D.Double(x,y);
		bPower = 2;
		if(isMC) bPower = 3;
		if(enemy.energy<16&!isMC)
			bPower = utils.limit(.1,enemy.energy/5,3);
		
	}
	

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		sWave.onHit(e.getBullet());
	}
	public void onBulletHitBulletEvent(BulletHitBulletEvent e){
		sWave.onHit(e.getBullet());
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
		
	}
	
	public void onPaint(Graphics2D g){
		
		gWave.paint(g);
		sWave.paint(g);
		
	}
		
}

class Opponent{
	
	double x;
	double y;
	Point2D.Double position;
	
	double energy;
	double bearing;
	double heading;
	double distance;
	double velocity;
	double predictedPosition;
	double absBearing;
	double lateralHeading;
	double lateralVelocity;
	double lateralDirection;

}

class Utilities{
	
	double PI = Math.PI;
	double gunOffset, deltaX, deltaY;
	
	Opponent e;
	QuarkSoup qS;
	
	double predictX, predictY;
	double timeSteps, bulletFlightTime;
	double antDistance; double bulletSpeed;
	double allowedDistance;
	Point2D.Double startPosition, nextPosition;
	
	String alphabet = "abcdefghijklmnopqrstuvwxyz";
	
	//This is a constructor method
	//This method is called when we initialise this class up there ^^
	//Consider it like the main(String[] args) method if this were a
			//standalone class.
	//Check out the two arguments we give this class when we call it from the SketchBall class.
	//We give this class a way to reference both the Sketchball class, and the Opponent class.
	Utilities(QuarkSoup type, Opponent type2){
		qS = type;
		e = type2;
	}
	
	//A constructor method will always have the form
	//ClassName(){ }
	//Nothing else. The Class's name here happens to be 'Utilities', and we fed it some arguments

	public double normaliseBearing(double bearing){
		if(bearing<-PI)
			return (bearing+2*PI);
		if(bearing>PI)
			return (bearing-2*PI);
		return bearing;
	}
	
	public double normaliseAngle(double angle){
		if(angle<0)
			return (angle+PI*2);
		if(angle>2*PI)
			return (angle-2*PI);
		return angle;
	}
	
	public double bSpeed(double power){
		return (20-3*power);
	}
	
	public Point2D.Double project(Point2D.Double source, double distance, double angle){
		return new Point2D.Double(source.x + distance*Math.sin(angle),
			source.y + distance*Math.cos(angle));
	}
	public Point2D.Double project(double x, double y, double distance, double angle){
		return new Point2D.Double(x + distance*Math.sin(angle),
			y + distance*Math.sin(angle));
	}
	
	public Point2D.Double correctPosition(Point2D.Double pos){
		pos.x = limit(18,pos.x,qS.getBattleFieldWidth()-18);
		pos.y = limit(18,pos.y,qS.getBattleFieldHeight()-18);
		return pos;
	}
	
	public double limit(double low, double med, double high){
		if(low<=high)
			return Math.min(Math.max(low,med),high);
		else
			return Math.max(Math.min(low,med),high);	
	}
	
	public Point2D.Double getEnemyPosition(double dist, double angle){
		return project(qS.position, dist, angle);
	}

	public double predictPosition(){
		
		deltaX = e.distance*Math.sin(e.absBearing);
		deltaY = e.distance*Math.cos(e.absBearing);
		
		e.x = deltaX + qS.position.x;
		e.y = deltaY + qS.position.y;
	
		gunOffset = Math.atan2(deltaX,deltaY);
		gunOffset -= qS.getGunHeadingRadians();
		gunOffset = normaliseBearing(gunOffset);
			
		antDistance = e.distance;
		bulletSpeed = bSpeed(qS.bPower);
		bulletFlightTime = antDistance/bulletSpeed;
		
		allowedDistance = e.velocity*bulletFlightTime;
		
		startPosition = new Point2D.Double(e.x,e.y);
		
		for(int i = 0; i < 10; i ++){
			nextPosition = project(startPosition, allowedDistance, e.heading);
			antDistance = nextPosition.distance(qS.position);
			bulletFlightTime = antDistance/bulletSpeed;
			allowedDistance = e.velocity*bulletFlightTime;
		}
		
		if(!qS.playField.contains(nextPosition)){
			nextPosition = correctPosition(nextPosition);
		}
		
		gunOffset = Math.atan2(nextPosition.x-qS.position.x,nextPosition.y-qS.position.y);
		gunOffset -= qS.getGunHeadingRadians();
		gunOffset = normaliseBearing(gunOffset);
		
		return gunOffset;

	}
	
	double width, height;
	
	public double GreatestDistance(){
		width = qS.playField.getWidth();
		height = qS.playField.getHeight();
		return Math.sqrt(width*width+height*height);
	}
	
	public StringBuilder appendState(StringBuilder state){
		HeatWave current = qS.gWave;
		state = state.append(toString(current.dH));
		state = state.append(toString(current.fP));
		state = state.append(toString(current.d));
		state = state.append(toString(current.v));
		state = state.append(toString(current.lH));
		state = state.append(toString(current.bP));
		state = state.append(toString(current.lD));
		state = state.append(toString(current.nW));
		state = state.append(toString(current.lv));
		state = state.append(toString(current.llD));
		state = state.append(toString(current.sV));
		state = state.append(toString(current.lsV));
		return state;
	}

	public String toString(int num){
		char letter = alphabet.charAt(num%26);
		return new Character(letter).toString();
	}
	
	public double maxEscapeAngle(){
		return Math.asin(8/bSpeed(qS.bPower));
	}
	public double maxEscapeAngle(double vel){
		return Math.asin(8/vel);
	}
	
	public double getOffset(Point2D.Double pos, Point2D.Double tar, HeatWave wave){
		return limit(-1,normaliseBearing(absAngle(pos,tar)-wave.absBearing)/wave.maxEscapeAngle,1);
	}
	public double getOffset(Point2D.Double pos, Point2D.Double tar, DodgeWave wave){
		return limit(-1,normaliseBearing(absAngle(pos,tar)-wave.angleFromEnemy)/wave.maxEscapeAngle,1);
	}
	
	public double absAngle(Point2D.Double source, Point2D.Double target){
		return normaliseAngle(Math.atan2(target.x-source.x,target.y-source.y));
	}
	
	public double absBearing(Point2D.Double source, Point2D.Double target){
		return normaliseBearing(Math.atan2(target.x-source.x,target.y-source.y));
	}

	public double sign(double num){
		return(num>=0?1:-1);
	}

}

class HeatWave{
	
	QuarkSoup qS; Opponent enemy; Utilities utils;
	static HeatWave wave;
	int v,lv,d,lH,bP,nW,lD,llD,fP,sV,lsV,dH;
	static int vSegs,dSegs,lHsegs,bPsegs,specificVSegs;

	HeatWave(QuarkSoup type1, Opponent type2, Utilities type3){
		qS = type1; enemy = type2; utils = type3;
		stateNameArray = new String[]{"a","b","c","d","e"};
	}
	HeatWave(){

	}
	
	List<HeatWave> _gunGroup = new ArrayList<HeatWave>();
	String[] stateNameArray;

	StringBuilder stateBuilder;
	String state;
	
	double bSpeed, distance;
	double distTraveled, timeTillHit;
	double shotTime, currentTime;
	double timeSinceShot, absBearing, maxEscapeAngle;
	Point2D.Double shotLocation;

	static{
		vSegs = (dSegs = (lHsegs = 5));
		bPsegs = 3; specificVSegs = 9;
		stateMap = new HashMap<String,double[]>();
		offsetMap = new HashMap<String,List<Double>>();
	}
	
	public void paint(Graphics2D g){
		g.setColor(Color.green);
		g.drawOval(new Double(qS.getX() - 25).intValue(), new Double(qS.getY() - 25).intValue(), 50, 50);
		double radius = 0;

		for(HeatWave toPaint: _gunGroup){
			radius = toPaint.distTraveled + toPaint.bSpeed;
			
			g.drawOval(new Double(toPaint.shotLocation.getX() - (radius)).intValue(),
				new Double(toPaint.shotLocation.getY() - (radius)).intValue(),
					new Double(radius*2).intValue(), new Double(radius*2).intValue());
		}
	}
	
	public void update(){
		if(!qS.isTC){
			setSegmentation();
			
			advanceGunWaves();
			
			stateBuilder = new StringBuilder("");
			
			stateBuilder = utils.appendState(stateBuilder);
			state = stateBuilder.toString();
			
			checkSpawnGunWave();
			if(qS.getEnergy()>0){	
				qS.setTurnGunRightRadians(utils.normaliseBearing(getIdealBearing()-
					qS.getGunHeadingRadians()));
			}
		}
	}
	double lastHeading = 0;
	public void setSegmentation(){
		lv = v;
		lsV = sV;
		v = (int)Math.round(utils.limit(0,enemy.velocity/2,vSegs));
		d = (int)Math.round(enemy.distance/(utils.GreatestDistance()/4));
		lH = (int)Math.round(Math.abs(enemy.lateralHeading)/(5/(PI/2)));
		bP = (int)Math.round(qS.bPower);
		lD = (int)enemy.lateralDirection+1;
		fP = (int)Math.round(utils.sign(utils.normaliseBearing(PI+enemy.absBearing-enemy.heading)))+1;
		sV = (int)Math.abs(enemy.velocity);
		if(enemy.position!=null)
		nW = (int)(qS.playField.contains(utils.project(enemy.position,enemy.distance/utils.bSpeed(qS.bPower)
			*8*lD*utils.sign(enemy.lateralHeading),enemy.heading))?1:0);
		else nW = 1;
		dH = (int)Math.abs(Math.round((enemy.heading-lastHeading)/(PI/78)));
		lastHeading = enemy.heading;
	}
	
	
	double latDir; boolean fireToDeath = false; long fireTime = 0;
	//Point2D.Double ourNextPos, enemyNextPos;
	
	public void checkSpawnGunWave(){
		if(qS.isMC) fireToDeath = true;
		/*if(qS.getGunTurnRemainingRadians()==0&&qS.getGunHeat()==0&&(qS.getEnergy()>qS.bPower|fireToDeath)&qS.getEnergy()>0){
			fire();
			fireTime = qS.getTime() + 1;
		}*/
		if(qS.getGunTurnRemainingRadians()==0&&qS.getGunHeat()==0&&(qS.getEnergy()>qS.bPower|fireToDeath)&qS.getEnergy()>0){
			HeatWave gW = new HeatWave();
			
			//ourNextPos = utils.project(qS.position,qS.velocity,qS.heading);
			//enemyNextPos = utils.project(enemy.position,enemy.velocity,enemy.heading);

			gW.bSpeed = utils.bSpeed(qS.bPower);
			gW.distance = enemy.distance;
			gW.distTraveled = 0;
			gW.timeTillHit = distance/bSpeed;
			gW.shotTime = (double)qS.getTime()+1;
			gW.currentTime = shotTime;
			gW.timeSinceShot = 0;
			gW.shotLocation = qS.position;
			gW.state = stateBuilder.toString();
			gW.absBearing = enemy.absBearing;
			gW.maxEscapeAngle = utils.normaliseBearing(utils.maxEscapeAngle(gW.bSpeed)) * enemy.lateralDirection;
			gW.latDir = enemy.lateralDirection;
			
			_gunGroup.add(gW);
			
			shotTimer = qS.getTime();
			
			llD = lD;
			
			fire();
		}
	}
	
	public void fire(){
		qS.setFire(qS.bPower);
	}

	public void advanceGunWaves(){
		for(int i = 0; i < _gunGroup.size(); i ++){
			
			wave = _gunGroup.get(i);
			
			try{
				wave.timeSinceShot = qS.getTime() - wave.shotTime;
				wave.distTraveled = wave.bSpeed * wave.timeSinceShot;
				wave.distance = enemy.position.distance(wave.shotLocation);
				
							
				i = checkWave(wave, i);
			}
			catch(NullPointerException e){}
			
		}
	}
	
	public int checkWave(HeatWave wave, int index){
		if(wave.distTraveled>wave.distance){
			storeOffset(wave);
			_gunGroup.remove(index);
			index --;
		}
		return index;
	}
	
	static HashMap<String,double[]> stateMap;
	List<Double> _offsetGroup = new ArrayList<Double>();
	double sDev, PI = Math.PI, multiplier;
	StringBuilder buildKey = new StringBuilder("");
	static HashMap<String,List<Double>> offsetMap;
	
	public void storeOffset(HeatWave wave){
		
		double offset = utils.getOffset(wave.shotLocation, enemy.position, wave);
		_offsetGroup.clear();
		StringBuilder storeKey = new StringBuilder(wave.state);
		for(int i = storeKey.length()-1; i > -2; i --){
			if(offsetMap.containsKey(storeKey.toString())){
				_offsetGroup = offsetMap.get(storeKey.toString());
			}
			_offsetGroup.add(offset);
			if(_offsetGroup.size()>60){
				_offsetGroup.remove(0);
			}
			offsetMap.put(storeKey.toString(),_offsetGroup);
			_offsetGroup = new ArrayList<Double>();

			if(i==-1)break;
			storeKey.deleteCharAt(i);
		}
		
	}

	
	long shotTimer = 0;
	double heaviestOffset = 1d, deltaTheta = 0d, botWidth = 0d, density = 0d;
	double maxDensity;
	public double getIdealBearing(){
		
		buildKey = new StringBuilder(state);
		List<Double> _aimFactors = new ArrayList<Double>();
		
		for(int i = buildKey.length()-1; i > -1; i --){

			if(offsetMap.containsKey(buildKey.toString())){
				if(offsetMap.get(buildKey.toString()).size()>buildKey.length()){
					_aimFactors = offsetMap.get(buildKey.toString());
					break;
				}
			}
			if(buildKey.length()==0) break;
			buildKey.deleteCharAt(i);
		}

		density = 0; botWidth = Math.abs(36d/enemy.distance);//-1d/60d*utils.maxEscapeAngle());
		maxDensity = 0; double runningAverage = 0, numberMatches=0;
		double newBearing = enemy.absBearing; boolean offsetFound = false;
		double ratio = 0;
	//	double deltaOffset = Math.abs(botWidth/utils.maxEscapeAngle())/50d;
		
		for(double t=-1+2d/94d; t < 1d; t += 2d/47d){
	//	for(double t=-1+(deltaOffset/2d); t < 1d; t += 1d/deltaOffset){
			for(double o7:_aimFactors){
				newBearing = getAngleForOffset(t);
				deltaTheta = Math.abs(utils.normaliseBearing(
					newBearing-getAngleForOffset(o7)));
				ratio = Math.abs(deltaTheta/botWidth);
				if(ratio<1) density+=Math.pow(Math.E,-2d/47d*ratio*ratio);
			}
			if(density>=maxDensity){
				maxDensity = density;
				heaviestOffset = t;
			}
			/*if(density==maxDensity&offsetFound){
				runningAverage += t;
				numberMatches++;
				if(Math.abs(getAngleForOffset(t)-getAngleForOffset(lastFactor))>
					botWidth) { runningAverage = t; numberMatches = 1; lastFactor = t; }
			}
			if(density>maxDensity){
				maxDensity = density;
				heaviestOffset = t;
				offsetFound = true;
				numberMatches = 1;
				runningAverage = t;
			}*/
			density = 0;
		}

		if(offsetFound)
		heaviestOffset = utils.limit(-1,runningAverage/numberMatches,1);

		return utils.normaliseAngle(enemy.absBearing
			 + utils.maxEscapeAngle()*enemy.lateralDirection*heaviestOffset);

	}
	
	public double getAngleForOffset(double offset){
		return utils.normaliseBearing(enemy.absBearing + utils.maxEscapeAngle()*offset
			*enemy.lateralDirection);
	}

}

class DodgeWave{
	
	QuarkSoup qS; Opponent enemy; Utilities utils;
	static final double PI, maxOffset;
	static StringBuilder stateBuilder = new StringBuilder("");
	static HashMap<String,List<Double>> stateMap = new HashMap<String,List<Double>>();
	static List<DodgeWave> _surfGroup = new ArrayList<DodgeWave>();
	static List<Double> _offsetList = new ArrayList<Double>();

	DodgeWave(QuarkSoup type1, Opponent type2, Utilities type3){
		qS = type1; enemy = type2; utils = type3;
		lastLatDir = 1; latDir = 1;
	}
	
	DodgeWave(){}
	
	double lastHealth, healthDelta, lastShotPower;
	double deltaHeading, lastHeading;//, botWidth;
	
	public void update(){
		setSegmentation();
		angleFromEnemy = utils.absAngle(enemy.position,qS.position);
		//botWidth = (36/enemy.distance);
		if(qS.velocity!=0) {
			latDir = (int)utils.sign(qS.velocity)*(int)utils.sign(enemy.bearing); }
		else{ lastDir = lastLatDir; }
		if(!qS.isMC){
			advanceWaves();
			drive();
		}
		healthDelta = lastHealth-enemy.energy;
		if(healthDelta>0&&healthDelta<=3){
			createWave(healthDelta);
			lastShotPower = healthDelta;
		}
		lastHealth = enemy.energy;
		lastLatDir = latDir;
		deltaHeading = utils.normaliseBearing(qS.heading - lastHeading);
		lastHeading = qS.heading;
	}
	
	int vSeg, bPowSeg, nWSeg, distSeg, latHeadSeg, dHeadSeg, lastOffsetSeg, lvSeg = 0;
	double latHeading;

	public void setSegmentation(){
		
		latHeading = utils.normaliseBearing(utils.absAngle(enemy.position,qS.position)-qS.heading);

		vSeg = (int)Math.abs(Math.round(qS.velocity/2));
		nWSeg = (qS.playField.contains(utils.project(qS.position,120d*latDir,qS.heading))?0:1);
		bPowSeg = (int)Math.round(lastShotPower);
		distSeg = (int)Math.round(enemy.position.distance(qS.position)/utils.GreatestDistance()*4);
		latHeadSeg = (int)Math.abs(Math.round(latHeading/(PI/4)));
		dHeadSeg = (int)Math.abs(Math.round(deltaHeading/(PI/78)));
		lastOffsetSeg = (int)Math.round((lastOffset*4+4));
		stateBuilder = new StringBuilder("");
		stateBuilder.append(utils.toString(distSeg));
		stateBuilder.append(utils.toString(vSeg));
		stateBuilder.append(utils.toString(nWSeg));
		stateBuilder.append(utils.toString(latHeadSeg));
		stateBuilder.append(utils.toString(bPowSeg));
		stateBuilder.append(utils.toString(lvSeg));
		stateBuilder.append(utils.toString(dHeadSeg));
		stateBuilder.append(utils.toString(lastOffsetSeg));
		
		dataPoint[0] = Math.abs(qS.velocity)/8;
		dataPoint[1] = lastShotPower/3;
		dataPoint[2] = utils.limit(0d,Math.abs(deltaHeading/(PI/2)),1d);
		dataPoint[4] = utils.limit(0d,Math.abs(latHeading/PI),1d);

		state = stateBuilder.toString();
		
		lvSeg = vSeg;
	}
	
	double angleFromEnemy, offset, shotTime;
	int latDir, lastLatDir; double distTraveled;
	double bPower, bSpeed, maxEscapeAngle;
	Point2D.Double shotLocation; String state;
	double[] dataPoint = new double[5];
	
	public void createWave(double eDrop){
		//5600 score 75 12
		DodgeWave wave = new DodgeWave();
		wave.angleFromEnemy = utils.absAngle(enemy.position,qS.position);
		wave.offset = 0;
		wave.shotTime = qS.getTime();
		wave.distTraveled = 0;
		wave.bPower = eDrop;
		wave.bSpeed = utils.bSpeed(wave.bPower);
		wave.shotLocation = enemy.position;
		wave.latDir = latDir;
		wave.maxEscapeAngle = utils.normaliseBearing(utils.maxEscapeAngle(wave.bSpeed))*wave.latDir;
		wave.state = state;
		wave.botWidth = botWidth;
		wave.dataPoint = dataPoint;
		
		_surfGroup.add(wave);
	}
	
	//static List<Double> _offsetList = new ArrayList<Double>();
	DodgeWave advWave;
	
	void advanceWaves(){
		for(int i = 0; i < _surfGroup.size(); i ++){
			advWave = _surfGroup.get(i);
			advWave.distTraveled = (qS.getTime()-advWave.shotTime)*advWave.bSpeed;
			if(advWave.distTraveled >= qS.position.distance(advWave.shotLocation)){
				_surfGroup.remove(i);
				i--;
			}
		}
	}
	
	double desiredAngle, distanceToSpot, lastVelocity;
	List<Point2D.Double> _spotChoices = new ArrayList<Point2D.Double>();
	Point2D.Double desiredSpot = new Point2D.Double();
	double velocity, heading, danger, itterations;
	double timeTillHit, distConsidered; boolean interrupted;
	double turnAmount, predictedHeading, maxTurn; int goDirection;
	int enemySide, predictedDir, lastDir = 1, goDir = 1;
	int vSign = 1, lvSign = 1;
	int[] directions = new int[]{-1,1};
	Point2D.Double emptySurfSpot = new Point2D.Double();
	double velocityFraction = 1d;
	Point2D.Double tempSpot = new Point2D.Double();
	
	void drive(){
		DodgeWave wave = getClosestSurfableWave();
		if(wave.shotLocation!=null){
			testState = new StringBuilder(wave.state);
			while(!stateMap.containsKey(testState.toString())){
				if(testState.length()==0) break;
				testState.deleteCharAt(testState.length()-1);
				if(stateMap.containsKey(testState.toString())){
					if(stateMap.get(testState.toString()).size()>testState.length()/2)
						break;
				}
			}
			if(stateMap.containsKey(testState.toString())){
				_offsetList = stateMap.get(testState.toString());
			}			
			desiredSpot = getDesiredSpot(wave,qS.position);
			turnAmount = utils.absAngle(qS.position,desiredSpot)-qS.heading;
			turnAmount = utils.normaliseBearing(turnAmount);
			distanceToSpot = desiredSpot.distance(qS.position);
			if(turnAmount>PI/2||turnAmount<-PI/2){
				goDir = -1;
				turnAmount *= -1;
			}
			else { goDir = 1; }
			qS.setTurnRightRadians(turnAmount*Math.signum(distanceToSpot));
			qS.setAhead(distanceToSpot*goDir);
		}
		else{
			desiredAngle = utils.normaliseAngle(utils.absAngle(enemy.position,qS.position)+PI/2);
			qS.setTurnRightRadians(getTurnAmount(qS.position,desiredAngle,qS.heading,latDir));
			emptySurfSpot = utils.project(qS.position,120d*latDir,qS.heading);
			if(!qS.playField.contains(emptySurfSpot)&
				qS.position.distance(enemy.position)>emptySurfSpot.distance(enemy.position)){
					goDir*=-1;
			}
			qS.setAhead(100*goDir);
			qS.setMaxVelocity(PI/qS.getTurnRemainingRadians());
		}
	}
	Point2D.Double getDesiredSpot(DodgeWave wave, Point2D.Double spot){
		_spotChoices.add(spot);
		for(int dir:directions){
			spot = qS.position;
			predictedHeading = qS.heading;
			velocity = qS.velocity;
			vSign = vSign(velocity, lvSign);
			lvSign = vSign;
			itterations = 0;
			interrupted = false;
			enemySide = (int)utils.sign(enemy.bearing);
			desiredAngle = utils.normaliseAngle(utils.absAngle(wave.shotLocation,spot)+PI/2);
			while(!interrupted){
				velocity += (velocity*dir<0?2*dir:dir);
				velocity = utils.limit(-8,velocity,8);
				/*if(Math.abs(velocity)>=1)
				itterations += Math.abs(velocityFraction/velocity);
				else */itterations ++;
				vSign = vSign(velocity, lvSign);
				enemySide = (int)utils.sign(utils.normaliseBearing(predictedHeading-utils.absAngle(spot,wave.shotLocation)));
				desiredAngle = utils.normaliseAngle(utils.absAngle(wave.shotLocation,spot)+PI/2);
				turnAmount = getTurnAmount(spot,desiredAngle,predictedHeading,vSign);
				maxTurn = Math.PI/720d*(40d - 3d*Math.abs(velocity));
				turnAmount = utils.limit(-maxTurn,turnAmount,maxTurn);
				predictedHeading = utils.normaliseAngle(predictedHeading+turnAmount);
				for(double i = 0; i <= Math.abs(velocity); i += 1){
 					tempSpot = utils.project(spot,velocityFraction*vSign*i,predictedHeading);
					_spotChoices.add(tempSpot);
				}
				spot = utils.project(spot,velocity,predictedHeading);
				lvSign = vSign;
				if(wave.shotLocation.distance(spot)<(wave.distTraveled+wave.bSpeed*(itterations+1))){
					interrupted = true;
				}
			}
		}
		double danger = Double.POSITIVE_INFINITY, testDanger;
		for(Point2D.Double testSpot:_spotChoices){
			testDanger = getDanger(testSpot,wave);
			if(testDanger<danger){
				danger = testDanger;
				spot = testSpot;
			}
		}
		//qS.out.println("Surfing: " + getDanger(spot,wave));
		_spotChoices.clear();
		return spot;
	}
	int vSign(double v, int s){
		if(v==0) return s;
		return (int)utils.sign(v);
	}
	double getTurnAmount(Point2D.Double startSpot, double angle, double heading, int dir){
		angle-=PI/20d*(double)dir;
		int i = 0; double toTurn = utils.normaliseBearing(angle-heading);
		while(!qS.playField.contains(utils.project(startSpot,120*dir,heading+toTurn))&&i<160){
			toTurn+=.01*dir; i++;
		}
		return utils.normaliseBearing(toTurn);
	}
	StringBuilder testState = new StringBuilder();
	double angleToPos = 0, deltaTheta = 0, botWidth = 36, density, ratio;
	
	double getDanger(Point2D.Double position, DodgeWave wave){
		density = 0;
		resultOffset = utils.getOffset(wave.shotLocation, position, wave);
		//bin = getBinForOffset(resultOffset);
		botWidth = (36d/position.distance(wave.shotLocation));
		angleToPos = getAngleForOffset(resultOffset, wave);
		for(double o7:_offsetList){
			deltaTheta = utils.normaliseBearing(angleToPos-getAngleForOffset(o7, wave));
			ratio = Math.abs(deltaTheta/botWidth);
		//	if(ratio<=1){
				//density += e^(-0.5 * (ux^2))
			density += Math.pow(Math.E,-0.5*ratio*ratio);
			//density ++;
			//}
		}
		//return bins[bin]/position.distance(wave.shotLocation);
		return density/position.distance(enemy.position);
	}
	double getAngleForOffset(double o, DodgeWave wave){
		return (o*wave.maxEscapeAngle);
	}
	
	double resultOffset, distDelta, timeDelta, lastTime, lastDist;
	//int bin; double[] bins = new double[61], storeBins;

	public void onHit(Bullet e){
		Point2D.Double hitPos = new Point2D.Double(e.getX(),e.getY());
		DodgeWave wave = getClosestSurfWave(hitPos);
		
		if(wave.shotLocation!=null){
			resultOffset = utils.getOffset(wave.shotLocation, hitPos, wave);
			storeOffset(resultOffset,wave.state);
		}
		else qS.out.println("Sorry Sir, Dropped A Wave");
	}
	DodgeWave getClosestSurfWave(Point2D.Double hitPos){
		DodgeWave closeWave = new DodgeWave();
		lastDist = utils.GreatestDistance();
		for(DodgeWave wave:_surfGroup){
			distDelta = Math.abs(wave.shotLocation.distance(hitPos)-wave.distTraveled);
			if(distDelta<lastDist){
				lastDist = distDelta;
				closeWave = wave;
			}
		}
		return closeWave;
	}
	DodgeWave getClosestSurfableWave(){
		lastDist = utils.GreatestDistance(); lastTime = lastDist/3d;
		DodgeWave closeWave = new DodgeWave();
		for(DodgeWave wave:_surfGroup){
			distDelta = Math.abs(wave.shotLocation.distance(qS.position)-wave.distTraveled);
			timeDelta = distDelta/wave.bSpeed;
			if(timeDelta<lastTime&&distDelta>wave.bSpeed){
				lastDist = distDelta; lastTime = timeDelta;
				closeWave = wave;
			}
		}
		return closeWave;
	}
	StringBuilder toStore; double lastOffset = 0;
	void storeOffset(double o,String storeState){
		//bin = getBinForOffset(o);
		lastOffset = o;
		toStore = new StringBuilder(storeState);
		List<Double> _storeList;
		do{
			_storeList = new ArrayList<Double>();
			if(stateMap.containsKey(toStore.toString())){
				_storeList = stateMap.get(toStore.toString());
			}
			_storeList.add(o);
			/*for(int i = 0; i < bins.length; i ++){
				storeBins[i] += 1/(Math.pow(i-bin,2)+1);
			}*/
			stateMap.put(toStore.toString(),_storeList);
			//System.out.println("stored: " + toStore + " size: " + _storeList.size());
			if(toStore.length()==0) break;
			toStore.deleteCharAt(toStore.length()-1);
		}while(toStore.length()>=0);
	}
	
	int getBinForOffset(double o7){
		return (int)Math.round((o7*30+30));
	}
	
	double distSquared(double A, double B){
		return (A-B)*(A-B);
	}
	
	static{
		PI = Math.PI;
		maxOffset = Math.sqrt(2d);
	}
	

	public void paint(Graphics2D g){
		g.setColor(qS.purple);
		g.drawOval(new Double(enemy.position.x - 25).intValue(), new Double(enemy.position.y - 25).intValue(), 50, 50);
		double radius = 0;

		for(DodgeWave toPaint: _surfGroup){
			radius = toPaint.distTraveled + toPaint.bSpeed;
			
			g.drawOval(new Double(toPaint.shotLocation.getX() - (radius)).intValue(),
				new Double(toPaint.shotLocation.getY() - (radius)).intValue(),
					new Double(radius*2).intValue(), new Double(radius*2).intValue());
		}
	}

}


interface SetTypes{
	
	
	public boolean setTypes(QuarkSoup qS);


}