package EH;
import robocode.*;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.util.Utils;
import java.awt.geom.*;

public class Fusion extends AdvancedRobot
{
	//for direct ramming movement
	int dir=1;
	
	//for paint stuff
 	int scannedX = Integer.MIN_VALUE;
 	int scannedY = Integer.MIN_VALUE;
	
	//for evasion attack movement
	double previousEnergy = 100;
    int movementDirection = 1;
	
	// for targeting
	final static double BULLET_POWER=3;//Our bulletpower.
	final static double BULLET_SPEED=20-3*BULLET_POWER;//Formula for bullet speed.
	
	static double oldEnemyHeading;
	static double enemyEnergy;
	
	public void run() {
		
		setColors(Color.gray,Color.lightGray,Color.yellow);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		while(true) {
		//turn the radar
		turnRadarRightRadians(Double.POSITIVE_INFINITY);
		
		}
	}
	

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
 
     // paint stuff- see graphical debugging page on robowiki
	 //for more
     
  	   double angle = Math.toRadians((getHeading() + e.getBearing()) % 360);
 
     // Calculate the coordinates of the robot
  	   scannedX = (int)(getX() + Math.sin(angle) * e.getDistance());
  	   scannedY = (int)(getY() + Math.cos(angle) * e.getDistance());
	 
	 	//gun and radar locks and turns
		
		Graphics2D g=getGraphics();

		double absBearing=e.getBearingRadians()+getHeadingRadians();
 
 
		//Finding the heading and heading change.
		double enemyHeading = e.getHeadingRadians();
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		oldEnemyHeading = enemyHeading;
 
		/*This method of targeting is know as circular targeting; you assume your enemy will
		 *keep moving with the same speed and turn rate that he is using at fire time.The 
		 *base code comes from the wiki.
		*/
		double deltaTime = 0;
		double predictedX = getX()+e.getDistance()*Math.sin(absBearing);
		double predictedY = getY()+e.getDistance()*Math.cos(absBearing);
		while((++deltaTime) * BULLET_SPEED <  Point2D.Double.distance(getX(), getY(), predictedX, predictedY)){	
 
			//Add the movement we think our enemy will make to our enemy's current X and Y
			predictedX += Math.sin(enemyHeading) * e.getVelocity();
			predictedY += Math.cos(enemyHeading) * e.getVelocity();
 
 
			//Find our enemy's heading changes.
			enemyHeading += enemyHeadingChange;
			
			g.setColor(Color.red
);
			g.drawRect((int)predictedX-2,(int)predictedY-2,4,4);
 
			//If our predicted coordinates are outside the walls, put them 18 distance units away from the walls as we know 
			//that that is the closest they can get to the wall (Bots are non-rotating 36*36 squares).
			predictedX=Math.max(Math.min(predictedX,getBattleFieldWidth()-18),18);
			predictedY=Math.max(Math.min(predictedY,getBattleFieldHeight()-18),18);
 
		}
		//Find the bearing of our predicted coordinates from us.
		double aim = Utils.normalAbsoluteAngle(Math.atan2(  predictedX - getX(), predictedY - getY()));
 
		//Aim and fire.
		setTurnGunRightRadians(Utils.normalRelativeAngle(aim - getGunHeadingRadians()));
		setFire(BULLET_POWER);
		setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing-getRadarHeadingRadians())*2);
		
		//"Drive" tactic: Linear turn to the enemy and move ahead or backwards
		//Inspired by the perceptual rambot, Impact
		
		//used for rounds 1-5
		
		if (getRoundNum() < 6) {
		setAhead(Double.POSITIVE_INFINITY*dir);
		setTurnRightRadians(Utils.normalRelativeAngle(aim - getHeadingRadians()));
		}
		
		//"Dodge" tactic: React to enemy fire, and get closer
		//to the enemy bot.
		
		//credit goes to DodgeBot on the secrets from robocode
		//masters 'dodging bullets' page.
		
		//used for rounds 6-8
		
		if (getRoundNum() > 5 && getRoundNum() < 9) {
			setTurnRightRadians(e.getBearing()+90-40*movementDirection);
			double changeInEnergy = previousEnergy-e.getEnergy();
		
			if (changeInEnergy>0 && changeInEnergy<=3) {
				movementDirection=-movementDirection;
				setAhead((e.getDistance()/4+25)*movementDirection);
			}
			previousEnergy=e.getEnergy();
		}
		
		//spiral tactic: spin around the enemy, gradually getting
		//closer.
		
		//Inspired by SuperRamFire.
		
		//used for the last 2 rounds
		
		if (getRoundNum() > 8) {
			
			setTurnRight(90 - e.getBearing() - 40 * movementDirection);
			setAhead(100*dir);
		}
	}
	
	public void onHitWall(HitWallEvent e) {
		//move in the opposite direction
		dir=-dir;
	}	
	public void onPaint(Graphics2D g) {
     g.setColor(Color.yellow);
 
     g.drawLine(scannedX, scannedY, (int)getX(), (int)getY());
 
     g.fillOval(scannedX - 5, scannedY - 5, 10, 10);
	 
    	g.setColor(Color.blue);
		g.drawOval((int) (getX() - 50), (int) (getY() - 50), 100, 100);
		g.setColor(Color.red);
		g.drawOval(scannedX - 50, scannedY - 50, 100, 100);
 
	}
}
								