package el;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;

public class Attackr extends AdvancedRobot {
	int count = 0; // Keeps track of how long we've been searching for our target
	double gunTurnAmt; // How much to turn our gun when searching
	String trackName; // Name of the robot we're currently tracking

	/**
	 * run:  Attackr's main run function
	 */	
	public void run() {
		// Set colors
		setBodyColor(new Color(28, 56, 150));
		setGunColor(new Color(60, 89, 20));
		setRadarColor(new Color(200, 120, 70));
		setScanColor(Color.white);
		setBulletColor(Color.green);
		
		// Prepare gun
		trackName = null; // Initialize to not tracking anyone
		setAdjustGunForRobotTurn(true); // Keep the gun still when we turn
		gunTurnAmt = 20; // Initialize gunTurn to 20

		// Loop forever
		while (true) {
			// turn the Gun (looks for enemy)
			turnGunRight(gunTurnAmt);
			// Keep track of how long we've been looking
			count++;
			// If we've haven't seen our target for 2 turns, go ahead and look left
			if (count > 2) {
				gunTurnAmt = -10;
			}
			// If we still haven't seen our target for 4 turns, look right
			if (count > 5) {
				gunTurnAmt = 10;
			}
			// If we *still* haven't seen our target after 12 turns, run and find another
			if (count > 10) {
				if (trackName != null) {
					out.println("Gave up on finding " + trackName + ".");
				} else {
				out.println("Searching for new target on turn " + getTime() + ".");
			}
				trackName = null;
			}
		}
	}
	
	/**
	 * onScannedRobot
	 */	
	public void onScannedRobot(ScannedRobotEvent e) {

		// If we have a target, and this isn't it, return immediately
		// so we can get more ScannedRobotEvents.
		if (trackName != null && !e.getName().equals(trackName)) {
			return;
		}

		// Get target
		if (trackName == null) {
			trackName = e.getName();
			out.println("Target acquired. Now tracking " + trackName + " starting at turn " + e.getTime() + ".");
		}
		// This is our target.  Reset count
		count = 0;
		// If our target is too far away, turn and move torward it.
		if (e.getDistance() > 300) {
			gunTurnAmt = normalRelativeAngle(e.getBearing() + (getHeading() - getRadarHeading()));
			
			setTurnGunRight(gunTurnAmt); // Try changing these to setTurnGunRight,
			turnRight(e.getHeading()); // and see how much Attackr improves...
			// (you'll have to make Attackr an AdvancedRobot)
			ahead(e.getDistance() - 140);
			execute();
			return;
		}

		// Our target is close.
		gunTurnAmt = normalRelativeAngle(e.getBearing() + (getHeading() - getRadarHeading()));
		turnGunRight(gunTurnAmt);
		fire(2);
		
		// Our target is too close!  Run away.
		if (e.getDistance() < 150) {
			if (e.getBearing() > -90 && e.getBearing() <= 90) {
				back(60);
			} else if (trackName.equals("ntc.Lasers.Lasers")) {
				ahead(300);
				back(400);
				ahead(200);
				turnGunRight(e.getBearing());
				fire(3);
			} else {
				ahead(60);
			}
		}
		scan();
	}
	
	/**
	 * onHitRobot
	 */	
	public void onHitRobot(HitRobotEvent e) {
		
		   System.out.println("Crashed into " + getName() + " on turn " + getTime() + "!"); 
		
		if (e.getBearing() > -90 && e.getBearing() < 90) {
			turnRight(e.getBearing());
			fire(2); // just in case robot is following
			back(100);
		}
		else {
			turnLeft(e.getBearing());
			fire(2); // same concept
			ahead(100);
		}
	}

//when a wall is hit
	public void onHitWall(HitWallEvent event) {
       if (event.getBearing() > -90 && event.getBearing() <= 90) {
           back(200);
		   System.out.println("Collision with wall at " + getTime() + ".");
       } else {
           ahead(200);
		   System.out.println("Collision with wall at " + getTime() + ".");
       }
	}

	//when a bullet hits a robot, display a message
	public void onBulletHit(BulletHitEvent event) {
    out.println("Attackr successfully hit " + event.getName() + ".");
   }

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		turnLeft(270 - e.getBearing());
		System.out.println("Attackr was attacked from angle " + e.getBearing() + " by " + e.getName() + "!");
		fire(3);
		ahead(50);
	}

	public void onDeath(DeathEvent event) {
		System.out.println("Attackr died...");
	}

	/**
	 * onWin:  Do a victory dance
	 */	
	public void onWin(WinEvent e) {
		out.println("Attackr has won the round!");
		for (int i = 0; i < 5000; i++) {
			ahead(50);
			back(50);
			ahead(50);
			back(50);
			turnGunLeft(360);
			turnRight(360);
		}
	}

	/**
	 * normalRelativeAngle:  Returns angle such that -180 < angle <= 180
	 */	
	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180) {
			return angle;
		}
		double fixedAngle = angle;

		while (fixedAngle <= -180) {
			fixedAngle += 360;
			fire(2);
			ahead(30);
		}
		while (fixedAngle > 180) {
			fixedAngle -= 360;
			fire(2);
			back(30);
		}
		return fixedAngle;
	}
}
