package rc.yoda.plugin.guns;

import robocode.*;
import rc.yoda.utils.Gun;

/** 
 * Random - by Robert Codd (Gorded) 
 *
 * This code is here by released under the RoboWiki Public Code Licence (RWPCL),
 * datailed on: http://robowiki.net/?RWPCL
 * (Basically it means you must keep the code public if you base any bot on it)
 *
 * Random.java : v1.0 -- 2007/05/12
 */

/**
 * Random a gun that fires at a
 * random angle between -46.6 and 46.6
 * 
 * @author Robert Codd
 * @version v1.0
 */
public class Random extends Gun
{
	/**
	 * Class Constructor specifying the robot this 
	 * gun is virtually mounted on
	 */
	public Random(AdvancedRobot robot) {
		super(robot);
	}

	/**
	 * Generates a random bullet power in keeping
	 * with the name of this gun
	 *
	 * @return double number from 0.1 to 3
	 */
	public double getBulletPower() {
		return Math.max(0.1, Math.random() * 3);
	}

	/**
	 * Generates a random number from -46.6 to 46.6
	 *
	 * @return double number from -46.6 
	 * to 46.6 for the GunArray
	 */
	public double getFireAngle() {
		return Math.toRadians((Math.random() * 2 - 1) * 46.6);
	}
}
