package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class OscillatorL extends AdvancedRobot {
    private int dir = 1;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    execute();
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	double power = 600.0 / e.getDistance();
	setTurnGunRightRadians(Utils.normalRelativeAngle((bearing + Math.asin(e.getVelocity() * Math.sin(e.getHeadingRadians() - bearing) / Rules.getBulletSpeed(power))) - getGunHeadingRadians()));
	setFire(power);
	
	// Movement
	setTurnRightRadians(e.getBearingRadians() + Math.PI/2 - dir * Math.PI/8 * (e.getDistance() < 150 ? -1 : e.getDistance() > 250 ? 1 : 0));
	if(getDistanceRemaining() == 0) {
	    double distance = 100 * (Math.sin(getTime() / 7.0) + Math.cos(getTime() / 11.0));
	    setAhead(distance);
	    dir = distance < 0 ? -1 : 1;
	}
    }
}
