/*
 * Class.java
 *
 * Created on April 7, 2002, 1:15 AM
 */

package tobe.movement;
import tobe.util.*;
import robocode.*;

/**
 *
 * @author  tobe
 * @version 
 */
public class AntiMatter extends AbstractStrategy {
        private class DoubleCounter {
            double value = 0;
            DoubleCounter() {};
            DoubleCounter(double v) { value = v;}
            public double getValue() { return value;}
            public void setValue(double v) { value = v;}
            public void add(double v) { value += v;}
        }
        
        private java.util.HashMap seen = new java.util.HashMap();
        private java.util.HashMap danger = new java.util.HashMap();
        private BearingVector gravity = new BearingVector();
        private BearingVector wall = new BearingVector();
        private BearingVector centre = new BearingVector();
        private double wallWeight = 10.0;
        private double movement = 1000;
        private double wait = 0;//try to get a bit more fluid movement
        
        public boolean go(AdvancedRobot bot) {
            wait--;
            if(wait > 0) return false;
            //calculate the gravity
            gravity.setPolar(0,0,bot.getX(),bot.getY());
            java.util.Iterator i = seen.values().iterator();
            while( i.hasNext() ) {
                ScannedRobotEvent e = (ScannedRobotEvent) i.next();
                DoubleCounter d = (DoubleCounter) danger.get(e.getName());
                if( d == null ) {
                    d = new DoubleCounter(1.0);
                    danger.put(e.getName(), d);
                }
                gravity.add(e.getBearingRadians()+bot.getHeadingRadians(),
                d.getValue()/Math.pow(e.getDistance(),2));
                //add his pull on the centre (I want to get to a quiet corner)
                centre.setPolar(e.getBearingRadians()+bot.getHeadingRadians(),
                    e.getDistance(), bot.getX(), bot.getY());
                centre.changeOrigin(bot.getBattleFieldWidth()/2, bot.getBattleFieldHeight()/2);
                gravity.add(centre.getBearing(), d.getValue()/Math.pow(centre.getDistance(),2));
            }
            //add a wall repellant if close to wall
            wall.setPolar(0,1,bot.getX(),bot.getY());
            wall.setDistanceToY(bot.getBattleFieldHeight());
            if(wall.getDistance() < 2*bot.getWidth())
                gravity.add(wall.getBearing(), wallWeight/Math.pow(wall.getDistance(), 2));
            wall.setPolar(Math.PI,1,bot.getX(),bot.getY());
            wall.setDistanceToY(0);
            if(wall.getDistance() < 2*bot.getWidth())
                gravity.add(wall.getBearing(), wallWeight/Math.pow(wall.getDistance(), 2));
            wall.setPolar(Math.PI/2,1,bot.getX(),bot.getY());
            wall.setDistanceToX(bot.getBattleFieldWidth());
            if(wall.getDistance() < 2*bot.getWidth())
                gravity.add(wall.getBearing(), wallWeight/Math.pow(wall.getDistance(), 2));
            wall.setPolar(-Math.PI/2,1,bot.getX(),bot.getY());
            wall.setDistanceToX(0);
            if(wall.getDistance() < 2*bot.getWidth())
                gravity.add(wall.getBearing(), wallWeight/Math.pow(wall.getDistance(), 2));
            //now turn away from the gravity-pull
            double myHeading = bot.getHeadingRadians();
            if(movement < 0) myHeading = normalizeAngle(myHeading + Math.PI);
            double turn = normalizeAngle(gravity.getBearing()-myHeading);
			if(Math.abs(turn) < Math.PI/2) movement = -movement;
			else turn = normalizeAngle(turn+Math.PI);  
            if(Math.random() < 0.1) {//change direction
                movement = -movement;
				turn = normalizeAngle(turn+Math.PI);  
                bot.setMaxVelocity(2);
            } else bot.setMaxVelocity(4+Math.random()*6);
            bot.setTurnRightRadians(turn);
            bot.setTurnRadarRight(720);
            bot.setAhead(movement);
            //slow down if heading towards wall
            wall.setPolar(bot.getHeadingRadians(), movement, bot.getX(), bot.getY());
            if(wall.getToX() < 0) wall.setDistanceToX(0);
            if(wall.getToX() > bot.getBattleFieldWidth()) wall.setDistanceToX(bot.getBattleFieldWidth());
            if(wall.getToY() < 0) wall.setDistanceToY(0);
            if(wall.getToY() > bot.getBattleFieldHeight()) wall.setDistanceToY(bot.getBattleFieldHeight());
            bot.setMaxVelocity(8*wall.getAbsoluteDistance()/(3*bot.getWidth()));
			wait = 5;//dont change movement too soon
            return false;
        }
        
        public void printStatistics(AdvancedRobot bot) {
            bot.out.println("Wall weight = "+wallWeight);
            bot.out.println("Danger values:");
            java.util.Iterator i = danger.keySet().iterator();
            while(i.hasNext()) {
                String name = (String) i.next();
                DoubleCounter d = (DoubleCounter) danger.get(name);
                bot.out.println(name+" "+d.getValue());
            }
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleBulletHitEvent(AdvancedRobot bot, BulletHitEvent e) {
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleBulletMissedEvent(AdvancedRobot bot, BulletMissedEvent e) {
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleCustomEvent(AdvancedRobot bot, CustomEvent e) {
        }
        
        /** Event handler. Keep its execution time short. */
        public void handleDeathEvent(AdvancedRobot bot, DeathEvent e) {
            printStatistics(bot);
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleHitByBulletEvent(AdvancedRobot bot, HitByBulletEvent e) {
            DoubleCounter d = (DoubleCounter) danger.get(e.getName());
            if( d == null ) {
                d = new DoubleCounter(1.0);
                danger.put(e.getName(), d);
            }
            d.add(e.getPower()/10);
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleHitRobotEvent(AdvancedRobot bot, HitRobotEvent e) {
            double bearing = e.getBearingRadians();
            if(movement < 0) bearing = normalizeAngle(bearing+Math.PI);
            if(Math.abs(bearing) < Math.PI/2) movement = -movement;
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleHitWallEvent(AdvancedRobot bot, HitWallEvent e) {
            wallWeight += 10.0;
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleRobotDeathEvent(AdvancedRobot bot, RobotDeathEvent e) {
            seen.remove(e.getName());
        }
        
        /** Event handler. Keep its execution time short.  */
        public void handleScannedRobotEvent(AdvancedRobot bot, ScannedRobotEvent e) {
            seen.put(e.getName(),e);
        }
        
        /** Event handler. Keep its execution time short. */
        public void handleWinEvent(AdvancedRobot bot, WinEvent e) {
            printStatistics(bot);
        }
        
        /** This should be called by the robot at the start of each battle  */
        public void init(AdvancedRobot bot) {
            bot.setMaxTurnRate(100);
            bot.setMaxVelocity(100);
            seen.clear();
            wait=0;
            bot.out.println("using AntiMatter movement");
        }
        
}
