package zzx;
import robocode.*;
import java.awt.Color;
import java.awt.geom.*;
import java.awt.Graphics;
import java.util.ArrayList;
// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Ignohis - a robot by (your name here)
 */
public class Ignohis extends AdvancedRobot
{
	double moveDirection = 1;
	double previousEnergy = 100;  //enemy energy
	double oppEnergy = 100;  //my energy
	ArrayList<Wave> waveArray = new ArrayList<Wave>();
	static double predictMoveAmount;
	
	double distanceToTravel = 0;
	boolean hasMoved = false;
	double targetPlaceX;
	double targetPlaceY;
	static double learningAngle[] = new double[12];	//arraylist for learning angles
	int counter = 0; //counting learning angles
	public void run() {
		
		// Initialization of the robot should be put here
		predictMoveAmount = 40;
		// After trying out your robot, try uncommenting the import at the top,
		// and the next line:
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setBodyColor(new Color(126,124,20));
		//setBodyColor(new Color(146,203,220));
		setGunColor(new Color(14,29,25));
		setRadarColor(Color.black);
		// Robot main loop
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			turnRadarRight(360);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e) {
		// Replace the next line with any behavior you would like
		doRadarAndGunAndTurning(e);
		checkIfEnemyFired(e);
		surfWaves(e);
		//chooseDirection(e);
	}
	public void doRadarAndGunAndTurning(ScannedRobotEvent e) {
		// Replace the next line with any behavior you would like
		double radarTurn = robocode.util.Utils.normalRelativeAngle(
        e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians());
     	radarTurn += Math.signum(radarTurn)*Math.atan(getWidth()/e.getDistance());
     	//setTurnRadarRightRadians(radarTurn);
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		double latVel= e.getVelocity()  * Math.sin(e.getHeadingRadians() - absoluteBearing);
		setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getGunHeadingRadians()+latVel/15));
		setTurnRadarRightRadians(4 * robocode.util.Utils.normalRelativeAngle(absoluteBearing - getRadarHeadingRadians()));
		//enable firing before compilation devon!
		if (getGunHeat() == 0) {
			fire(2.3);
		}
		
	}
	public double getWallSmoothedTurn(double t) {
		double wSD = 20; //wall smooth distance
		double turn = t;
	    double predictiveDistance = 200;

		double ourHeading = getHeadingRadians();
		if (moveDirection == -1) {
			ourHeading += Math.PI;
		}
		Rectangle2D.Double bounds = new Rectangle2D.Double(wSD, wSD, getBattleFieldWidth() - 2 * wSD, getBattleFieldHeight() - 2 * wSD);
		
		while (true) {
			double totalTurn = turn + ourHeading;
			double dXTravel = Math.sin(totalTurn) * predictiveDistance;
			double dYTravel = Math.cos(totalTurn) * predictiveDistance;
			double finishX = getX() + dXTravel;
			double finishY = getY() + dYTravel;

			if (bounds.contains(finishX, finishY)) {
				return (turn);
			} else {
				turn += 0.1 * moveDirection;
			}
		}
	}					
	public void onHitWall(HitWallEvent e) {
		// Replace the next line with any behavior you would like
		moveDirection *= -1;
		setTurnRight(90);
		setAhead(100 * moveDirection);
	}
	public void onHitByBullet(HitByBulletEvent e) {
		for (int i = 0; i < waveArray.size(); i++) {
			Wave w = waveArray.get(i);
			double enemyFireX = w.enemyX;
			double enemyFireY = w.enemyY;
			double myFireX = w.firePlaceX;
			double myFireY = w.firePlaceY;
			double currentX = getX();
			double currentY = getY();
			double vector1X = enemyFireX - myFireX;
			double vector1Y = enemyFireY - myFireY;
			double vector2X = enemyFireX - currentX;
			double vector2Y = enemyFireY - currentY;
			double vector1AngleFromNorth = Math.atan2(vector1Y,vector1X);
			double vector2AngleFromNorth = Math.atan2(vector2Y,vector2X);
			double enemyGunAngle = vector2AngleFromNorth - vector1AngleFromNorth;
			counter += 1;
			out.println("hit by bullet " + counter);
			if (counter == 1) {
				if (learningAngle[1] == 0) {
					learningAngle[1] = (enemyGunAngle);
					out.println("[1] " + learningAngle[1]);
				}
			}
			if (counter == 2) {
				if (learningAngle[1] != 0 && learningAngle[2] == 0 ){
					learningAngle[2] = (enemyGunAngle);
					out.println("[2] " + learningAngle[2]);
				}
			}
			if (counter == 3) {
				if (learningAngle[1] != 0 && learningAngle[2] != 0 && learningAngle[3] == 0) {
					learningAngle[3] = (enemyGunAngle);
					out.println("[3] " + learningAngle[3]);
				}
			}
			/*if (learningAngle[0] != 0 && learningAngle[1] != 0 && learningAngle[2] != 0) {
				learningAngle[0] = enemyGunAngle;
				learningAngle[1] = 0;
				learningAngle[2] = 0;
			}*/
			//out.println("hit by angle " + (Math.toDegrees(enemyGunAngle)));
			//out.println("cyan bullet now at angle " + learningAngle);
		}
		if (waveArray.size() == 0 ) {
			out.println("ERROR: NO WAVES DETECTED");
			out.println("SOLUTION: WALL RUNNING ENABLED");
			hasMoved = true;
			setTurnRight(e.getBearing() - 90);
		} else if (waveArray.size() > 0) {
			hasMoved = false;
		}
		if (hasMoved) {
			setAhead(400 * moveDirection);
			//double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
			//setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
		}
		
	}
	public double retrieveX(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double X = getX() + Math.sin(edir) * e.getDistance();
		return(X);
	}

	public double retrieveY(ScannedRobotEvent e) {
		double edir = getHeadingRadians() + e.getBearingRadians();
		double Y = getY() + Math.cos(edir) * e.getDistance();
		return(Y);
	}
	public void chooseDirection(ScannedRobotEvent e) {
		//if (getTurnRemaining() == 0) {
			/*if (hasMoved == false) {
				setAhead(distanceToTravel);
				hasMoved = true;
			}
			*/
			for (int i = 0; i < waveArray.size(); i++) {
			Wave w = waveArray.get(i);
			if (w.isClose(e) == true) {
				if (getTurnRemaining() == 0 ){
					if (hasMoved == false) {
					setAhead(distanceToTravel);
					hasMoved = true;
				}
			
				double radius;
				radius=(getTime()-w.startTime)*w.waveSpeed+w.waveSpeed;
				Point2D.Double hotBullet=project(w.origin,radius,w.angle);
				Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);
				Point2D.Double learnBullet = project(w.origin,radius,w.learning1);
				Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
				Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);
				Rectangle2D location = new Rectangle2D.Double(72,72,getX(),getY());
				if (location.contains(hotBullet) ||
				location.contains(latBullet) ||
				location.contains(learnBullet) ||
				location.contains(learnBullet2) ||
				location.contains(learnBullet3)) {
				double heading = getHeadingRadians();
				if (moveDirection == -1) {
					heading += Math.PI;	
				}
				while (heading > Math.PI * 2) {
					heading -= Math.PI * 2;	
				}
			
				hasMoved = false;
				setAhead(0);
				Rectangle2D nextLocation = new Rectangle2D.Double(72,72,targetX(e),targetY(e));
				if (!nextLocation.contains(hotBullet) ||
				!nextLocation.contains(latBullet) ||
				!nextLocation.contains(learnBullet) ||
				!nextLocation.contains(learnBullet2) ||
				!nextLocation.contains(learnBullet3)) {
					targetPlaceX = targetX(e);
					targetPlaceY = targetY(e);
				}
				
				
				Graphics g = getGraphics();
				g.setColor(Color.white);
				g.drawRect((int)targetPlaceX,(int)targetPlaceY,36,36);
						
				targetPlaceX-=getX();
				targetPlaceY-=getY();
			

				double theta = Math.atan2(targetPlaceX, targetPlaceY) - heading;
				
				while (theta > Math.PI * 2) {
					theta -= Math.PI * 2;	
				}
			
				while (theta < -(Math.PI * 2)) {
					theta += Math.PI * 2;	
				}
			
				if (Math.abs(theta) > Math.PI / 2) {
					theta -= Math.PI;
					moveDirection *= -1;
				}
			
				while (theta > Math.PI * 2) {
					theta -= Math.PI * 2;	
				}
			
				while (theta < -(Math.PI * 2)) {
					theta += Math.PI * 2;	
				}
				setTurnRightRadians(theta);
				//distance from points;
				double a = targetPlaceX;
				double b = targetPlaceY;
				double asquared = a * a;
				double bsquared = b * b;
				double difference = asquared + bsquared;
				double c = Math.sqrt(difference);
				out.println("distance to travel = " + Math.round(c));
				distanceToTravel = c * moveDirection;
			}
			}
			}
		}
	}															
	public double targetX(ScannedRobotEvent e) {
		//double randomX = new Double(Math.random() * (getBattleFieldWidth()));
		double xRandom1 = getX() + 172;
		double xRandom2 = getX() -172;
		double randomXPoint;
		if (Math.random() > .5) {
			randomXPoint = xRandom1;
		} else {
			randomXPoint = xRandom2;
		}
		double randomX = new Double(Math.random() * randomXPoint); 
		return(randomX);
	}
	public double targetY(ScannedRobotEvent e) {
		double yRandom1 = getY() + 172;
		double yRandom2 = getY() - 172;
		double randomYPoint;
		if (Math.random() > .5) {
			randomYPoint = yRandom1;
		} else {
			randomYPoint = yRandom2;
		}
		double randomY = new Double(Math.random() * randomYPoint); 
		return(randomY);
	}														
	public void surfWaves(ScannedRobotEvent e) {
		for (int i = 0; i < waveArray.size(); i++) {
			Wave w = waveArray.get(i);
			w.paint();
			w.movement();
			w.move();
			w.updateWaves(e);
			if( w.isClose(e) == true && getDistanceRemaining() == 0) {
				//setAhead(99 * moveDirection);
				double radius=(getTime()-w.startTime)*w.waveSpeed+w.waveSpeed;
				Point2D.Double hotBullet=project(w.origin,radius,w.angle);
				Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);
				Point2D.Double learnBullet = project(w.origin,radius,w.learning1);
				Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
				Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);
				Point2D.Double latBullet2=project(w.origin,radius,w.angle+w.latVel2);
				Point2D.Double latBullet3=project(w.origin,radius,w.angle+w.latVel3);
				Point2D.Double latBullet4=project(w.origin,radius,w.angle+w.latVel4);
				Point2D.Double latBullet5=project(w.origin,radius,w.angle+w.latVel5);
				double hotBulletX = hotBullet.x;
				double hotBulletY = hotBullet.y;
				double hotBulletCoordinates = (hotBulletX + hotBulletY);
				Point2D.Double hotBulletCoordinate = new Point2D.Double(hotBulletX, hotBulletY);
				double latBulletX = latBullet.x;
				double latBulletY = latBullet.y;
				double latBulletCoordinates = (latBulletX + latBulletY);
				Point2D.Double latBulletCoordinate = new Point2D.Double(latBulletX, latBulletY);
				double learnBulletX = learnBullet.x;
				double learnBulletY = learnBullet.y;
				double learnBulletCoordinates = (learnBulletX + learnBulletY);
				Point2D.Double learnBulletCoordinate1 = new Point2D.Double(learnBulletX,learnBulletY);
				double learnBullet2Coordinates = learnBullet2.x + learnBullet3.y;
				double learnBullet3Coordinates = learnBullet3.y + learnBullet3.y;
				Point2D.Double learnBullet2Coordinate = new Point2D.Double(learnBullet2.x,learnBullet2.y);
				
				double latBullet2X = latBullet2.x;
				double latBullet2Y = latBullet2.y;
				Point2D.Double latBullet2Coordinate = new Point2D.Double(latBullet2X, latBullet2Y);
				double latBullet3X = latBullet2.x;
				double latBullet3Y = latBullet3.y;
				double latBullet3Coordinates = (latBulletX + latBulletY);
				Point2D.Double latBullet3Coordinate= new Point2D.Double(latBullet3X, latBullet3Y);
				double latBullet4X = latBullet4.x;
				double latBullet4Y = latBullet4.y;
				double latBullet4Coordinates = (latBullet4X + latBullet4Y);
				Point2D.Double latBullet4Coordinate = new Point2D.Double(latBullet4X, latBullet4Y);
					
				//choosing where to go code  :-(
				Point2D.Double myLocat = new Point2D.Double(getX(),getY());
			/*	if (Math.abs(hotBulletCoordinate.distance(myLocat)) <= 100 ||
				Math.abs(latBulletCoordinate.distance(myLocat)) < 100/* ||
				Math.abs(latBullet2Coordinate.distance(myLocat)) < 100 ||
				Math.abs(latBullet3Coordinate.distance(myLocat)) < 100) {
					/*double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
					setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
					setAhead(100 * moveDirection);
				} else if (Math.abs(hotBulletCoordinate.distance(myLocat)) >= 100 ||
				Math.abs(latBulletCoordinate.distance(myLocat)) > 100/* ||
				Math.abs(latBullet2Coordinate.distance(myLocat)) > 100 ||
				Math.abs(latBullet3Coordinate.distance(myLocat)) > 100) {	
					/*double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
					setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
					moveDirection *= -1;
						
				}
				*/
				
				if (latBulletCoordinate.distance(myLocat) < 36 ||
					hotBulletCoordinate.distance(myLocat) < 36 ||
					learnBulletCoordinate1.distance(myLocat) < 36 ||
					learnBullet2.distance(myLocat) < 36 ||
					learnBullet3.distance(myLocat) < 36) {
						out.println("WARNING  HIT IMAGINARY BULLET!");
					}
				
				if (Math.min(latBulletCoordinates,hotBulletCoordinates) == latBulletCoordinates/* || learningAngle == +learningAngle*/){
					moveDirection *= -1;
					double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
					setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
					/*out.println("change direction bullet in front of me");
					out.println("lat bullet co: " + latBulletCoordinates);
					out.println("hot bullet co: " + hotBulletCoordinates);
					*/
					
				}
				if (Math.min(latBulletCoordinates,hotBulletCoordinates) == hotBulletCoordinates/* || learningAngle == -learningAngle*/) {
					setAhead(100 * moveDirection);
					/*
					out.println("hot dodge success reversing direction");
					*/
					double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
					setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
				}
				
				//learning bullet dodging code fix later
				
				if (learningAngle[1] != 0) {
					if (Math.min(learnBulletCoordinates,hotBulletCoordinates) == learnBulletCoordinates) {
						moveDirection *= -1;
						double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
						setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
					} 
					if (Math.min(learnBulletCoordinates,hotBulletCoordinates) == hotBulletCoordinates) {
						setAhead(100 * moveDirection);
					}
				}
				if (learningAngle[2] != 0) {
					if (Math.min(learnBullet2Coordinates,hotBulletCoordinates) == learnBullet2Coordinates) {
						moveDirection *= -1;
						double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
						setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
					} 
					if (Math.min(learnBulletCoordinates,hotBulletCoordinates) == hotBulletCoordinates) {
						setAhead(100 * moveDirection);
					}
				}
				if (learningAngle[3] != 0) {
					if (Math.min(learnBullet3Coordinates,hotBulletCoordinates) == learnBullet3Coordinates) {
						moveDirection *= -1;
						double goalDirection = e.getBearing() - 90 - 30 * moveDirection;
						setTurnRightRadians(getWallSmoothedTurn(Math.toRadians(goalDirection)));
					} 
					if (Math.min(learnBullet3Coordinates,hotBulletCoordinates) == hotBulletCoordinates) {
						setAhead(100 * moveDirection);
					}
				}
				//chooseDirection(e);
				if (w.isPast(e) == true) {
					waveArray.remove(w);//remove the wave once it passes us
			
				}
			}
		}
	}		
	
	public void checkIfEnemyFired(ScannedRobotEvent e) {
		double changeInEnergy = previousEnergy - e.getEnergy();
		if (changeInEnergy > 0 && changeInEnergy <= 3) {
			Wave w = new Wave(e, changeInEnergy);
			w.enemyX = retrieveX(e);
			w.enemyY = retrieveY(e);
			w.enemyVel = e.getVelocity();
			w.firePlace = getX() + getY();
			w.firePlaceX = getX();
			w.firePlaceY = getY();
			w.waveSpeed = 20 - (3 * changeInEnergy);
			w.bulletPower = 3;
			w.myVel = getVelocity();
			double absBearing=e.getBearingRadians()+getHeadingRadians();
			w.startTime=getTime();
			w.angle=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI);
			w.angle2=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI + .05);
			w.angle3=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI + .1);
			w.angle4=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI - .1);
			w.angle5=robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI - .05);
			
			w.learning1 = robocode.util.Utils.normalRelativeAngle(absBearing+Math.PI + learningAngle[0]);
			
			w.latVel =(getVelocity()*Math.sin(getHeadingRadians()-w.angle))/w.waveSpeed;
			w.latVel2 = (getVelocity()*Math.sin(getHeadingRadians()-(w.angle + (-moveDirection * 10))))/w.waveSpeed;
			w.latVel3 = (getVelocity()*Math.sin(getHeadingRadians()-(w.angle + (-moveDirection * 5))))/w.waveSpeed;
			w.latVel4 = (getVelocity()*Math.sin(getHeadingRadians()-(w.angle + (-moveDirection * -10))))/w.waveSpeed;
			w.latVel5 = (getVelocity()*Math.sin(getHeadingRadians()-(w.angle + (-moveDirection * -5))))/w.waveSpeed;
			
			/*w.latVel2 = (Math.sin(getHeadingRadians()-(w.angle + (moveDirection * 1))))/w.waveSpeed;
			w.latVel3 = (Math.sin(getHeadingRadians()-(w.angle + (moveDirection * .5))))/w.waveSpeed;
			w.latVel4 = (Math.sin(getHeadingRadians()-(w.angle + (moveDirection * -1))))/w.waveSpeed;
			w.latVel5 = (Math.sin(getHeadingRadians()-(w.angle + (moveDirection * -.5))))/w.waveSpeed;
			*/
			
			w.origin=project(new Point2D.Double(getX(),getY()),e.getDistance(),absBearing);
			
			waveArray.add(w);
		}
		previousEnergy = e.getEnergy();
	}
	public Point2D.Double project(Point2D.Double origin,double dist,double angle){
		return new Point2D.Double(origin.x+dist*Math.sin(angle),origin.y+dist*Math.cos(angle));
	}
		
	public class Wave {
		//info stored in wave
		double firePlace;  //whrere I am when he fires
		double firePlaceX;  //my X when he fires
		double firePlaceY;  //my Y when he fires
		double bulletPower;  //my bulletPower when he shot
		double enemyX;  //his X when he shot
		double enemyY;  //his Y when he shot
		double myVel;  //my velocity when he shot
		double enemyVel;  //the enemy's velocity when he shot
		double waveSpeed; //how fast the wave is moving
		double enemyPoint;  //where the enemy is when he fires
		
		//wave data
		double distanceFromOrigin = 0;  //how fast the wave is travelling
		
		//wave physics
		double originX;
		double originY;
		double startTime;
		
		//angle physics
		double angle;
		double angle2;
		double angle3;
		double angle4;
		double angle5;
		double latVel;
		double latVel2;
		double latVel3;
		double latVel4;
		double latVel5;
		
		double learning1;
		Point2D.Double origin;
		
		//info used with the wave
		double velCount;
		public Wave(ScannedRobotEvent e, double firePower) {
			//double changeInEnergy = previousEnergy - e.getEnergy();
			waveSpeed =20 - (3 * firePower);
			enemyX = retrieveX(e);
			enemyY = retrieveY(e);
			originX = retrieveX(e);
			originY = retrieveY(e);
			previousEnergy = e.getEnergy();
		}
	
		public void move() {
			distanceFromOrigin += waveSpeed;
		}
		public void paint() {
			double bottomX = originX - distanceFromOrigin;
			double bottomY = originY - distanceFromOrigin;
			Graphics g = getGraphics();
			g.setColor(Color.red);
			g.drawOval((int) bottomX, (int) bottomY, (int) (distanceFromOrigin * 2), (int) (distanceFromOrigin * 2));
		}
		public void movement() {
			for (int i = 0; i < waveArray.size(); i++) {
				Graphics g = getGraphics();
				g.setColor(Color.red);
				g.fillRect((int)enemyX,(int)enemyY,10,10);
			}
		}
		public void updateWaves(ScannedRobotEvent e) {
			for (int i = 0; i < waveArray.size(); i++) {
				double radius;
				Wave w = waveArray.get(i);
				radius=(getTime()-w.startTime)*w.waveSpeed+w.waveSpeed;
				Point2D.Double hotBullet=project(w.origin,radius,w.angle);
				Point2D.Double hotBullet2=project(w.origin,radius,w.angle2);
				Point2D.Double hotBullet3=project(w.origin,radius,w.angle3);
				Point2D.Double hotBullet4=project(w.origin,radius,w.angle4);
				Point2D.Double hotBullet5=project(w.origin,radius,w.angle5);
				
				Point2D.Double learnBullet = project(w.origin,radius,w.learning1);
				Point2D.Double learnBullet2 = project(w.origin,radius,w.angle + learningAngle[2]);
				Point2D.Double learnBullet3 = project(w.origin,radius,w.angle + learningAngle[3]);
				
				Point2D.Double latBullet=project(w.origin,radius,w.angle+w.latVel);
				Point2D.Double latBullet2=project(w.origin,radius,w.angle+w.latVel2);
				Point2D.Double latBullet3=project(w.origin,radius,w.angle+w.latVel3);
				Point2D.Double latBullet4=project(w.origin,radius,w.angle+w.latVel4);
				Point2D.Double latBullet5=project(w.origin,radius,w.angle+w.latVel5);
				Graphics g = getGraphics();
				g.setColor(new Color(100,0,0));
				g.fillOval((int)latBullet.x-(int)6,(int)latBullet.y-(int)7,(int)14,(int)14);
			//	g.drawLine((int)latBullet.x,(int)latBullet.y,(int)w.enemyX,(int)w.enemyY);
				g.fillOval((int)hotBullet.x-(int)6,(int)hotBullet.y-(int)7,(int)14,(int)14);
			//	g.drawLine((int)hotBullet.x,(int)hotBullet.y,(int)w.enemyX,(int)w.enemyY);
				/*
				g.setColor(Color.green);
				g.fillOval((int)latBullet2.x - 5,(int)latBullet2.y - 5,10,10);
				g.fillOval((int)latBullet3.x - 5,(int)latBullet3.y - 5,10,10);
				g.fillOval((int)latBullet4.x - 5,(int)latBullet4.y - 5,10,10);
				g.fillOval((int)latBullet5.x - 5,(int)latBullet5.y - 5,10,10);
				g.fillOval((int)hotBullet2.x-(int)5,(int)hotBullet2.y-(int)5,10,10);
				g.fillOval((int)hotBullet3.x-(int)5,(int)hotBullet3.y-(int)5,10,10);
				g.fillOval((int)hotBullet4.x-(int)5,(int)hotBullet4.y-(int)5,10,10);
				g.fillOval((int)hotBullet5.x-(int)5,(int)hotBullet5.y-(int)5,10,10);
				*/
				
				if (learningAngle[1] != 0) {
					g.setColor(new Color(0,0,100));
					g.fillOval((int)learnBullet.x-(int)6,(int)learnBullet.y-(int)6,12,12);
					//g.drawLine((int)learnBullet.x,(int)learnBullet.y,(int)w.enemyX,(int)w.enemyY);
					//g.drawLine((int)learnBullet.x,(int)learnBullet.y,(int)getX(),(int)getY());
				} 
				if (learningAngle[2] != 0) {
					g.setColor(new Color(0,0,100));
					g.fillOval((int)learnBullet2.x,(int)learnBullet2.y,12,12);
					//g.drawLine((int)learnBullet2.x,(int)learnBullet2.y,(int)retrieveX(e),(int)retrieveY(e));
				}
				if (learningAngle[3] != 0) {
					g.setColor(new Color(0,0,100));
					g.fillOval((int)learnBullet3.x,(int)learnBullet3.y,12,12);
					//g.drawLine((int)learnBullet3.x,(int)learnBullet3.y,(int)retrieveX(e),(int)retrieveY(e));
				}
			}
		}
		public boolean isClose(ScannedRobotEvent e) {
			if (distanceFromOrigin > e.getDistance() - 500) {
				return (true);
			} else {
				return (false);
			}	
		}	
	
		public boolean isPast(ScannedRobotEvent e) {
			if (distanceFromOrigin >= e.getDistance() - 36) {
				return (true);
			} else {
				return (false);
			}
		}
	}
}
					

