package djc;
import robocode.*;
import java.util.LinkedList;

/**
 * FireResponseAnalyser
 */
public class FireResponseAnalyser // implements java.io.Serializable
{
    public boolean isDodging = false;
    public boolean isPredictable = false;
    public Target t = null;
    public static final double CLOSENESS = 40;
    public static final double HEADING_FUDGE = Math.toRadians(5);

    public FireResponseAnalyser(Target _t)
    {
	t = _t;
	reset();
    }

    public void reset()
    {
	isDodging = false;
    }

    public void analyse()
    {
	isDodging = false;
	
	if(t.currentFireRespPos != -1) {
	    Coordinate cAimedAt = t.fireResponse[t.currentFireRespPos][Target.AIMED_AT];
	    Coordinate cActual = t.fireResponse[t.currentFireRespPos][Target.ACTUAL_LOCATION];
	    int i = t.currentFireRespPos - 1;
	    int c = 0;
	    if(i<0) i = Target.MAX_HISTORY - 1;

	    while(cAimedAt == null || cActual == null) {
		cAimedAt = t.fireResponse[t.currentFireRespPos][Target.AIMED_AT];
		cActual = t.fireResponse[t.currentFireRespPos][Target.ACTUAL_LOCATION];
		i--;
		if(i<0) i = Target.MAX_HISTORY - 1;
		if(i == t.currentFireRespPos || c == Target.MAX_HISTORY - 1) { // back to where we started
		    isDodging = false;
		    return;
		}

		if(cAimedAt != null && cActual != null) {
		    if(cActual.distanceFrom(cAimedAt) > MathHelper.BOT_RADIUS) {  
			isDodging = true;  // This is probably every missed shot
			return;
		    }
		}
		c++;
	    }
	}
    }

    /**
     * Simplistic approach:
     *  Assume it will dodge the same way that it did sometime in the past.
     *  Randomly find one where distance between self and target is within
     *  CLOSENESS distance units and apply the difference between the
     *  AIMED_AT and ACTUAL_LOCATION to targettedLocation.
     */
    public Coordinate adjustAim(Coordinate targetedLocation)
    {
	try {
	LinkedList candidateFireResponses = new LinkedList();
	int bestIndexByHeading = -1;
	double bestHeading = Double.MAX_VALUE;
	double bestVel = Double.MAX_VALUE;

	// First, find list of responses at current range
	for(int i=0;i<Target.MAX_HISTORY;i++) {
	    Position pWhenFired = t.fireResponse[i][Target.WHEN_FIRED];
	    if(pWhenFired != null && t.fireResponse[i][Target.AIMED_AT] != null
	       && t.fireResponse[i][Target.ACTUAL_LOCATION] != null) {
		if(t.fireResponseTargetingStrat[i] == t.targetMode) {
		    if(Math.abs(t.self.myPos.distanceFrom(t.position) -
				pWhenFired.distanceAway) < CLOSENESS) {
			Integer candidateIndex = new Integer(i);
			candidateFireResponses.add(candidateIndex);
			if(Math.abs(pWhenFired.heading - t.heading_rad) <
			   Math.abs(bestHeading - t.heading_rad) + HEADING_FUDGE) {
			    if(Math.abs(pWhenFired.velocity - t.velocity) < 4) {
				bestHeading = pWhenFired.heading;
				bestVel = pWhenFired.velocity;
				bestIndexByHeading = i;
			    }
			}
		    }
		}
	    }
	}
	
	if(candidateFireResponses.size() == 0) { // Nothing found
	    isPredictable = false;
	    return targetedLocation;
	} else {
	    int iterations = 0;
	    Coordinate retval = new Coordinate(targetedLocation.x, targetedLocation.y);
	    
	    do {
		int randomIndex;
		if(candidateFireResponses.size() == 1) randomIndex = 0;
		else randomIndex = t.self.random.nextInt(candidateFireResponses.size() - 1);
		
		Integer theIndex;
		if(iterations != 0) {
		    theIndex = (Integer)candidateFireResponses.get(randomIndex);
		} else {  // force best index by heading first time
		    theIndex = new Integer(bestIndexByHeading);
		}

		Coordinate cAimHere = t.fireResponse[randomIndex][Target.AIMED_AT];
		Coordinate cActualLocation = t.fireResponse[randomIndex][Target.ACTUAL_LOCATION];

		if(cAimHere != null && cActualLocation != null) {
		    double dx = cAimHere.x - cActualLocation.x;
		    double dy = cAimHere.y - cActualLocation.y;
		    retval.x = targetedLocation.x + dx;
		    retval.y = targetedLocation.y + dy;
		}

		iterations++;
	    } while (iterations < Math.min(4, candidateFireResponses.size() - 1) && retval.offField());
	    
	    // ???
	    retval = Coordinate.limitToBattleField(retval);
	    if(!retval.offField()) return retval;
	    else return targetedLocation;
	}
	} catch (Exception e) {
	    e.printStackTrace(t.self.out);
	    return targetedLocation;
	}
    }


}
