package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;

public class SurfBufferN  extends SurfBuffer {
	
	private static double[][][][][]surfStats = new double[BasicWaveSurfer.SEG_WALL_PROXIMITY][BasicWaveSurfer.SEG_BULLET_POWER][BasicWaveSurfer.SEG_ACCEL][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.BINS];
	public SurfBufferN(int weight) {
		super(weight);
	}
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegWallProximity(),wave.getSegBulletPower() , wave.getSegAccel(),wave.getSegLateralVelocity()));
	}
	
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 4)
			throw new IllegalArgumentException("args length must be 4");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]][args[3]], this.getWeight());
	}

}
