package davidalves.net.data;

import robocode.*;
import davidalves.net.*;
import davidalves.net.math.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

/**
 * @author David Alves
 *
 */
public class DuelEnvironment implements EnvironmentInterface{
	int roundNumber = 1, totalRounds = 1;
	int numRobots = 0;
	int numRemainingRobots = 0;
	long time = 0;
	Point arenaSize = new Point(5000,5000);
	boolean targetLocked = false;
	
	Hashtable robots = new Hashtable();
	HashSet enemyBullets = new HashSet();
	RobocodeRobot target = null;
	AbstractAdvancedBot me;
	
	
	public DuelEnvironment(AbstractAdvancedBot myDaveBotInstance){
		me = myDaveBotInstance;
	}
	
	public void setBattleData(int numberOfOtherRobots, double fieldHeight, double fieldWidth, int roundNumber, int totalRounds){
		targetLocked = false;
		arenaSize = new Point(fieldWidth, fieldHeight);
		numRobots = numberOfOtherRobots + 1;
		numRemainingRobots = numberOfOtherRobots;
	}


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// Utility Functions ///////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public RobocodeRobot getTarget(){
		return target;
	}
	
	public Enumeration getRobotEnumeration(){
		return robots.elements();
	}
	
	public RobocodeRobot getRobotByName(String s){
		return target;
	}

	public void updateBattleData(int i, long l) {
		numRemainingRobots = i;
		time = l;
	}
	
	public int enemiesRemaining(){
		return numRemainingRobots;
	}
	
	public Iterator getEnemyBulletIterator(){
		return enemyBullets.iterator();
	}
	
	public Point getArenaSize(){
		return arenaSize;	
	}
	
	public Point getArenaCenter(){
		return new Point(arenaSize.getX() / 2, arenaSize.getY() / 2);
	}
	
	public boolean isOutOfBounds(Point p){
		if (p.getX() < -10 || p.getY() < -10 || (p.getX() > arenaSize.getY() + 10) || (p.getY() > arenaSize.getY() + 10)){
				return true;
		} else {
			return false;
		}
	}
	
	public int numberOfEnemyBullets(){
		return enemyBullets.size();
	}
	
	public double closestEnemyDistance(){
		return getClosestTarget().getDistance();
	}
	


/////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// Targeting Functions ////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

	
	public void selectTarget(){
		selectClosestTarget();
		if (targetLocked() && me.getTime() - target.getLastScannedTime() > 30){
			lostLock();
		}
	}
	
	public void selectTargetByName(String name){
		target = getRobotByName(name);
	}
	
	public boolean targetLocked(){
		return targetLocked;
	}
	
	private void lostLock(){
		//if (me.getOthers() > 0)
		//me.out.println("Lost target lock");
		target = null;
		targetLocked = false;
	}
	
	private void obtainedLock(){
		if (target.alive()){
			//me.out.println(DaveString.underline("\nObtained target lock") + target);
			targetLocked = true;
		}
	}
	
	public void selectClosestTarget(){
		//Does nothing because in a duel, there's only one target to select...
	}

	public RobocodeRobot getClosestTarget(){
		return target;
	}
	
	
	public RobocodeRobot getClosestNonDaveBotTarget(){
		return target;
	}
	
/////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// Collaboration Functions ////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	
	public int remainingDaveBotsIncludingMe(){
		return 1 + remainingOtherDaveBots();
	}
	
	public int remainingOtherDaveBots(){
		return 0;
	}
	
	
	public int myDaveBotPosition(){
		return 0;
	}
	
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// Scanning Functions //////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public void updateScanData(ScannedRobotEvent e, AbstractAdvancedBot me){
		if (target != null){
			
			//Since the environment persists between rounds, we need to  check if this is the first scan for this round
			if(!targetLocked)
				obtainedLock();
			//NOTE: Taking this out will hang Robocode if we skip a turn while processing a 
			//ScannedRobotEvent, causing us to receive two ScannedRobotEvents from the same bot
			//on the next turn. Coooool.... I can hang Robocode! >:)
			if(target.getLastScannedTime() == me.getTime()){
				me.warning("DuelEnvironment::updateScanData()", "Two ScannedRobotEvents in a single turn... Last turn skipped?");
				return;
			}
			
			double deltaEnergy = target.getEnergy() - e.getEnergy();
			if (deltaEnergy >= .1 && deltaEnergy <= 3){
				enemyBullets.add(new EnemyBullet(
						DaveMath.normalizeAbsoluteAngle(e.getBearing()  + me.getHeading() + DaveMath.HALFCIRCLE + Math.random() * 35 - 70),
						deltaEnergy,
						target.getLocation(),
						me.getTime() - 1));
				//me.out.println(" Incoming bullet from: " + DaveMath.normalizeAbsoluteAngle(e.getBearing()  + me.getHeading() + DaveMath.HALFCIRCLE));
				target.setLastFiredTime(me.getTime());
				target.setLastBulletPower(deltaEnergy);
			}
			target.updateScan(e, me);
			
		} else {
			
			target = new RobocodeRobot(e, me);	
			obtainedLock();
			//me.out.println("Updating scan data for robot: " + e.getName() + "Number of robots scanned: " + robots.size());
		}
	}
	
	
	public RobocodeRobot getEnemyScannedLongestAgo(){
		return target;
	}
	
	public void robotDied(String robotName){
		lostLock();
	}
}
