package davidalves.net.data;

import robocode.*;
import davidalves.net.*;
import davidalves.net.math.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

/**
 * @author David Alves
 *
 */
public interface EnvironmentInterface{
	public void setBattleData(int numberOfOtherRobots, double fieldHeight, double fieldWidth, int roundNumber, int totalRounds);


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// Utility Functions ///////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public RobocodeRobot getTarget();
	
	public Enumeration getRobotEnumeration();
	
	public RobocodeRobot getRobotByName(String s);

	public void updateBattleData(int i, long l);
	
	public int enemiesRemaining();
	
	public Iterator getEnemyBulletIterator();
	
	public Point getArenaSize();
	
	public Point getArenaCenter();
	
	public boolean isOutOfBounds(Point p);
	
	public int numberOfEnemyBullets();
	
	public double closestEnemyDistance();
	


/////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// Targeting Functions ////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

	
	public void selectTarget();
	
	public void selectTargetByName(String name);
	
	public boolean targetLocked();
	
	public void selectClosestTarget();

	public RobocodeRobot getClosestTarget();
	
	
	public RobocodeRobot getClosestNonDaveBotTarget();
	
/////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// Collaboration Functions ////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	
	public int remainingDaveBotsIncludingMe();
	
	public int remainingOtherDaveBots();
	
	
	public int myDaveBotPosition();
	
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// Scanning Functions //////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
	
	public void updateScanData(ScannedRobotEvent e, AbstractAdvancedBot me);
	
	
	public RobocodeRobot getEnemyScannedLongestAgo();
	
	public void robotDied(String robotName);
}
