package davidalves.net.targeting.strategies;

import robocode.*;
import davidalves.net.*;
import davidalves.net.math.*;
import davidalves.net.data.*;
import davidalves.net.targeting.TargetingStrategyInterface;
import davidalves.net.util.*;
import java.io.*;
import java.util.*;

/**
 * @author David Alves
 */
public class InstantaneousCircularStrategy implements TargetingStrategyInterface, Serializable {
	//This is bullshit
	
	public InstantaneousCircularStrategy(){
	}
	
	public Point predictedIntercept(AbstractAdvancedBot me, EnvironmentInterface environment, double bulletPower){	
		RobocodeRobot target = environment.getTarget();
		long time;
		Point p = target.getLocation();
		Point arenaSize = environment.getArenaSize();
		//Iterate through a few times to increase the accuracy of the interception point
		for (int positionGuessCounter = 1; positionGuessCounter < 10; positionGuessCounter++){
			time = me.getTime() + (long)(me.getLocation().distanceTo(p) /(20-(3 * bulletPower)));
			p = guessPositionCircular(target, time, arenaSize);
			//me.out.println("Guess #" + positionGuessCounter + ": " + p);
		}
		
		//offsets the gun by the angle to the next shot based on linear targeting provided by the enemy class
		return p;
	}
	
	Point guessPositionCircular(RobocodeRobot target, long when, Point arenaSize) {
		double diff = when - target.getLastScannedTime();
		double newY, newX;
		double deltaHeading = target.getDeltaHeading();
		double heading = target.getHeading();
		double speed = target.getSpeed();
		double x = target.getX();
		double y = target.getY();
		
		if (diff == 0){
			return target.getLocation();
		}
		//if target is turning, use circular
		if (Math.abs(deltaHeading) > 0.1) {
			double radius = (speed / deltaHeading);
			double totalHeading = diff * deltaHeading;
			
			newX = x + (DaveMath.xComponent(heading) * radius) - (DaveMath.xComponent(heading + totalHeading) * radius);
			newY = y + (DaveMath.yComponent(heading + totalHeading) * radius) - (DaveMath.yComponent(heading) * radius);
		}
		//otherwise use linear
		else {
			
			newX = x + DaveMath.xComponent(heading) * speed * diff;
			newY = y + DaveMath.yComponent(heading) * speed * diff;
		}
		//If the robot is going to go off the edge of the battlefield, we need to shoot at the place where it will hit the edge
		newX = Math.min(arenaSize.getX() - 15,Math.max(newX, 15));
		newY = Math.min(arenaSize.getY() - 15,Math.max(newY, 15));
		
		return new Point(newX, newY);
	}
	
	public String toString(){
		return "CIRCULAR";
	}
}

