/*
 * Created on 2004-10-9
 */
package tide;

/**
 * this event occurred when you are hit another robot
 * 
 * @author xiemin
 */
public class HitRobotEvent extends Event
{
	//the x position of the robot you hit
	private double x;
	//the y position of the robot you hit
	private double y;
	//the name of the robot you hit
	private String name;

	/**
	 * create a new HitRobotEvent
	 * @param event robocode HitRobotEvent
	 * @param robot robocode AdvancedRobot
	 */
	public HitRobotEvent(robocode.HitRobotEvent event, robocode.AdvancedRobot robot)
	{
		super(event);
		this.name = event.getName();
		this.x = robot.getX()+ Math.sin(event.getBearingRadians()
			+ robot.getHeadingRadians())*50;
		this.y = robot.getY()+ Math.cos(event.getBearingRadians()
			+ robot.getHeadingRadians())*50;
	}
		
	/**
	 * Return the x position of the robot you hit
	 * @return the x position of the robot you hit
	 */
	public double getX()
	{
		return x;
	}

	/**
	 * Return the y position of the robot you hit
	 * @return the y position of the robot you hit
	 */
	public double getY()
	{
		return y;
	}

	/**
	 * Return the name of the robot you hit
	 * @return the name of the robot you hit
	 */
	public String getName()
    {
		return name;
    }	

}


