/*
 * Created on 2004-9-27
 */
package tide.pear;

import java.awt.geom.Point2D;

import tide.util.Wave;

/**
 * ӵƷ
 * @author xiemin
 */
public class BulletForceAnalyzer
{
	//ӵ
	private static final double RANGE_BULLET = 800;
	private static final double DELTA_BULLET_FRON_MAX = 85; // R = 300
	private static final double DELTA_BULLET_FRON_MIN = 55; // R = 200
	private static final double DELTA_BULLET_BACK = 5; // R = 0
	private static final double DELTA_BULLET_WIDTH = 20; // R = 70
	
	/**
	 * õָwaveָλò
	 * @param point
	 * @param wave
	 * @param time
	 * @return
	 */
	/*public double getForce(Point2D yourPos, Point2D point, Wave wave, long time)
	{
		double force = 0;
		
		double r = yourPos.distance(wave.getStartPosition());
		double heading = wave.getAbsBearing()-wave.getMaxEscapAngle();
		double gap = 2*wave.getMaxEscapAngle()/(wave.getFactorsAmount() - 1);
		
		for(int i=0; i<wave.getFactorsAmount() - 1; i++)
		{
			VirtualBullet bullet = getVirtualBullet(wave, heading+i*gap);
			double angle = MathUtils.heading(wave.getStartPosition(), point);
			Point2D countPos = MathUtils.nextPoint(wave.getStartPosition(), angle, r);
			force += getForce(countPos, bullet, time);
		}
		//double maxHeading = wave.getMostFacterHeading();
		//VirtualBullet bullet = getVirtualBullet(wave, maxHeading);
		//bullet.setFactor(1);
		//force = getForce( point, bullet, time);
		//Tide.log("bullet force : " + force);
		return force;
	}*/
	public double getForce(Point2D yourPos, Point2D point, Wave wave, long time)
	{
		double force = 0;
		
		int count = (int)Math.round(8d*600d/yourPos.distance(wave.getStartPosition()));
		if(count >= (wave.getFactorsAmount() - 1)/2){
			count = (wave.getFactorsAmount() - 1)/2 - 1;
		}
		int index = wave.getFactorIndex(point);
		if(index<0 || index>= wave.getFactorsAmount()){
			//Pear.log("error index : " + index);
			return Double.MAX_VALUE;
		}
		/*for(int i=0; i<wave.getFactorsAmount(); i++){
			//force += wave.getFactor(i)/Math.pow((double) (Math.abs(index - i) + 1.0), 0.5);
			force += wave.getFactor(i)*(float)Math.pow(0.618, Math.abs(index - i));
		}
		return force/(Math.abs(wave.getRemainTime(time, point)) + 1d);
		*/
		force = wave.getFactor(index);
		double div = 0;
		for(int i=1; i<=count; i++){
			//div = Math.pow(i+1d, 0.5);
			div = i;
			if(index+i < wave.getFactorsAmount()){
				force += wave.getFactor(index + i)/div;
			}else{
				force += wave.getFactor(index - i)/div;
			}
			
			if(index-i >= 0){
				force += wave.getFactor(index - i)/div;
			}else{
				force += wave.getFactor(index + i)/div;
			}
		}

		return wave.getPower()*force/(Math.abs(wave.getRemainTime(time, point)) + 1d);
		
	}
	
	
	//õӵָ,ӵưӵηֲ
	/*private double getForce( Point2D point, VirtualBullet bullet, long time)
	{
		double distance = MathUtils.distance( bullet.getCurrentPosition(time), point );
		double heading = MathUtils.heading( bullet.getCurrentPosition(time), point );
		double bearing = MathUtils.bearing( heading, bullet.getHeading());
		double x = distance*Math.cos( bearing );
		double y = distance*Math.sin( bearing );

		double power = Math.max(1,bullet.getPower());
		double deltaFront = -0.5*power*(DELTA_BULLET_FRON_MAX - DELTA_BULLET_FRON_MIN);
	    deltaFront += DELTA_BULLET_FRON_MAX ;
		deltaFront += (DELTA_BULLET_FRON_MAX - DELTA_BULLET_FRON_MIN)/2;
		
		double range;
		if( x > 0 ) range = MathUtils.gauss( x, RANGE_BULLET*bullet.getFactor(), deltaFront );
		else range = MathUtils.gauss( x, RANGE_BULLET*bullet.getFactor(), DELTA_BULLET_BACK);
		
		return MathUtils.gauss( y, range, DELTA_BULLET_WIDTH );
	}
	
	//waveָķϽһӵ
	private VirtualBullet getVirtualBullet( Wave wave, double heading )
	{
		VirtualBullet bullet = new VirtualBullet();
		
		bullet.setFirePosition(wave.getStartPosition());
		bullet.setFireTime(wave.getStartTime());
		bullet.setHeading(heading);
		bullet.setPower(wave.getPower());
		bullet.setFactor(wave.getFactor(heading));
		
		return bullet;
	}
	*/
}





