package whind;

import java.awt.geom.*;
import robocode.util.Utils;
import robocode.*;

/**
 * EBullet - a class by (your name here)
 */
public class EBullet
{
	private double startX;
	private double startY;
	private double targetX;
	private double targetY;
	private double distTraveled;
	private double distToTarget;
	double velocity;
	
			
	public EBullet(double sX, double sY, double tX, double tY, double dToTarget, double power) {
		startX = sX;
		startY = sY;
		targetX = tX;
		targetY = tY;
		distToTarget = dToTarget;
		distTraveled = 0;
		velocity = getBulletSpeed(power);
	}
	
	public double getBulletSpeed(double thePower) {
        return 20-thePower*3;
    }
	
	public double getStartX() {
		return startX;
	}
	
	public double getStartY() {
		return startY;
	}
	
	public Point2D.Double getStartCoords() {
		return new Point2D.Double(startX, startY);
	}
	
	public double getTargetX() {
		return targetX;
	}
	
	public double getTargetY() {
		return targetY;
	}
	
	public Point2D.Double getTargetCoords() {
		return new Point2D.Double(targetX, targetY);
	}
	
	public double getDistTraveled() {
		return distTraveled;
	}
	
	public double getDistRemaining() {
		return distTraveled - distToTarget;
	}
	
	public double update() {
		distTraveled += velocity;
		return getDistRemaining();
	}
}