/*
 * Created on 19/02/2004
 * Author: Marcos Machado
 *
 * TDS - Telecommunication Data Systems ltda.                                                   *
 *                                                                        
 * Copyright (C)                                                          
 * This software may not be copied or distributed in any form without the 
 * written permission of TDS - Telecommunication Data Systems ltda.                             *
 */
package axeBots.pilot.navigator;
import axeBots.AxeBot;
import axeBots.Okami;
import axeBots.data.BitRater;
import axeBots.data.SegmentedGFs;
import axeBots.okami.AxeTarget;
import axeBots.okami.AxeVector;
import axeBots.pilot.AxePilot;
import axeBots.pilot.waves.EnemyWave;
import java.awt.geom.*;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
/**
 * @author Marcos Machado
 * @since 19/02/2004 @modified
 */
public class WaveNavigator {
    private int desiredGF;
    private long timeToStop;
    protected Okami me= null;
    protected AxeTarget enemy= null;
    protected EnemyWave wave= null;
    protected SegmentedGFs gfHolder= null;
    protected boolean dangerPts[]= new boolean[SegmentedGFs.GF_QT];
    //    private int desiredGF= 8;
    private ArrayList velVector= new ArrayList();
    private AxePilot pilot= null;
    private int travelDistance= 0;
//    private Course course= null;
    /**
     * @author Marcos Machado
     * @since 19/02/2004 @modified
     */
    public WaveNavigator(AxePilot pilot) {
        super();
        me= AxeBot.getIt();
        this.pilot= pilot;
        Course.setLastChangeTime(0);
    }
    
    private void navigate(boolean newWave) {
        boolean stop= false;
        int iteration= 0;
        boolean re= me.isRe();
        if (wave != null) {
            if (newWave) {
                Course .traceCourse( this);
                
            } else {
                Course.process();
                if (Course.getCourse().timeToWall == 0) {
                    this.setTravelDistance(0);
                }
            }
            if (me.isRe() ^ Course.getCourse().re) {
                pilot.invert();
            }
            double desired= wave.gfToLinear(Course.getCourse().chosen, Course.getCourse().arc);
            //            desired *= -1 * (wave.getDir());
            //            arcPos *= -1 * (wave.getDir());
            double diff= (desired - Course.getCourse().arcPos);
            
//            //amacia (problkemas)
//            double modDiff = Math.abs(diff);
//            int startDngr = Course.getCourse().toDngr ;
//            modDiff = (modDiff==0)?0:(startDngr==0)?100:Math.ceil(modDiff/startDngr);
//            diff=(diff<0)?-modDiff:modDiff;
            
            //                			diff = (wave.getDir()*desloc < 0 )?-diff:diff;
            //            System.out.println(". course at " + me.getTime() + "\r\n" + course);
            //            System.out.println("surfing to desired:" + desired);
            if (wave.getDir() < 0) {
                diff *= -1;
            }
            double d= (me.isRe()) ? -diff : diff;

            //treme
            if (d == 0) {
            	
                d= -2;
            }
            
            if(Course.dontStop && d<=0){
            	d=50;
            }
            
                this.setTravelDistance((int)d);
                desiredGF= Course.getCourse().chosen;
            } else {
                clearDangerPts();
                this.setTravelDistance(0);
            }
        }
        protected int chooseFuture(boolean dgrs[]) {
            int choosen= 0;
            while (dgrs[choosen= (int) (Math.random() * dgrs.length)]);
            return choosen;
        }
        //tem que ser melhorado, nao leva em conta acc e desacc
        
        /**
         * @return @author Marcos Machado
         * @since 19/02/2004 @modified
         */
        public AxeTarget getEnemy() {
            return enemy;
        }
        /**
         * @return @author Marcos Machado
         * @since 19/02/2004 @modified
         */
        
	private void clearDangerPts() {
				for (int i= 0; i < dangerPts.length; i++) {
					dangerPts[i]= false;
				}
			}
			
        public SegmentedGFs getGfHolder() {
            return gfHolder;
        }
        /**
         * @return @author Marcos Machado
         * @since 19/02/2004 @modified
         */
        public EnemyWave getWave() {
            return wave;
        }
        /**
         * @param target
         * 
         * @author Marcos Machado
         * @since 19/02/2004 @modified
         */
        private void setEnemy(AxeTarget target) {
            enemy= target;
            gfHolder=
                (target == null) ? null : enemy.getBotData().getGfHistory();
        }
        /**
         * @param wave
         * 
         * @author Marcos Machado
         * @since 19/02/2004 @modified
         */
        public void setWave(EnemyWave wave) {
            //        System.out.println(" velocity:" + me.getVelocity() + " at:"
            //                + me.getTime() + " desloc:" + me.getLastDesloc());
            if (this.wave != wave) {
                this.setEnemy((wave == null) ? null : wave.getOwner());
                this.wave= wave;
                navigate(true);
                //            System.out.println("NEW WAVE! at:" + me.getTime());
            } else {
                navigate(false);
                if ((wave != null) && wave.isDangerZone()) {
                    //navigate();
                    //                System.out.println("DANGER ZONE! at:" + me.getTime());
                }
            }
        }
        /**
         * @return
         */
        public boolean[] getDangerPoints() {
            return dangerPts;
        }
        /**
         * @return
         */
        public long getTimeToStop() {
            long ret= timeToStop;
            //        if ((wave != null) && wave.isDangerZone()) {
            //            int gf= wave.getMyGF() + 1;
            //            gf= (gf > (dangerPts.length - 1)) ? dangerPts.length - 1 : gf;
            //            if (!dangerPts[gf]) {
            //                return me.getTime() + 1000;
            //            }
            //        }
            return ret;
        }
        /**
         *  
         */
        public int getAimedGF() {
            return desiredGF;
        }
        /**
         * @return
         */
        public int getTravelDistance() {
            return travelDistance;
        }
        /**
         * @param i
         */
        public void setTravelDistance(int i) {
            travelDistance= i;
        }
    }
