package tobe.movement;
import tobe.util.*;
import tobe.statistics.*;
import tobe.platform.*;
import robocode.*;
import java.awt.geom.*;

/**
 * Fluid - like when you squeeze a tube
 * @version 2
 * @author Torbjrn Gannholm
 */
public class Fluid implements Movement
{
	private BearingVector turn = new BearingVector();
	private BearingVector wall = new BearingVector();
	private BearingVector a = new BearingVector();
	private BearingVector b = new BearingVector();
	private double ranX;
	private double ranY;
	private double movement = 400;
	private boolean newMove;
		
	public void init(CommandCentre cc) {
	}
		
	public void go(CommandCentre cc) {
		AdvancedRobot bot = cc.getBot();
		double x = bot.getX();
		double y = bot.getY();
		double myHeading = bot.getHeadingRadians();
		if(movement < 0) myHeading = BearingVector.normalizeAngle(myHeading+Math.PI);

		newMove = false;
		if(bot.getDistanceRemaining() == 0) {
			movement = -movement;
			myHeading = BearingVector.normalizeAngle(myHeading+Math.PI);
			newMove = true;
		}

		turn.setPolar(myHeading, 1);
			
		java.util.Iterator i;
			
			//calculate shrapnel effect (try to avoid bullets)
			double shrapnelWeight = 1;
			i = cc.getShrapnelIterator();
			while( i.hasNext() ) {
				Shrapnel s = (Shrapnel) i.next();
				a.setPoints(x, y, s.getToX(), s.getToY());
				double diff = BearingVector.normalizeAngle(a.getBearing() - s.getBearing());//my position relative to bullets motion
				diff = Math.abs(Math.PI/2 - diff)-Math.PI/4;//get out of way if heading for me, don't move into it otherwise
				//a.setDistance(8*(20-3*s.getPower())/a.getDistance());//a factor divided by time to impact
				a.setDistance(s.getPower()*bot.getWidth()/a.getDistance());
				b.setVector(a);
				//don't ask, I am confused
				a.setBearing(a.getBearing()+diff);
				b.setBearing(b.getBearing()-diff);
				a.add(turn,1);
				b.add(turn,1);
				BearingVector temp = turn;
				if(a.getDistance() > b.getDistance()) {
					turn = a;
					a = temp;
				} else {
					turn = b;
					b = temp;
				}
			}
		double turnAngle;
		//see if I should reverse because of dodging
		turnAngle = BearingVector.normalizeAngle(turn.getBearing() - myHeading);
		if(Math.abs(turnAngle) > 3*Math.PI/4) {
			turn.setBearing(turn.getBearing()+Math.PI);
			if(!newMove) {
				movement = -movement;
				myHeading = BearingVector.normalizeAngle(myHeading+Math.PI);
			}
			newMove=true;
		}

		TargetStatistics t;
						
        //now we try to go orthogonal to all bots, don't ask me why :-)
		try {
		i = cc.getTargetStatisticsIterator();
        while( i.hasNext() ) {
			t = (TargetStatistics) i.next();
			if(t.isSeen()) {
				a.setVector(t.getPosition());
				a.changeOrigin(x,y);
				a.setDistance(1);
				b.setVector(a);
				a.setBearing(a.getBearing()+Math.PI/2);
				b.setBearing(b.getBearing()-Math.PI/2);
				a.add(turn,1);
				b.add(turn,1);
				BearingVector temp = turn;
				if(a.getDistance() > b.getDistance()) {
					turn = a;
					a = temp;
				} else {
					turn = b;
					b = temp;
				}
			}
		}
		}
		catch(java.util.ConcurrentModificationException e) {
			//sad, but I don't bother with it now...
		}
		
		//try to get to optimal distance to target
		t = cc.getPreferredTarget();
		if(t != null) {
			a.setVector(t.getPosition());
			a.changeOrigin(x,y);
			//closer or further
			a.setDistance((a.getDistance() - 200)/200);//200 is assumed optimal for now
			turn.add(a,1);
		}
		
		//stay within the hard limits
		Rectangle2D.Double field = cc.getPlayingField();
		for(int k=0; k<2; k++) {//twice, I might be in a corner
            //check if I want to go towards a wall
            wall.setPolar(turn.getBearing(), 10000, bot.getX(), bot.getY());
            if(wall.getToX() < field.getMinX()) wall.setDistanceToX(field.getMinX());
            if(wall.getToX() > field.getMaxX()) wall.setDistanceToX(field.getMaxX());
            if(wall.getToY() < field.getMinY()) wall.setDistanceToY(field.getMinY());
            if(wall.getToY() > field.getHeight()) wall.setDistanceToY(field.getHeight());
			wall.setDistance(1.0001*wall.getDistance());//just to make sure the outcode falls out
				
			//don't crash into walls
			int code = field.outcode(wall.getToX(), wall.getToY());
			for(int wallindex = 0; wallindex < 4; wallindex++) {
				boolean d = false;//direction
				double p = 0;//proximity
				switch(wallindex) {
					case 0: d = (code & Rectangle2D.Double.OUT_BOTTOM) != 0;//reverse, because in 2D 0,0 is top-left
						p=field.getMaxY() - y;
					break;
					case 1: d = (code & Rectangle2D.Double.OUT_RIGHT) != 0;
						p=field.getMaxX() - x;
					break;
					case 2: d = (code & Rectangle2D.Double.OUT_TOP) != 0;//reverse, because in 2D 0,0 is top-left
						p=y-field.getMinY();
					break;
					case 3: d = (code & Rectangle2D.Double.OUT_LEFT) != 0;
						p=x-field.getMinX();
					break;
				}
				if(d && p < 2*bot.getWidth()) {//I am close and moving towards it
					a.setPolar(wallindex*Math.PI/2,1);
					b.setVector(a);
					a.setBearing(a.getBearing()+Math.PI/2);
					b.setBearing(b.getBearing()-Math.PI/2);
					a.add(turn,1);
					b.add(turn,1);
					BearingVector temp = turn;
					if(a.getDistance() > b.getDistance()) {
						turn.setBearing(wallindex*Math.PI/2+Math.PI/2+Math.PI/30);//this is a hard limit
					} else {
						turn.setBearing(wallindex*Math.PI/2-Math.PI/2-Math.PI/30);//this is a hard limit
					}
				}
			}
		}
		
		if(newMove) bot.setAhead(movement * (Math.random()+0.1));
		turnAngle = BearingVector.normalizeAngle(turn.getBearing() - myHeading);
		bot.setTurnRightRadians(turnAngle);
		double mv = (Math.PI - Math.abs(turnAngle))/Math.PI;
		bot.setMaxVelocity(9*mv);
		newMove = false;
	}
	
}
