package patson;
import robocode.*;
import java.util.*;
import java.awt.Color;

/**
 * PatsonTestBot - a robot by (your name here)
 */
public class PatsonTestBot extends AdvancedRobot
{
	private static final int INITIAL_RADAR_MOVEMENT = 720;
	private static final int MAX_BULLET_POWER = 3;
	private static final int GUN_TURN_RATE = 20;

	
	private int _radarMovement= INITIAL_RADAR_MOVEMENT;
	//private double _myBulletPower = 1;
	private boolean _radarMoveRight = true;
	private Bullet _lastHitBullet = null; //to keep track of last victim
	private double _lastEnergy = 100;
	private double _lastOnHitEnergy = 0;
	private double _lastGettingHitEnergy= 100;

	//private EnemyRobot _lastScannedRobot = null;
	private Map _enemies = new HashMap();
	//private TreeSet _toHitRatingList = new TreeSet(new ToHitRatingComparator());
	//private TreeSet _threatRatingList = new TreeSet(new ThreatRatingComparator());
	private Map _activeBulletTargets = new HashMap();
	
	
	public PatsonTestBot() {
	}
	/**
	 * run: PatsonTestBot's default behavior
	 */
	public void run() {
		setColors(new Color(0, 1, 0) ,new Color(0, 10, 0) , new Color(100, 200, 0)) ;
	//			out.println("duration is : " + getDuration(0, 0, 10, -1, 2, 150, 1));
				
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			if (_radarMoveRight) {
				turnRadarRight(_radarMovement);
				_radarMoveRight = false;
			} else {
				turnRadarLeft(_radarMovement);
				_radarMoveRight = true;
			}
			//gradually increase the radar movement //revise later!!
			if (_radarMovement <= INITIAL_RADAR_MOVEMENT - 10) {
				_radarMovement += 40;
			}
					//start moving randomly if energy declining
			if (/*_lastEnergy - 0> getEnergy() && */getDistanceRemaining() == 0 && getTurnRemaining() == 0) {
				//moveInArc(Math.random() * Math.PI - Math.PI/2, Math.random() * 200 - 100);   //randomly draw right/left arc of at most quarter circle with max radius 100)	
				double randomNum = Math.random();
				/*if (randomNum < 0.25) {
					moveInArc(Math.PI / 8, 100, true);
				} else if (randomNum < 0.5) {
					moveInArc(Math.PI / 8, 100, false);
				} else if (randomNum < 0.75) {
					moveInArc((-1) * Math.PI / 8, 100, true);
				} else {*/
				if (getTurnRemaining() == 0 && getDistanceRemaining() == 0) {
					moveInArc((-1) * Math.PI / 8, 100, false);
				}
				//}
				//out.println("Random!");
				_lastEnergy = getEnergy();
				//set radar to point at the easiest target
				if (!turnRadarAtEasyTarget()) {
					_radarMovement= 360;
				}
			}
		
		}
		
		
		
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 * FIRE!
	 * reduce scan angle
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		Coordinate targetCoord = new Coordinate(getX() + Math.sin(e.getBearingRadians() + getHeadingRadians()) * e.getDistance()
		                             , getY() + Math.cos(e.getBearingRadians() + getHeadingRadians()) * e.getDistance());
		if (getRadarTurnRemaining() == 0) {
			turnRadarAtTarget(targetCoord.getX(), targetCoord.getY());
		}
		//update enemies database
		updateEnemies(e);
			
			//decide gun power
			EnemyRobot targetRobot = (EnemyRobot)_enemies.get(e.getName());
			double firePower;
			double targetToHitRating= (targetRobot != null) ? targetRobot.getToHitRating() : 0;
			if (targetRobot == null) {
				firePower = 2 ;
			} else if (targetToHitRating < -40) {
				firePower = 0.5; //get conservative...cause we kept missing...increase radar range..avoid this unfavorable target
			} else if (targetToHitRating < -20) {
				firePower = 1; //get conservative...cause we kept missing
			} else if (targetToHitRating < 0) { //get conservative...cause we kept missing
				firePower = 2;
			} else {
				firePower = (targetToHitRating + 1) * 2;
				firePower = (firePower < MAX_BULLET_POWER) ? firePower : MAX_BULLET_POWER;	
			}
		
			_radarMovement = (_radarMovement >= 180)  ? 45 : _radarMovement/ 4;
		
		
			
			//adjust targetX and targetY base on the pattern attached
			Coordinate predictedTarget;
			if (targetRobot.getMovementPattern() != null) {
				predictedTarget = targetRobot.getMovementPattern().predictTarget(new Coordinate(getX(), getY()), targetCoord, getBulletSpeed(firePower), e.getHeadingRadians(), targetRobot.getPreviousMovements());
//				out.println("bullet speed: " + Rules.getBulletSpeed(firePower));
			} else {
				predictedTarget = targetCoord;
			}
			//out.println("prediction - target will move x unit and y unit : " + travelTime * e.getVelocity() * Math.sin(e.getHeadingRadians()) + " , " + travelTime * e.getVelocity() * Math.cos(e.getHeadingRadians()));
			
			turnGunAtTarget(predictedTarget.getX(), predictedTarget.getY());
		if (getGunHeat() == 0) {
		
			fire(firePower, e.getName());
			if (getTurnRemaining() == 0 && getDistanceRemaining() == 0) {
				moveInArc(Math.PI / 8, 100, false); //!!!!
			}
			
			//fire(_myBulletPower, e.getName());
		}
		//turn radar to easy target
		turnRadarAtEasyTarget();
		//_lastScannedRobot = new EnemyRobot(e);
		
		//adjust tank bearing based on distance? 
		
		
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		double bulletPower = e.getPower();
		if (_lastGettingHitEnergy > getEnergy()) { //only move away if losing energy
			
			double turnAmountRadians = (e.getBearingRadians() >= 0 ) ? e.getBearingRadians() - Math.PI / 2 : e.getBearingRadians() + Math.PI / 2;
			//bigger radius if arcAmount is small...ie Pheta * radius = CONSTANT
			double arcRadius = (turnAmountRadians == 0) ? 100 : 100 / Math.abs(turnAmountRadians);
			
			if (Math.abs(e.getBearing()) <= 90) { //facing the bullet, move backward to get away
 				moveInArc(turnAmountRadians, arcRadius, false);
			} else { //back facing the bullet, move forward to get away
	//			turnRight(90 + e.getBearing());
				moveInArc(turnAmountRadians, arcRadius, true);
			}
			_radarMovement= 720; //reset radar aftermoving
			_lastGettingHitEnergy = getEnergy();
		}
		//ahead(bulletPower * 100); //radio
		
		//turn radar to that direction only if there's no current easy target or the easy target is not the one that fired the bullet
		EnemyRobot easyTarget = getEasyTarget();
		if (easyTarget == null || easyTarget.getName().equals(e.getName())) {
			if (e.getHeading() < 180) {
				turnRadarLeft(getRadarHeading()- (e.getHeading() + 180));
			} else {
				turnRadarLeft(getRadarHeading()- (e.getHeading() - 180));	
			}
			out.println("TURNING radar to " + e.getName() + " cause its the easy target/no easy target exists"); 
		}
	
		//update threat
		EnemyRobot attacker = (EnemyRobot)_enemies.get(e.getName());
		if (attacker != null) {
			attacker.changeThreatRating(e.getPower());
		}
	
	}
	public void onBulletMissed(BulletMissedEvent e) {
		if (_radarMovement <= 90 ) {
			_radarMovement *= 2;
		}
		
		//unable to hit that target
		EnemyRobot missedTarget = (EnemyRobot)_enemies.get(_activeBulletTargets.get(e.getBullet()));
		if (missedTarget != null) {
			missedTarget.changeToHitRating((-1) * e.getBullet().getPower());
		} else {
			out.println("ERROR! unable to retrieve missedTarget Info");
		}
		out.println("CONSTANT " + e.getBullet().getVelocity() + "power: "+ e.getBullet().getPower());
		
		//remove the bullet from the list
		if (_activeBulletTargets.remove(e.getBullet()) == null) {
			out.println("ERROR! unable to remove bullet");	
		} else {
			//out.println("an active bullet removed!");	
		}		
		
	}
	/*goal:
	 *move towards the robot
	 *increase fire power
	 *decrease radar scanning angle
	 * lock down a specific target?
	*/
	public void onBulletHit(BulletHitEvent e) {
		//move towards the bot if its far away
		Bullet hitBullet = e.getBullet();
		double enemyDistance = getDistanceFromRobot(hitBullet.getX(), hitBullet.getY());
		
		EnemyRobot victim = (EnemyRobot)_enemies.get(hitBullet.getVictim());
		
		//adjust tank bearing based on distance? 
		//if (enemyDistance >= 200 && _lastOnHitEnergy < getEnergy()) { //!!!! CHANGE
		/*
		if (enemyDistance >= 200) {
			if (victim!= null && victim.getThreatRating() < victim.getToHitRating() + hitBullet.getPower()) { //only move at it if its an easy target!!!?
				turnRobotAtTarget(hitBullet.getX(), hitBullet.getY());
				ahead(20);
			}
		}*/
		_lastOnHitEnergy = getEnergy();
		//adjust gun to point at the target
		//turnGunAtTarget(hitBullet.getX(), hitBullet.getY());
		//fire(5);
		//increase fire power
	
		//change radar movement rates: 
				
		//update the toHit level ...notice that it might hit even tho radar did not scan it
		if (victim != null) {
			victim.changeToHitRating(hitBullet.getPower() * 5);
		}
		//remove the bullet from the list
		if (_activeBulletTargets.remove(hitBullet)== null) {
			out.println("ERROR! unable to remove bullet");	
		} else {
			//out.println("an active bullet removed!");	
		}
	}		

	public void onRobotDeath(RobotDeathEvent e) {
		EnemyRobot deadRobot = (EnemyRobot)_enemies.get(e.getName());
		if (deadRobot != null) {
			_enemies.remove(e.getName());
		} else {
			out.println("try to remove "+ e.getName() + " but not in database");
		}
	}
	public void onHitWall(HitWallEvent e) {
		if (e.getBearing() > 0) {
			turnLeft(90);	
		} else {
			turnRight(90);
		}	
		ahead(100);
	}

	private double getDistanceFromRobot(double x, double y) {
	//	out.println("target X, Y : (" + x + "," + y + ")  My X, Y : (" + getX() + "," + getY() + ")");
		return getDistance(getX(), getY(), x, y); //Math.sqrt((x - getX())*(x - getX()) + (y - getY())*(y - getY()));
	}

	private static double getDistance(double x1, double y1, double x2, double y2) {
		return Math.sqrt(sqr(x2 - x1) + sqr(y2 - y1));
	}
	private static double getDistance(Coordinate coord1, Coordinate coord2) {
		return getDistance(coord1.getX(), coord1.getY(), coord2.getX(), coord2.getY());
	}

	
	//get the angle between the target from robot and the robot's heading, so turnRight(getBearingFromRobot(x,y)) would turn
	//the robot to the target with coordinate (x, y) return value between -180 to 180
	private double getBearingFromRobot(double x, double y) {
		double bearingFromRobot =  getAngleFromRobot(x, y) - getHeading();
		return getFinalizedAngle(bearingFromRobot);
	}

	private double getBearingFromGun(double x, double y) {
		double bearingFromGun =  getAngleFromRobot(x, y) - getGunHeading();
		return getFinalizedAngle(bearingFromGun);
	}

	private double getBearingFromRadar(double x, double y) {
		double bearingFromRadar =  getAngleFromRobot(x, y) - getRadarHeading();
		return getFinalizedAngle(bearingFromRadar);
	}

	private void turnGunAtTarget(double x, double y) {
		turnGunRight(getBearingFromGun(x , y));
	}

	private void turnRadarAtTarget(double x, double y) {
		turnRadarRight(getBearingFromRadar(x , y));
	}
	//get the complement angle
	//for angles that are smaller than -180 or greater than 180
	private double getFinalizedAngle(double angle) {
		angle = angle % 360;
		if (angle > 180) {
			angle -= 360;
		} else if (angle < -180) {
			angle += 360;
		} 
		return angle;
	}

	private void turnRobotAtTarget(double x, double y) {
		turnRight(getBearingFromRobot(x, y));
	}
	private double getAngleFromRobot(double x, double y) {
		double pheta = Math.atan( (y - getY()) / (x - getX()) ) / Math.PI * 180;
		//turn into angle of the target from robot from 0 (due north) to (clockwise) 360 degree
		double angleFromRobot;
		if (x > getX()) { //target in 1st coordinate or 4th
			angleFromRobot = 90 - pheta;	
		} else  { //target in 2nd coordinate or 3rd
			angleFromRobot = 270 - pheta;
		} 
		return angleFromRobot;	
	}
	//turnAmount : the amount of turn in radians clockwise as positive, anti-closewise as negative (for both foward and backward, if arclength is 1 and radus is -1, it would move
	//radius : radius of the arc
	//moveFoward : true as foward, false as backward
	private void moveInArc (double turnAmountRadians, double radius, boolean moveForward) {
		setTurnRight(turnAmountRadians * 180 / Math.PI);
		// Start moving (and turning)
		if (moveForward) {
			ahead(Math.abs(turnAmountRadians) * radius);	
		} else {
			ahead((-1)* Math.abs(turnAmountRadians) * radius);	
		} 
	}

	


	//*DUN BUMP INTO WALLS! :P
	public void ahead(double distance) {
		double targetX = getX() + distance * Math.sin(getHeadingRadians());
		double targetY = getY() + distance * Math.cos(getHeadingRadians());
		double adjustedDistanceOnX = distance;
		double adjustedDistanceOnY = distance;
		if (targetX < 0) {
			adjustedDistanceOnX = (-1) * getX() / Math.sin(getHeadingRadians());
		} else if (targetX > getBattleFieldWidth()) {
			adjustedDistanceOnX = (getBattleFieldWidth() - getX()) / Math.sin(getHeadingRadians());
		}
	
		if (targetY < 0) {
			adjustedDistanceOnY = (-1) * getY() / Math.cos(getHeadingRadians());
		} else if (targetY > getBattleFieldHeight()) {
			adjustedDistanceOnY = (getBattleFieldHeight() - getY()) / Math.cos(getHeadingRadians());
		}
	
		if (adjustedDistanceOnX != distance || adjustedDistanceOnY != distance) {
			double finalAdjustedDistance = Math.abs(adjustedDistanceOnX) < Math.abs(adjustedDistanceOnY) ? adjustedDistanceOnX : adjustedDistanceOnY;
			/*
			out.println("ahead adjust from " + distance + " to " + finalAdjustedDistance);
			out.println("originaly moving to "+ (getX() + distance * Math.sin(getHeadingRadians())) + " , " + (getY() + distance * Math.cos(getHeadingRadians())));
			out.println("now moving to " + (getX() + finalAdjustedDistance * Math.sin(getHeadingRadians())) + " , " + (getY() + finalAdjustedDistance * Math.cos(getHeadingRadians())));
			*/
			super.setAhead(finalAdjustedDistance);
		} else {
			super.setAhead(distance); //move normally
		}
	}

	public void fire(double power, String targetName) {
		_activeBulletTargets.put(fireBullet(power), targetName);	
	}

	private void updateEnemies(ScannedRobotEvent e) {
		//out.println("update enemies");
		if (!_enemies.containsKey(e.getName())) {
			_enemies.put(e.getName(), new EnemyRobot(e));	
		} else {
			((EnemyRobot)_enemies.get(e.getName())).update(e);
		}	
	}
	private void printFavorRatingList(Set sortedSet) {
		out.println("===== TO FAVOR RATING LIST STARTS=========");
		Iterator iter = sortedSet.iterator();
		try {
			while (iter.hasNext()) {
				out.println(iter.next());
			}
			out.println("===== TO FAVOR RATING LIST ENDS=========");
		} catch (ConcurrentModificationException e) {
			out.println("===== LIST(SET) CHANGED...PRINTINT ENDED=======");
		}	
		out.println();
	}

	private EnemyRobot getEasyTarget()  {
		//resort the set	
		TreeSet favorRatingList = new TreeSet(new FavorRatingComparator());
		favorRatingList.addAll(_enemies.values());
		
	
//		printFavorRatingList(favorRatingList);
		return (EnemyRobot)favorRatingList.last();
	}
 	/**
		Return true if such an easy target exists, false if not
	*/
	private boolean turnRadarAtEasyTarget() {
		if (_enemies.size() > 0) {
			EnemyRobot easyTarget = getEasyTarget();
			turnRadarAtTarget(easyTarget.getX(), easyTarget.getY());
			return true;
		} else {
			return false;
		}
		
	}

	/* for 1.0.7 compliance*/
	private double getBulletSpeed(double firePower) {
		return 20 - firePower * 3;	
	}

	


	

	private static double sqr(double input) {
		return input * input;	
	}
	

	

	private class EnemyRobot {
		private double _x;
		private double _y;	
		private double _heading;
		private double _velocity;
		private String _name;
		private long _lastUpdatedTime;
		private double _toHitRating;
		private double _threatRating;
		private MovementPattern _currentPattern; 
		private List _previousMovements;
		private EnemyRobot(ScannedRobotEvent e) {
			_x = PatsonTestBot.this.getX() + Math.sin(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance();
		    _y = PatsonTestBot.this.getY() + Math.cos(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance();
			_heading = e.getHeading();
			_velocity = e.getVelocity();
			_name = e.getName();
			_lastUpdatedTime = getTime();
			_toHitRating = 0;
			_threatRating = 0;
			_currentPattern = new UnknownPattern();
			_previousMovements = new ArrayList();
			_previousMovements.add(new MovementVector(PatsonTestBot.this.getX() + Math.sin(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance()
													, PatsonTestBot.this.getY() + Math.cos(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance()
													, e.getVelocity()
													, e.getHeadingRadians()));
		}
		private void update(ScannedRobotEvent e) {
			//analyze pattern before updating other fields
			_currentPattern = analyzeMovementPattern(e);
			//out.println(_name + " pattern is : " + _currentPattern.getPatternType());
			_x = PatsonTestBot.this.getX() + Math.sin(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance();
		    _y = PatsonTestBot.this.getY() + Math.cos(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance();
			_heading = e.getHeading();
			_velocity = e.getVelocity();
			_previousMovements.add(new MovementVector(PatsonTestBot.this.getX() + Math.sin(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance()
													, PatsonTestBot.this.getY() + Math.cos(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance()
													, e.getVelocity()
													, e.getHeadingRadians()));
			_lastUpdatedTime = PatsonTestBot.this.getTime() ;
			
		}
		private double getX() {
			return _x;	
		}
		private double getY() {
			return _y;	
		}
		private double getHeading() {
			return _heading;
		}	
		private double getVelocity() {
			return _velocity;	
		}
		private String getName() {
			return _name;	
		}
		private double getToHitRating() {
			return _toHitRating;	
		}
		private double getThreatRating() {
			return _threatRating;	
		}
		private long getLastUpdatedTime() {
			return _lastUpdatedTime;
		}
		private List getPreviousMovements() {
			return _previousMovements;
		}
		private MovementPattern getMovementPattern() {
			return _currentPattern;	
		}
		private void changeToHitRating(double changeValue) {
			_toHitRating += changeValue;
		}
		private void changeThreatRating(double changeValue) {
			_threatRating += changeValue;
		}
		public String toString() {
			return "Favor: " + new FavorRatingComparator().getFavorRating(this) + " ; ToHit : " + _toHitRating + " ; Threat : " + _threatRating + " ; Name : " + _name + " ; Distance : " + getDistanceFromRobot(getX() , getY()); 			
		}
		private MovementPattern analyzeMovementPattern(ScannedRobotEvent e) {
			double targetX = PatsonTestBot.this.getX() + Math.sin(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance();
		    double targetY = PatsonTestBot.this.getY() + Math.cos(e.getBearingRadians() + PatsonTestBot.this.getHeadingRadians()) * e.getDistance();
			
			if (getTime() - _lastUpdatedTime > 20) { //only detect if its straight movement since last collected data is 5 turns ago (not accurate)
				if (_heading == e.getHeading()) { //assume it runs in a straight line then
					return new StraightPattern(e.getVelocity());
				} else {
					return _currentPattern; 
				}
			} else {
				if (isZigZagPattern(e)) {
					//out.println("is ZIG ZAG!!");
					return new ZigZagPattern(targetX, targetY, e.getVelocity(), e.getHeadingRadians(), _previousMovements);
				 }
				if (_heading == e.getHeading()) { //assume it runs in a straight line then
					return new StraightPattern(e.getVelocity());
				} else { //assume its arc movement
					double turnAmount;
					if (e.getHeading() - _heading < -180) { //moving clockwise and passed the north line
						turnAmount = (e.getHeading() + 360 - _heading)  * Math.PI / 180;
					} else if (e.getHeading() - _heading > 180) { //moving antiClockwise and passed the north line
						turnAmount = (e.getHeading() - 360 - _heading)  * Math.PI / 180;
					} else {
						turnAmount = (e.getHeading() - _heading) * Math.PI / 180;
					}
					double radius;
					if (e.getVelocity() >= 0) {
						radius = Math.sqrt(sqr(targetX - _x) + sqr(targetY - _y)) / (2 * Math.sin(turnAmount / 2));	
					} else {
						radius = Math.sqrt(sqr(targetX - _x) + sqr(targetY - _y)) / (-2 * Math.sin(turnAmount / 2));	
					}
					//out.println("turn amount :" + turnAmount);
					//out.println("radius :" + radius);
					return new ArcPattern(e.getVelocity(), radius);
				}
			}
		}
	
		private boolean isZigZagPattern(ScannedRobotEvent e) {
			//check last 5 scans
			if (e.getVelocity() == 0) {
				return false;	
			}
			int num_of_scans_to_check = 5;
			if (_previousMovements.size() < num_of_scans_to_check) {
				num_of_scans_to_check = _previousMovements.size();
			}

			if (e.getVelocity() > 0) {
				for (int i = 1; i <= num_of_scans_to_check; i++) {
					if (((MovementVector)_previousMovements.get(_previousMovements.size() - i)).getVelocity() < 0) {
						return true;
					}	
				} 	
			} else {
				for (int i = 1; i <= num_of_scans_to_check; i++) {
					if (((MovementVector)_previousMovements.get(_previousMovements.size() - i)).getVelocity() > 0) {
						return true;
					}
				}	
			} 	
			return false;
		}
	
		
			
	}

	private class Coordinate {
		private double _x;
		private double _y;
		private Coordinate(double x , double y) {
			_x = x;
			_y = y;	
		}
		private double getX() {
			return _x;
		}
		private double getY() {
			return _y;
		}
	}
	private class MovementVector {
		double _velocity;
		double _headingRadians;
		double _x;
		double _y;
		private MovementVector(double x, double y, double velocity, double headingRadians) {
			_x = x;
			_y = y;	
			_velocity = velocity;
			_headingRadians= headingRadians;
			
		}
		double getVelocity() {
			return _velocity;
		}
		double getHeadingRadians() {
			return _headingRadians;
		}
		double getX() {
			return _x;	
		}
		double getY() {
			return _y;
		}
	
	}

	private class ToHitRatingComparator implements Comparator {
		public int compare(Object o1, Object o2) {
			//sure both o1 and o2 are EnemyRobots
			EnemyRobot robot1 = (EnemyRobot)o1;
			EnemyRobot robot2 = (EnemyRobot)o2;
			if (robot1.getToHitRating()	- robot2.getToHitRating() < 0) {
				return -1;
			} else if (robot1.getToHitRating()	- robot2.getToHitRating() > 0){
				return 1;
			} else {
				//the one that was updated more recently is bigger
				if (robot1.getLastUpdatedTime() < robot2.getLastUpdatedTime()) {
					return -1; 
				} else if (robot1.getLastUpdatedTime() < robot2.getLastUpdatedTime()) {
					return 1;
				} else {
					return 0;
				}
			}
		}
		public boolean equals(Object o1, Object o2) {
			return compare(o1, o2) == 0;	
		}
	}
	
	private class ThreatRatingComparator implements Comparator {
		public int compare(Object o1, Object o2) {
			//sure both o1 and o2 are EnemyRobots
			EnemyRobot robot1 = (EnemyRobot)o1;
			EnemyRobot robot2 = (EnemyRobot)o2;
			if (robot1.getThreatRating() - robot2.getThreatRating() < 0) {
				return -1;
			} else if (robot1.getThreatRating()	- robot2.getThreatRating() > 0){
				return 1;
			} else {
				//the one that was updated more recently is bigger
				if (robot1.getLastUpdatedTime() < robot2.getLastUpdatedTime()) {
					return -1; 
				} else if (robot1.getLastUpdatedTime() < robot2.getLastUpdatedTime()) {
					return 1;
				} else {
					return 0;
				}
			}
		}
		public boolean equals(Object o1, Object o2) {
			return compare(o1, o2) == 0;	
		}
	}
	//if its favorable to attack that target robot : favorable = high toHIT, and low threat ...since moving to high threat targets is suicidal
	private class FavorRatingComparator implements Comparator {
		
		public int compare(Object o1, Object o2) {
			//sure both o1 and o2 are EnemyRobots
			EnemyRobot robot1 = (EnemyRobot)o1;
			EnemyRobot robot2 = (EnemyRobot)o2;
			if (getFavorRating(robot1) < getFavorRating(robot2)) {
				return -1;
			} else if (getFavorRating(robot1) > getFavorRating(robot2)) {
				return 1;
			} else {
				//the one that was updated more recently is bigger
				if (robot1.getLastUpdatedTime() < robot2.getLastUpdatedTime()) {
					return -1; 
				} else if (robot1.getLastUpdatedTime() < robot2.getLastUpdatedTime()) {
					return 1;
				} else {
					return 0;
				}
			}
		}
		//private final double NORMALIZING_CONSTANT = Math.sqrt(getBattleFieldHeight() * getBattleFieldHeight() + getBattleFieldWidth() * getBattleFieldWidth())/4;
		private final static double NORMALIZING_CONSTANT = 1000;
		
		
		private double getFavorRating(EnemyRobot targetRobot) {
			return (targetRobot.getToHitRating()  - targetRobot.getThreatRating() * 2) / getDistanceFromRobot(targetRobot.getX() , targetRobot.getY()) * NORMALIZING_CONSTANT ;
		}
		public boolean equals(Object o1, Object o2) {
			return compare(o1, o2) == 0;	
		}
	}

	private abstract class MovementPattern {
		static final String STRAIGHT = "straight";
		static final String ARC = "arc";
		static final String ZIG_ZAG = "zig_zag";
		static final String UNKNOWN = "unknown";
		
		abstract String getPatternType();  
		abstract Coordinate predictTarget(Coordinate myCoord, Coordinate targetOriginalCoord, double bulletSpeed, double targetHeadingRadians, List previousMovements);
	}

	private class ArcPattern extends MovementPattern {
		private double _arcVelocity; //velocity as instantenously speed on the arc
		private double _radius;	 //if radius > 0 , center on RHS ; otherwise on LHS
		private ArcPattern (double arcVelocity, double radius) {
			_arcVelocity = arcVelocity;
			_radius = radius;
		}
		String getPatternType() {
			return ARC;
		}	
		double getArcVelocity() {
			return _arcVelocity;	
		}
		double getRadius() {
			return _radius;
		}
	
		private double getArcDuration(double myX, double myY, double targetX, double targetY, double bulletSpeed, double targetHeadingRadians) {
			return getArcDuration(myX, myY, targetX, targetY, bulletSpeed, targetHeadingRadians, getDistance(myX, myY, targetX, targetY) / bulletSpeed);
		}
		private double getArcDuration(double myX, double myY, double originalTargetX, double originalTargetY, double bulletSpeed, double targetHeadingRadians, double previousDuration) {
			double targetArcMovementRadians = _arcVelocity * previousDuration / _radius;
			double pheta = (Math.PI - targetArcMovementRadians) / 2 - targetHeadingRadians;
			double predictedTargetX = originalTargetX + 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.cos(pheta); 
			double predictedTargetY = originalTargetY + 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.sin(pheta);
			double distance = getDistance(myX, myY, predictedTargetX, predictedTargetY);
			double durationApproximation = distance/bulletSpeed;
			//use this approximation to calculate how far the bullet goes in next recursive Call
			/*
			out.println("previous duration" + previousDuration);
			out.println("new duration" + durationApproximation);
			out.println("angle movement: " + targetArcMovementRadians * 180 / Math.PI);
			out.println("x adjustment: "+ 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.cos(pheta) + " , y adjustment: "+ 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.sin(pheta));
			out.println("targetArcVelocity: " + _arcVelocity);
			out.println("targetHeading: "+ targetHeadingRadians * 180 / Math.PI);
			out.println("targetRadius : " + _radius);
			out.println("PREDICTED X, Y: " + predictedTargetX + " , " + predictedTargetY);
			*/
			if (Math.abs(durationApproximation - previousDuration) <= 0.1) {
				return durationApproximation;
			} else {
				return getArcDuration(myX, myY, originalTargetX, originalTargetY, bulletSpeed, targetHeadingRadians, durationApproximation);
			}
		
		}
		Coordinate predictTarget(Coordinate myCoord, Coordinate targetOriginalCoord, double bulletSpeed, double targetHeadingRadians, List previousMovements) {
			double targetX = targetOriginalCoord.getX();
			double targetY = targetOriginalCoord.getY();
			if (_arcVelocity == 0 || _radius == 0) {
				return new Coordinate(targetX, targetY);
			}		
			double duration = getArcDuration(myCoord.getX(), myCoord.getY(), targetX, targetY, bulletSpeed, targetHeadingRadians);			
			double targetArcMovementRadians = _arcVelocity * duration / _radius;
			
			double pheta = (Math.PI - targetArcMovementRadians) / 2 - targetHeadingRadians;
			targetX += 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.cos(pheta); 
			targetY += 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.sin(pheta);
			/*
			out.println("====finialized=====");
			out.println("arcMovement: " + targetArcMovementRadians * 180 / Math.PI);
			out.println("predicted target X , Y : " + targetX + " , " + targetY);
			out.println("my X , Y: + " + getX()+ " , " + getY());
			out.println("bullet speed: "+ bulletSpeed);
			*/
			//check if its out of bound
			if (targetX < 0) {
				targetX = 0;	
			} else if (targetX > getBattleFieldWidth()) {
				targetX = getBattleFieldWidth();
			}
			if (targetY < 0) {
				targetY = 0;	
			} else if (targetY > getBattleFieldHeight()) {
				targetY = getBattleFieldHeight();
			}
		
			//minor ajustment because when u turn cannon head, it would take time too...its a recursive relation but we ignore it cause taking the first movement 
			//is accurate enough
			double gunTurnDuration = Math.abs(getBearingFromGun(targetX, targetY)) / GUN_TURN_RATE; //assume gun turn in max rate
			targetArcMovementRadians = _arcVelocity * gunTurnDuration / _radius;
			targetX += 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.cos(pheta); 
			targetY += 2 * _radius * Math.sin(targetArcMovementRadians / 2) * Math.sin(pheta);
			
				
			//cannon movement adjustment?
			return new Coordinate(targetX, targetY);
		}

	}

	private class StraightPattern extends MovementPattern {
		private double _linearVelocity; 
		private StraightPattern (double linearVelocity) {
			_linearVelocity = linearVelocity;
		}
		String getPatternType() {
			return STRAIGHT;
		}
		double getLinearVelocity() {
			return _linearVelocity;	
		}
	
			//predict the final position of the target by giving time frame, target heading (in radians) and target speed
		Coordinate predictTarget(Coordinate myCoord, Coordinate originalCoord, double bulletSpeed, double targetHeadingRadians, List previousMovements) {
			double duration = getStraightDuration(myCoord.getX(), myCoord.getY(), originalCoord.getX(), originalCoord.getY(), bulletSpeed, targetHeadingRadians);
			double targetX = originalCoord.getX() + duration * _linearVelocity * Math.sin(targetHeadingRadians); 
			double targetY = originalCoord.getY() + duration * _linearVelocity * Math.cos(targetHeadingRadians);
			//out.println("prediction - target will move x unit and y unit : " + duration * targetVelocity * Math.sin(targetHeadingRadians) + " , " + duration * targetVelocity * Math.cos(targetHeadingRadians) + "in duration " + duration + " speed : " + targetVelocity);
			//check if its out of bound
			if (targetX < 0) {
				targetX = 0;	
			} else if (targetX > getBattleFieldWidth()) {
				targetX = getBattleFieldWidth();
			}
			if (targetY < 0) {
				targetY = 0;	
			} else if (targetY > getBattleFieldHeight()) {
				targetY = getBattleFieldHeight();
			}
			
			
			
			//minor ajustment because when u turn cannon head, it would take time too...its a recursive relation but we ignore it cause taking the first movement 
			//is accurate enough
			double gunTurnDuration = Math.abs(getBearingFromGun(targetX, targetY)) / GUN_TURN_RATE; //assume gun turn in max rate
			//out.println("gun turn duration: "+ gunTurnDuration);
			targetX += gunTurnDuration * _linearVelocity * Math.sin(targetHeadingRadians); 
			targetY += gunTurnDuration * _linearVelocity * Math.cos(targetHeadingRadians);
		
		
			
		
		
			return new Coordinate(targetX, targetY);
		}	 
		//* solve the moving target problem...makes better prediction by accurately calculate the time requires to hit the target
		private double getStraightDuration(double myX, double myY, double targetX, double targetY, double bulletSpeed, double targetHeadingRadians) {
			double x = targetX - myX;
			double y = targetY - myY;
			double pheta = targetHeadingRadians; //heading in Radians
			double intermediate = sqr(_linearVelocity) * sqr(y * Math.cos(pheta) + x * Math.sin(pheta)) - (sqr(_linearVelocity) - sqr(bulletSpeed)) * ( x * x + y * y);
			double duration1 = ((-1) * _linearVelocity * (y * Math.cos(pheta) + x * Math.sin(pheta)) + Math.sqrt(intermediate)) / (sqr(_linearVelocity) - sqr(bulletSpeed));
			double duration2 = ((-1) * _linearVelocity * (y * Math.cos(pheta) + x * Math.sin(pheta)) - Math.sqrt(intermediate)) / (sqr(_linearVelocity) - sqr(bulletSpeed));
			/*
			out.println("linear speed " + _linearVelocity);
			out.println("bullet speed " + bulletSpeed);
			out.println("x , y (relative) : " + x + " , " + y);
			
			
			out.println("d1 : " + duration1);
			out.println("d2 : " + duration2);
			*/
			return (duration1 > duration2) ? duration1 : duration2;
		}
	}

	private class ZigZagPattern extends MovementPattern {
		private double _xAmphitude; 
		private double _xPhase;
		private double _yAmphitude;
		private double _yPhase;
		private double _hardness; //the hardness of the movement, if _hardness = 0 , it is oscillation, if _hardness = 1, its back
		private double _period; //unit: turn
		//and forth in constant speed
		private ZigZagPattern(double currentX, double currentY, double currentVelocity, double currentHeadingRadians, List previousMovements) {
			_xAmphitude = 0;
			_yAmphitude = 0;
			double currentXSpeed = Math.abs(currentVelocity * Math.sin(currentHeadingRadians));
			double currentYSpeed = Math.abs(currentVelocity * Math.cos(currentHeadingRadians));
			double maxXSpeed = currentXSpeed;
			double maxYSpeed = currentYSpeed;
			int num_of_calculations = 3;
			if (previousMovements.size() < num_of_calculations) {
				num_of_calculations = previousMovements.size();
			}

			for (int i = 1; i <= num_of_calculations; i++) {
				MovementVector movement = (MovementVector)previousMovements.get(previousMovements.size() - i);
				double xDistance = Math.abs(movement.getX() - currentX);
				double yDistance = Math.abs(movement.getY() - currentY);
				double xSpeed = Math.abs(movement.getVelocity() * Math.sin(movement.getHeadingRadians()));
				double ySpeed = Math.abs(movement.getVelocity() * Math.cos(movement.getHeadingRadians()));
				
				
				_xAmphitude = xDistance / 2 > _xAmphitude ?  xDistance / 2 : _xAmphitude;
				_yAmphitude = yDistance / 2 > _yAmphitude ?  yDistance / 2 : _yAmphitude;
				maxXSpeed = xSpeed > maxXSpeed ? xSpeed : maxXSpeed;
				maxYSpeed = ySpeed > maxYSpeed ? ySpeed : maxYSpeed;
			}  
			_xPhase = Math.acos(currentXSpeed / maxXSpeed);
			_yPhase = Math.acos(currentYSpeed / maxYSpeed);
			_hardness= 0;
			//use the bigger amphitude one to calculate period for accuracy
			if (_xAmphitude > _yAmphitude) {
				_period = 2 * Math.PI * _xAmphitude / maxXSpeed;
			} else {
				_period = 2 * Math.PI * _yAmphitude / maxYSpeed;
			}
			//4 is minimum
			if (_period < 4) {
				_period = 4;	
			}
		/*
			out.println("X amp, Y amp, x phase, y phase : " + _xAmphitude + " , " + _yAmphitude + " , " + _xPhase + " , " + _yPhase); 
			out.println("period: " + _period);
			*/
		}
	
		String getPatternType() {
			return ZIG_ZAG;	
		}	
	
		Coordinate predictTarget(Coordinate myCoord, Coordinate targetOriginalCoord, double bulletSpeed, double targetHeadingRadians, List previousMovements) {
			double duration = getDistance(myCoord, targetOriginalCoord) / bulletSpeed;
			double targetX = targetOriginalCoord.getX() + _xAmphitude * Math.sin(_xPhase + 2* Math.PI * duration / _period);
			double targetY = targetOriginalCoord.getY() + _yAmphitude * Math.sin(_yPhase + 2* Math.PI * duration / _period);
			if (targetX < 0) {
				targetX = 0;	
			} else if (targetX > getBattleFieldWidth()) {
				targetX = getBattleFieldWidth();
			}
			if (targetY < 0) {
				targetY = 0;	
			} else if (targetY > getBattleFieldHeight()) {
				targetY = getBattleFieldHeight();
			}
			//check if its out of bound
			if (targetX < 0) {
				targetX = 0;	
			} else if (targetX > getBattleFieldWidth()) {
				targetX = getBattleFieldWidth();
			}
			if (targetY < 0) {
				targetY = 0;	
			} else if (targetY > getBattleFieldHeight()) {
				targetY = getBattleFieldHeight();
			}
			//minor ajustment because when u turn cannon head, it would take time too...its a recursive relation but we ignore it cause taking the first movement 
			return new Coordinate(targetX , targetY);
		}	
	}

	private class UnknownPattern extends MovementPattern {
		String getPatternType() {
			return UNKNOWN;
		}	
		Coordinate predictTarget(Coordinate myCoord, Coordinate targetOriginalCoord, double bulletSpeed, double targetHeadingRadians, List previousMovements) {
			return targetOriginalCoord;
		}	
	
	}

}																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																																											