package myl.micro;
import robocode.*;
import java.awt.Color;
import java.awt.geom.Point2D;

/**
 * Predator - a minibot by Martin Y Lepsoy (DrLoco)
 * email: mlepsoy@yahoo.no
 *
 * 12.01.2003 - Version 1.50 - codesize 748
 * 
 * New in Predator 1.50
 * - Predator is a microbot!! I hope not for long, because I have plans for it in melee as a winning minibot:-)
 * - New Predator based on the successful NekoNinja 1.30 (my microbot) which was 4th of all bots and first of minibots and microbots in Eternal Rumble at best
 * - Changes from NekoNinja 1.30:
 *   - New and a lot better pattern analyzer which actually hits
 *   - Changed the way the movement analyzer pick our next destination. I don't know if it's to the better yet...
 * I released this version of Predator as a microbot because I haven't got time to finish it before the challenge. Well, now I just have to see how well it does;)
 *
 *
 * 11.12.2002 - Version 1.4 - codesize 1494
 * 
 * New in Predator 1.4
 * - Great improvement in melee
 *		due to a lot of fixes, but mainly two things
 *		- Avoiding enemies by not turning straight towards them
 *		- Increased area of movement to as close to the walls as you can get except in the corners
 * - Spent quite a bit time making it a microbot after all the fixes												//* hehe, microbot... I'd wish:-P
 * (if anyone know how to squeeze codesize more withouth hurting the bot, and preferably not make the code messy,
 * I would gladly want to hear from you. I really want to build more on this bot;) )
 *
 *
 * 10.12.2002 - Version 1.3 - codesize 1413
 *
 * New in Predator 1.3
 * - Rethought movement, more fluid
 * - Fixed a bug in movement
 * - Minor tweaks
 *
 *
 * 10.12.2002 - Version 1.2 - codesize 1435
 *
 * New in Predator 1.2:
 * - Melee code, not very good but it is ok
 * - Sort of corner move in melee
 * - Commented source
 * - Pattern matcher is not used in melee
 * - Better pattern matcher
 *
 *
 * 08.12.2002 - Version 1.0 - codesize 1318
 *
 * First release of Predator
 * - Random movement, no dodging
 * - Will stay close to the walls
 * - Gun with pattern matcher
 * - No melee capabilities yet, will hopefully be included in next release
 * - last, but not least: a victory 'grin' ;-)
 */

public class Predator extends AdvancedRobot
			{
	static double		nextMove;								//the time before our next move
	
	final static int	storedInfo = 1000;						//how many frames we store in our pattern analyzer.
																//not too large to get fresh details on target quickly,
																//but large enough to remember the opponents behavior a little while
	//static int			frameRightNow;
	
	static double[]		startX = new double[storedInfo];
	static double[]		startY = new double[storedInfo];
	static double[]		linearPredictionAngle = new double[storedInfo];
	static double[]		bearing = new double[storedInfo];
	static double[]		actualMove = new double[storedInfo];
	static double[]		bulletProgress = new double[storedInfo];
	
	public void run() {
		//setAdjustRadarForGunTurn(true);	//thanks to David Alves who showed that we didn't need radar adjusted for gun turn
		//setAdjustGunForRobotTurn(true);	//I left this out, because I couldn't find anything else to reduce codesize. I don't think the gun is that accurate that it matters anyway:-P
		
		//eracing incomplete frames in our analyzer
		int frameToErace = 0;
		do {
			bulletProgress[frameToErace] = 0;
			frameToErace++;
		} while( frameToErace < storedInfo );
		setColors( Color.red , Color.red , new Color( 162 , 244 , 89 ) );
		
		while( true ) {
			turnRadarRightRadians( 1 );	//turn radar to find a target
		}
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		//frameRightNow = ( frameRightNow + 1 ) % storedInfo;
		int frameRightNow = (int)getTime() % storedInfo;
		double targetBearing;
		double targetDistance;
		double ourX;	//store own coordinates
		double ourY;	//-"-
		double testX;
		double testY;
		double bestX;
		double bestY;
		double enemyX = ( ourX = bestX = getX() ) + ( targetDistance = e.getDistance() ) * Math.sin( targetBearing = getHeadingRadians() + e.getBearingRadians() );
		double enemyY = ( ourY = bestY = getY() ) + targetDistance * Math.cos( targetBearing );
		double firePower = Math.min( 3 , getEnergy() / 10 );	//powersaving when low on energy
		double aimWidth;
		double testAngle = linearPredictionAngle[frameRightNow] = e.getVelocity() * Math.sin( e.getHeadingRadians() - targetBearing ) / 11;
		int numberOfAngles;
		int match;
		double[] matchingAngle = new double[2 * ( match = numberOfAngles = (int)( Math.PI / ( aimWidth = 2 * Math.atan( 20 / targetDistance ) ) ) )];
		int frameInAnalyzer = 0;
		startX[frameRightNow] = ourX;
		startY[frameRightNow] = ourY;
		bearing[frameRightNow] = targetBearing;
		actualMove[frameRightNow] = 0;
		bulletProgress[frameRightNow] = 20;
		//analyzer code
		do {
			if ( bulletProgress[frameInAnalyzer] > 0 ) {
				if ( ( bulletProgress[frameInAnalyzer] += 11 ) >= Point2D.Double.distance( testX = startX[frameInAnalyzer] , testY = startY[frameInAnalyzer] , enemyX , enemyY ) ) {	//testX and testY are now used as start position of virual bullet
					actualMove[frameInAnalyzer] = relative( bearing[frameInAnalyzer] - Math.atan2( enemyX - testX , enemyY - testY ) );
					bulletProgress[frameInAnalyzer] = 0;
				}
			} else {
				matchingAngle[(int)( numberOfAngles + actualMove[frameInAnalyzer] / aimWidth )] += Math.PI - Math.abs( testAngle - linearPredictionAngle[frameInAnalyzer] );
			}
			frameInAnalyzer++;
		} while( frameInAnalyzer < storedInfo );
		frameInAnalyzer = 0;
		do {
			if ( matchingAngle[frameInAnalyzer] > matchingAngle[match] ) {
				match = frameInAnalyzer;
			}
			frameInAnalyzer++;
		} while( frameInAnalyzer < numberOfAngles * 2 );
		
		setTurnGunRightRadians( relative( targetBearing - getGunHeadingRadians() + ( match - numberOfAngles ) * aimWidth * 11 / ( 20 - 3 * firePower ) ) );	//turn gun to target with an offset as predicted in our analyzer
		//end of pattern analyzer
		//movement analyzer
		aimWidth = testAngle = 0;	//testAngle is now used as a counter for test positions
		if ( nextMove-- <= 0 ) {	//it's time to make our next move
			do {
				if ( Math.min( testX = Math.random() * getBattleFieldWidth(), getBattleFieldWidth() - testX ) * Math.min( testY = Math.random() * getBattleFieldHeight() , getBattleFieldHeight() - testY ) > 8000 ) {	//make sure the point is within the current wall tolerance (which is always 8000 in this bot which is good for a 800 x 600 battlefield)
					//use point if angle to point is a certain amount from angle to target
					if ( ( enemyX = Math.abs( relative( targetBearing - Math.atan2( testX - ourX , testY - ourY ) ) ) ) > aimWidth ) {	//aimWidth means best angle here
						//decide which direction to go to reach our point as soon as possible
						aimWidth = enemyX;
						bestX = testX;
						bestY = testY;
					}
				}
				testAngle++;
			} while( testAngle < 30 );
			//thanks to David Alves and Dummy for this small code to find which direction is shortest to our next destination
			setAhead(
			 ( ( enemyX = relative( Math.atan2( bestX - ourX , bestY - ourY ) - getHeadingRadians() ) ) ==	//enemyX is now used as angle to turn (-2pi<angle<2pi)
			 ( enemyY = Math.atan( Math.tan( enemyX ) ) ) ? 1 : - 1 )	//enemyY is now used as angle to turn (-pi<angle<pi)
			 * Point2D.Double.distance( ourX , ourY , bestX , bestY ) );	//move towards point
			setTurnRightRadians( enemyY );	//make turn
			nextMove = targetDistance / 20;	//use own firePower here to save space. The enemy is likely to use about the same power as us since firepower often is based on own energy
			//make nextMove a little before a bullet will reach you next time
		}
		
		//setMaxVelocity( getTurnRemaining() > 45 ? 0.001 : 8 );	//adjust velocity when turning to make sharper turns
		//end of movement analyzer
		//radar and fire
		setTurnRadarRightRadians( Math.sin( targetBearing - getRadarHeadingRadians() ) * 3 );	//turn radar to target enemy	//thanks to David Alves for this code
		if ( getEnergy() - firePower > Math.min( e.getEnergy() , 3 ) ) {	//make sure we won't kill ourself when shooting, also let the enemy run out of energy before you
			setFire( firePower );	//fire
		}
		//end of radar and fire
		execute();	//scan to see if our target is still here
	}
	
	//helper
	
	public double relative( double ang ) {	//get the angle relative to your heading where -pi<angle<pi
		return ( ang + ( 7 * Math.PI ) ) % ( 2 * Math.PI ) - Math.PI;
	}
	
//	public double getAngle( double x1 , double y1 , double x2 , double y2 ) {	//get the angle between two points where -pi<angle<pi
//		return Math.atan2( x2 - x1 , y2 - y1 );
//	}
}