package ags.rougedc.robots;

import ags.rougedc.base.*;

import robocode.Event;
import robocode.ScannedRobotEvent;
import robocode.BulletHitEvent;
import robocode.BulletHitBulletEvent;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;

/**
 * Stores a list of the enemies
 * 
 * @author Alexander Schultz
 */
public class EnemyList {
    private final Rules rules;
    private final StatusRobot status;
    
    // Store how much the enemy might know about out aim
    private static final Map<String, Integer> enemyinfo = new HashMap<String, Integer>();
    
    private final Map<String, EnemyRobot> enemies;
    private EnemyRobot target;
    
    public EnemyList(Rules rules, StatusRobot status) {
        enemies = new HashMap<String, EnemyRobot>();
        this.rules = rules;
        this.status = status;
    }
    
    private void enemyGotInfo(String name) {
        Integer number = enemyinfo.get(name);
        if (number == null)
            enemyinfo.put(name, 1);
        else
            enemyinfo.put(name, number+1);
    }
    
    public void handleEvents(Iterable<Event> i) {
        // Create new enemy robot representations when necessary
        for (Event e : i) {
            if (e instanceof ScannedRobotEvent) {
                String name = ((ScannedRobotEvent)e).getName();
                if (!enemies.containsKey(name) && !rules.isTeammate(name))
                    enemies.put(name, new EnemyRobot(rules, status, name, enemyinfo));
            }
            
            if (e instanceof BulletHitEvent) {
                enemyGotInfo(((BulletHitEvent)e).getName());
            }
            
            if (e instanceof BulletHitBulletEvent) {
                enemyGotInfo(((BulletHitBulletEvent)e).getHitBullet().getName());
            }
        }
        
        // Forward events
        for (EnemyRobot enemy : enemies.values()) {
            enemy.handleEvents(i);
        }
        
        // Select the target enemy
        target = null;
        for (EnemyRobot enemy : enemies.values()) {
            if (enemy.isAlive() && enemy.isScanned()) {
                if (target == null)
                    target = enemy; 
                else if (target.getRelativeLocation().getMagnitude() > enemy.getRelativeLocation().getMagnitude())
                    target = enemy;
            }
        }
    }
    
    public EnemyRobot getTarget() {
        return target;
    }
    
    public Collection<EnemyRobot> getAll() {
        return enemies.values();
    }
}
