package tm;

import java.util.*;

/********************************************************************
* Radar1on1Sweep.java -- for 1 on 1
*                        ^[Qbg
*
* Date:		2002/Dec/05
* Author:	Matunaga Takateru@RISE, Eng, Kagawa Univ.
*
********************************************************************/
public class Radar1on1Sweep implements Radar {
	MyRobot my;
	FieldMap map;
	int radarDirection = 1;
	
	public Radar1on1Sweep(MyRobot my) {
		this.my = my;
		this.map = my.map;
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void radarTurnComplete() {
		double angle;				//[_[]px
		double absoluteBearing;		//Gʒu̐Ίpx
		double bearing, distance;
		
		Enemy ene = map.getNearestEnemy(my.getTime());
		

		if (ene == null) {
			my.setTurnRadarRight(360);
			return;
		}
		

		
		bearing = ene.getBearing();
		distance = ene.getDistance();

		absoluteBearing = bearing + my.getHeading();		
				
		//[_[]
		angle = absoluteBearing - my.getRadarHeading();
		angle = M.angleUnder180(angle);
		angle += M.sign(angle) * 20;

		if (my.getTime() - ene.getMtime() > 3) {
			angle = 45;
		}		
				
		my.setTurnRadarRight(angle);
	}
}