package sch;

import robocode.*;
import java.util.*;

/**
 * Performs all tasks relative to the handling of the strategy
 */
 
public class StrategyManager implements Constants {
	
	private SortedMap strategyList;
	private AdvancedRobot myBot;
	private EnemyManager enemyManager;
	private Strategy currentStrategy;
	
	/**
	 * Create an instance of the Strategy Manager
	 * @param	myBot			the reference to the main bot
	 * @param	enemyManager	the reference to the Enemy Manager
	 */
	public StrategyManager (AdvancedRobot myBot, EnemyManager enemyManager) {
		this.myBot=myBot;
		strategyList=new TreeMap();
		this.enemyManager=enemyManager;
		if (BotUtil.varContains(DEBUG,DEBUG_OBJECT_CREATION)) System.out.println("Stategy Manager initialized");
	}
	
	/**
	 * Return the instance of the main bot
	 * @return		the reference to the bot
	 */
	public AdvancedRobot getMyBot() {return myBot;}

	/**
	 * Return the instance of the enemy manager
	 * @return		the reference to the enemy manager
	 */	
	public EnemyManager getEnemyManager() {return enemyManager;}
	
	/**
	 * Compute the better strategy for the current condition
	 */
	public void computeCurrentStrategy() {
		double maxGoodness=-1.0;
		Strategy prevStrategy=currentStrategy;
		for (Iterator i=strategyList.values().iterator();i.hasNext();) {
			Strategy currentStrat=(Strategy) i.next();
			if 	(currentStrat.getGoodness()>maxGoodness){
				currentStrategy=currentStrat;
				maxGoodness=currentStrat.getGoodness();
			}
		}
		if (BotUtil.varContains(DEBUG,DEBUG_STRATEGY_SELECTION)) {
			if (prevStrategy!=currentStrategy)
				System.out.println("New Strategy Selected: "+ currentStrategy.getName());
		}
	}

	/**
	 * Return the current strategy
	 * @return		the instance of the current strategy
	 */
	public Strategy getCurrentStrategy() {return currentStrategy;}


	/**
	 * Add a new Strategy to the list of available strategies
	 * @param	newStrategy		the new strategy
	 */	
	public void addStrategy(Strategy newStrategy) {
		newStrategy.setStrategyManager(this);
		strategyList.put(newStrategy.getName(),newStrategy);
	}
	
	/**
	 * Initialise itself and all strategy.<br>
	 * Generally used at the beginning of the match.
	 */
	public void initialize (){
		for (Iterator i=strategyList.values().iterator();i.hasNext();) {
			Strategy currentStrat=(Strategy) i.next();
			currentStrat.initialize();
		}
		currentStrategy=null;
		computeCurrentStrategy();
	}

	/**
	 * Reinitialise itself and all strategy
	 * Generally used at the beginning of each round except the first one.
	 */
	public void reinitialize (){
		for (Iterator i=strategyList.values().iterator();i.hasNext();) {
			Strategy currentStrat=(Strategy) i.next();
			currentStrat.reinitialize();
		}
		currentStrategy=null;
		computeCurrentStrategy();		
	}
	

}
