package kawigi.spare.parts;
import java.util.Vector;
import kawigi.spare.util.*;
import robocode.*;
/**
 * ProbablisticGun - Keeps stats on best firing angles to pick future firing angles
 * 			I believe this is similar to SandBoxDT's approach to aiming.
 */
public class ProbablisticGun extends Gun implements java.io.Serializable
{
	private Vector bullets;
	private EnemyManager enemies;
	
	public ProbablisticGun(AdvancedRobot robot, EnemyManager enemies)
	{
		super(robot);
		bullets = new Vector();
		this.enemies = enemies;
	}
	
	public void onEvent(Event e)
	{
	}
	
	public ChooserBullet getVirtualBullet(EnemyState target)
	{
		if (target == null || target.isDead())
			return null;
		long time = robot.getTime();
		for (int i=0; i<bullets.size(); i++)
		{
			OffensiveVirtualBullet b = (OffensiveVirtualBullet)bullets.elementAt(i);
			EnemyState enemy = enemies.getEnemy(b.getName());
			if (enemy == null)
			{
				bullets.removeElementAt(i);
				i--;
				continue;
			}
			b.updateEnemy(enemy.getX(), enemy.getY(), time);
			int index = (int)(enemy.getDistance(robot.getX(), robot.getY())/100);
			if (b.alreadyHit())
			{
				double d = b.getGunTurn();
				if (enemy.nextChangeInRelativeAngle(robot.getX(), robot.getY()) < 0)
					d = -d;
				enemy.addStat(d, index);
				bullets.removeElementAt(i);
				i--;
				continue;
			}
		}
		double sign = (target.nextChangeInRelativeAngle(robot.getX(), robot.getY()) < 0)? -1 : 1;
		bullets.addElement(new OffensiveVirtualBullet(target.getName(), target.getAbsoluteBearing(robot.getX(), robot.getY()), robot.getX(), robot.getY(), time));
		return new ChooserBullet(target.getName(), robot.getX(), robot.getY(), target.getAbsoluteBearing(robot.getX(), robot.getY())+sign*target.getStatsBest(target.getDistance(robot.getX(), robot.getY())), 3, this, time);
	}
}
