/*
 * Decompiled with CFR 0.152.
 */
package deith;

public class MoveStats {
    private double[] myAll;
    private double[] myHit;
    private double[] myProc;
    private int maxTact;
    private int last;
    static long lastChange;
    static int tact;

    public MoveStats(int m) {
        this.maxTact = m;
        this.myAll = new double[m];
        this.myHit = new double[m];
        this.myProc = new double[m];
        for (int i = 0; i < this.myHit.length; ++i) {
            this.myHit[i] = 0.0;
            this.myProc[i] = 0.0;
            this.myAll[i] = 60.0;
        }
    }

    public int getTactic(long turn) {
        if (Math.abs(turn - lastChange) > 120L) {
            double max = Double.MIN_VALUE;
            int index = 0;
            for (int i = 0; i < this.myHit.length; ++i) {
                this.myProc[i] = (this.myAll[i] - this.myHit[i]) / this.myAll[i];
                if (!(this.myProc[i] > max)) continue;
                max = this.myProc[i];
                index = i;
            }
            if (Math.abs(this.myProc[0] - this.myProc[1]) < 0.05 || max < 0.6) {
                index = (this.last + 1) % this.maxTact;
            }
            if (tact != index) {
                lastChange = turn;
            }
            tact = index;
            return index;
        }
        return tact;
    }

    public void nextRound() {
        for (int i = 0; i < this.myHit.length; ++i) {
            if (!(this.myAll[i] > 80.0)) continue;
            this.myAll[i] = this.myAll[i] / 2.0;
            this.myHit[i] = this.myHit[i] / 2.0;
        }
    }

    public void hitBullet(int moveTactic) {
        int n = moveTactic;
        this.myHit[n] = this.myHit[n] + 1.0;
        if (this.myHit[moveTactic] >= this.myAll[moveTactic] + 1.0) {
            this.myAll[moveTactic] = this.myHit[moveTactic] * 2.0;
        }
    }

    public void missBullet(int moveTactic) {
        int n = moveTactic;
        this.myAll[n] = this.myAll[n] + 1.0;
        if (this.myHit[moveTactic] >= this.myAll[moveTactic] + 1.0) {
            this.myAll[moveTactic] = this.myHit[moveTactic] * 2.0;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.myHit.length; ++i) {
            sb.append("Taktyka " + i + "    hits: " + this.myHit[i] + "    avoid: " + this.myAll[i]);
            sb.append("    skutecznosc%  " + Math.round((this.myAll[i] - this.myHit[i]) / this.myAll[i] * 100.0) + "\n");
        }
        return sb.toString();
    }
}

