/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import justin.BulletM;
import justin.Mallais;
import justin.Scan;
import justin.Tank;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class Movement3
extends Mallais {
    AdvancedRobot robot;
    static final double WALL_MARGIN = 30.0;
    static RoundRectangle2D bf;
    static Ellipse2D.Double centerSpace;
    static Ellipse2D.Double InnerCenterSpace;
    static Point2D.Double bfCenter;
    static double bw;
    static double bh;
    static Point2D.Double nextLocation;
    static Point2D.Double lastLocation;
    int push = 0;

    public Movement3(AdvancedRobot robot) {
        this.robot = robot;
    }

    public void init() {
        nextLocation = lastLocation = Movement3.myData.location;
        bw = this.robot.getBattleFieldWidth();
        bh = this.robot.getBattleFieldHeight();
        bfCenter = new Point2D.Double(bw / 2.0, bh / 2.0);
        centerSpace = new Ellipse2D.Double(Movement3.bfCenter.x - Movement3.bfCenter.x * 0.9, Movement3.bfCenter.y - Movement3.bfCenter.y * 0.9, bw * 0.9, bh * 0.9);
        InnerCenterSpace = new Ellipse2D.Double(Movement3.bfCenter.x - Movement3.bfCenter.x * 0.3, Movement3.bfCenter.y - Movement3.bfCenter.y * 0.3, bw * 0.3, bh * 0.3);
        bf = new RoundRectangle2D.Double(30.0, 30.0, bw - 60.0, bh - 60.0, 130.0, 130.0);
    }

    public void move() {
        if (this.robot.getEnergy() < 0.2 && Movement3.targetScan.energy < this.robot.getEnergy()) {
            this.driveTo(Movement3.targetScan.location);
            return;
        }
        double testHeading = 0.0;
        double leastRisk = Double.POSITIVE_INFINITY;
        int otherBots = this.robot.getOthers();
        do {
            double risk;
            double testDistance;
            Point2D.Double testLocation;
            if (!bf.contains(testLocation = Movement3.project(Movement3.myData.location, testHeading, testDistance = (double)((testHeading += 0.52) < Math.PI * 2 ? 65 : (testHeading > Math.PI * 4 ? 130 : 195)))) || !((risk = this.evaluate(testLocation, testHeading, otherBots)) < leastRisk)) continue;
            this.robot.setMaxVelocity((double)(testHeading < Math.PI * 2 ? 5 : (testHeading > Math.PI * 4 ? 7 : 8)));
            leastRisk = risk;
            nextLocation = testLocation;
        } while (testHeading < Math.PI * 6);
        this.driveTo(nextLocation);
    }

    public double evaluate(Point2D.Double testLoc, double testHeading, int otherBots) {
        double eval = 0.0;
        int i = 1;
        while (i < tank.size()) {
            Tank t = (Tank)((Object)tank.get(i));
            if (t.alive) {
                Scan s = t.scanList.get(t.scanList.size() - 1);
                double grav = Math.pow(testLoc.distance(s.location), 2.0);
                double grav2 = Math.pow(testLoc.distance(s.location), 1.6);
                double health = Math.min(s.energy / Movement3.myData.energy, 2.0);
                double angle = Math.abs(Math.cos(Movement3.absoluteBearing(Movement3.myData.location, testLoc) - Movement3.absoluteBearing(s.location, testLoc))) * 3.0;
                double targetPerimeter = testLoc.distance(s.location) < s.smallestDistance ? 3 : 1;
                double fartherSafer = health;
                double dangerousSpace = InnerCenterSpace.contains(testLoc) ? 2 : 1;
                double saferSpace = centerSpace.contains(testLoc) ? 1 : 2;
                eval += health * 35.0 / grav;
                eval += targetPerimeter / grav;
                eval += health * angle / grav;
                eval += (double)((11 - Math.min(otherBots, 10)) * 3) / grav2;
                if (otherBots == 3) {
                    eval += 400.0 / grav2;
                }
                if (otherBots == 2) {
                    eval += 650.0 / grav2;
                }
                if (otherBots == 1) {
                    eval += (s.energy - Movement3.myData.energy) / 1.0 / grav;
                    eval *= saferSpace;
                } else {
                    eval *= dangerousSpace;
                }
            }
            ++i;
        }
        int x = 0;
        while (x < bulletList.size()) {
            BulletM b = (BulletM)((Object)bulletList.get(x));
            if (testLoc.distance(b.bulletLocation) < 120.0) {
                eval += 1.0 / testLoc.distanceSq(b.bulletLocation);
            }
            ++x;
        }
        if (otherBots < 3) {
            x = 1;
            while (x < Movement3.myTank.scanList.size()) {
                double angle;
                Point2D.Double loc;
                Scan data = Movement3.myTank.scanList.get(x);
                if (data.waveSpeed != 0.0 && testLoc.distance(loc = Movement3.project(data.fireLocation, angle = Utils.normalRelativeAngle((double)(Movement3.absoluteBearing(data.fireLocation, data.location) + Tank.mostVisitedBearingOffset(data, this.robot))), data.distanceTraveled)) < 150.0) {
                    eval += 60.0 / ((double)otherBots + 0.1) / testLoc.distanceSq(loc);
                }
                ++x;
            }
        }
        return eval;
    }

    public void driveTo(Point2D.Double location) {
        Point2D.Double myLoc = new Point2D.Double(this.robot.getX(), this.robot.getY());
        double turn = Utils.normalRelativeAngle((double)(Movement3.absoluteBearing(myLoc, location) - this.robot.getHeadingRadians()));
        double distance = myLoc.distance(location);
        int myDirection = 1;
        if (turn < -1.5707963267948966) {
            turn += Math.PI;
            myDirection = -1;
        }
        if (turn > 1.5707963267948966) {
            turn -= Math.PI;
            myDirection = -1;
        }
        this.robot.setTurnRightRadians(turn);
        this.robot.setAhead((double)myDirection * distance);
    }

    public static Rectangle2D makeField(double width, double height, double margin) {
        return new Rectangle2D.Double(margin, margin, width - margin * 2.0, height - margin * 2.0);
    }

    public static Point2D.Double project(Point2D.Double source, double angle, double distance) {
        return new Point2D.Double(source.getX() + Math.sin(angle) * distance, source.getY() + Math.cos(angle) * distance);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double sqr(double a) {
        return a * a;
    }
}

