/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;

public final class MyUtils {
    public static Rectangle2D makeField(double width, double height, double margin) {
        return new Rectangle2D.Double(margin, margin, width - margin * 2.0, height - margin * 2.0);
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double sinD(double ang) {
        return Math.sin(Math.toRadians(ang));
    }

    public static double cosD(double ang) {
        return Math.cos(Math.toRadians(ang));
    }

    public static double tanD(double ang) {
        return Math.tan(Math.toRadians(ang));
    }

    public static double angleTo(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y2 - y1, x2 - x1));
    }

    public static double angleToRadians(double x1, double y1, double x2, double y2) {
        return 1.5707963267948966 - Math.atan2(y2 - y1, x2 - x1);
    }

    public static double angleTo(AdvancedRobot bot, double x, double y) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX()));
    }

    public static double angleToRadians(AdvancedRobot bot, double x, double y) {
        return 1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX());
    }

    public static double distanceTo(double x1, double y1, double x2, double y2) {
        return Math.sqrt(MyUtils.sqr(x2 - x1) + MyUtils.sqr(y2 - y1));
    }

    public static double distanceTo(AdvancedRobot bot, double x2, double y2) {
        return Math.sqrt(MyUtils.sqr(x2 - bot.getX()) + MyUtils.sqr(y2 - bot.getY()));
    }

    public static double normalizeBearing(double ang) {
        if ((ang %= 360.0) > 180.0) {
            ang -= 360.0;
        }
        if (ang < -180.0) {
            ang += 360.0;
        }
        return ang;
    }

    public static double normalizeBearingRadians(double ang) {
        if ((ang = ang % Math.PI * 2.0) > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static void setTurnToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnRight(MyUtils.normalizeBearing(ang - bot.getHeading()));
    }

    public static void setTurnToAngleRadians(AdvancedRobot bot, double ang) {
        bot.setTurnLeftRadians(MyUtils.normalizeBearingRadians(bot.getHeadingRadians() - ang));
    }

    public static double setTurnToAngle90(AdvancedRobot bot, double ang) {
        double ang1 = MyUtils.normalizeBearing(bot.getHeading() - ang);
        if (ang1 > 90.0) {
            ang1 -= 180.0;
        }
        if (ang1 < -90.0) {
            ang1 += 180.0;
        }
        bot.setTurnLeft(ang1);
        return bot.getHeading() < 90.0 || bot.getHeading() > 270.0 ? 1 : -1;
    }

    public static void setTurnGunToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnGunLeft(MyUtils.normalizeBearing(bot.getGunHeading() - ang));
    }

    public static void setTurnRadarToAngle(AdvancedRobot bot, double ang) {
        bot.setTurnRadarLeft(MyUtils.normalizeBearing(bot.getRadarHeading() - ang));
    }

    public static void setGoto(AdvancedRobot bot, double x, double y) {
        double dist = Math.sqrt(MyUtils.sqr(bot.getX() - x) + MyUtils.sqr(bot.getY() - y));
        double ang = MyUtils.normalizeBearing(MyUtils.angleTo(bot, x, y) - bot.getHeading());
        if (Math.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        if (Math.abs(ang) > 20.0) {
            bot.setMaxVelocity(3.0);
        } else {
            bot.setMaxVelocity(8.0);
        }
        bot.setTurnRight(ang);
        bot.setAhead(dist);
    }

    public static double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = MyUtils.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public static double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public static double linearInterpolate(double y1, double y2, double mu) {
        return y1 * (1.0 - mu) + y2 * mu;
    }

    public static boolean isNear(double value1, double value2) {
        return Math.abs(value1 - value2) < 1.0E-5;
    }

    public static boolean isNear(double value1, double value2, double precision) {
        return Math.abs(value1 - value2) < precision;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public double bulletVelocity(double _firePower) {
        return 20.0 - 3.0 * _firePower;
    }

    public static double maxEscapeAngle(double bVelocity) {
        return Math.asin(7.4 / bVelocity);
    }
}

