/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import java.util.ArrayList;
import java.util.List;
import tcf.Seg;

class DataSegmenter {
    private int m_totalDim = 1;
    private List<Integer> m_dims = new ArrayList<Integer>();
    private List<Seg> m_segs = new ArrayList<Seg>();

    DataSegmenter(Object ... objectArray) {
        assert (objectArray.length % 2 == 0);
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof Integer) || !(objectArray[i + 1] instanceof Seg)) continue;
            Integer n = (Integer)objectArray[i];
            Seg seg = (Seg)objectArray[i + 1];
            this.addSeg(n, seg);
        }
    }

    public void addSeg(int n, Seg seg) {
        this.m_segs.add(seg);
        this.m_dims.add(n);
        this.m_totalDim *= seg.nBins();
    }

    public int size() {
        return this.m_totalDim;
    }

    public int seg(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.m_segs.size(); ++i) {
            n *= this.m_segs.get(i).nBins();
            n += this.m_segs.get(i).seg(dArray[this.m_dims.get(i)]);
        }
        assert (0 <= n && n < this.m_totalDim);
        return n;
    }
}

