/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import robocode.Rules;
import robocode.util.Utils;

public class PredictFireablePositions {
    Point2D.Double firePos_;
    double bulletSpeed_;
    double minLimit_;
    double maxXLimit_;
    double maxYLimit_;
    double angle_;
    double angleRight_;
    double angleLeft_;
    double angleBegin_;
    double angleArc_;
    double distance_;
    long turnBulletOnFly_;
    int numPowers_;
    List<Point2D.Double> posiblePositions_;
    List<Integer> positionsTurns_;

    public PredictFireablePositions(double minLimit, double maxXLimit, double maxYLimit) {
        this.minLimit_ = minLimit;
        this.maxXLimit_ = maxXLimit;
        this.maxYLimit_ = maxYLimit;
        this.posiblePositions_ = new ArrayList<Point2D.Double>();
        this.positionsTurns_ = new ArrayList<Integer>();
    }

    public void CalculatePosiblePositions(Point2D.Double posMovil, double vel, double heading, double bulletPower, Point2D.Double firePos, Point2D.Double avoidPos, long turnBulletOnFly, boolean composeList, boolean appendList) {
        if (composeList && !appendList) {
            this.posiblePositions_.clear();
            this.positionsTurns_.clear();
        }
        Point2D.Double workPos = new Point2D.Double();
        int turn = 0;
        this.firePos_ = firePos;
        this.bulletSpeed_ = Rules.getBulletSpeed((double)bulletPower);
        this.angle_ = Math.atan2(posMovil.getX() - avoidPos.getX(), posMovil.getY() - avoidPos.getY());
        this.angleRight_ = 0.0;
        this.angleLeft_ = 0.0;
        this.distance_ = 0.0;
        this.turnBulletOnFly_ = turnBulletOnFly;
        double rel = Utils.normalRelativeAngle((double)(heading - this.angle_));
        if (rel >= 0.0) {
            double var;
            double angleDesired;
            double variation;
            workPos.setLocation(posMovil);
            double workVel = vel;
            double workHeading = heading;
            boolean reach = false;
            turn = 0;
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) - 1.5707963267948966));
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel < -1.0 ? (workVel += 2.0) : (workVel += 1.0);
                if (workVel > 8.0) {
                    workVel = 8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, 1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
            workPos.setLocation(posMovil);
            workVel = vel;
            workHeading = heading;
            reach = false;
            turn = 0;
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) - 1.5707963267948966));
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel > 1.0 ? (workVel -= 2.0) : (workVel -= 1.0);
                if (workVel < -8.0) {
                    workVel = -8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, 1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
        } else {
            double var;
            double angleDesired;
            double variation;
            workPos.setLocation(posMovil);
            double workVel = vel;
            double workHeading = heading;
            boolean reach = false;
            turn = 0;
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) + 1.5707963267948966));
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel < -1.0 ? (workVel += 2.0) : (workVel += 1.0);
                if (workVel > 8.0) {
                    workVel = 8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, -1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
            workPos.setLocation(posMovil);
            workVel = vel;
            workHeading = heading;
            reach = false;
            turn = 0;
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) + 1.5707963267948966));
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel > 1.0 ? (workVel -= 2.0) : (workVel -= 1.0);
                if (workVel < -8.0) {
                    workVel = -8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, -1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
        }
        this.angleBegin_ = Utils.normalAbsoluteAngle((double)(this.angle_ + this.angleLeft_));
        this.angleArc_ = Utils.normalAbsoluteAngle((double)(this.angleRight_ - this.angleLeft_));
    }

    public void CalculatePosiblePositionsMantainDistance(Point2D.Double posMovil, double vel, double heading, double bulletPower, Point2D.Double firePos, Point2D.Double avoidPos, double distanceToKeep, long turnBulletOnFly, boolean composeList, boolean appendList) {
        if (composeList && !appendList) {
            this.posiblePositions_.clear();
            this.positionsTurns_.clear();
        }
        Point2D.Double workPos = new Point2D.Double();
        int turn = 0;
        this.firePos_ = firePos;
        this.bulletSpeed_ = Rules.getBulletSpeed((double)bulletPower);
        this.angle_ = Math.atan2(posMovil.getX() - avoidPos.getX(), posMovil.getY() - avoidPos.getY());
        this.angleRight_ = 0.0;
        this.angleLeft_ = 0.0;
        this.distance_ = 0.0;
        this.turnBulletOnFly_ = turnBulletOnFly;
        double rel = Utils.normalRelativeAngle((double)(heading - this.angle_));
        double distance = avoidPos.distance(posMovil);
        double anglevar = 0.0;
        anglevar = 3.0 * distanceToKeep / 4.0 > distance ? 0.7853981633974483 : (distanceToKeep > distance ? 0.7853981633974483 * ((distanceToKeep - distance) / (3.0 * distanceToKeep / 4.0)) : (2.0 * distanceToKeep < distance ? -0.7853981633974483 : -(0.7853981633974483 * ((distance - distanceToKeep) / distanceToKeep))));
        if (rel >= 0.0) {
            double var;
            double variation;
            workPos.setLocation(posMovil);
            double workVel = vel;
            double workHeading = heading;
            boolean reach = false;
            turn = 0;
            double angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) - 1.5707963267948966 - anglevar));
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel < -1.0 ? (workVel += 2.0) : (workVel += 1.0);
                if (workVel > 8.0) {
                    workVel = 8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, 1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
            workPos.setLocation(posMovil);
            workVel = vel;
            workHeading = heading;
            reach = false;
            turn = 0;
            angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) - 1.5707963267948966 + anglevar));
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel > 1.0 ? (workVel -= 2.0) : (workVel -= 1.0);
                if (workVel < -8.0) {
                    workVel = -8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, 1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
        } else {
            double var;
            double variation;
            workPos.setLocation(posMovil);
            double workVel = vel;
            double workHeading = heading;
            boolean reach = false;
            turn = 0;
            double angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) + 1.5707963267948966 + anglevar));
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel < -1.0 ? (workVel += 2.0) : (workVel += 1.0);
                if (workVel > 8.0) {
                    workVel = 8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, -1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
            workPos.setLocation(posMovil);
            workVel = vel;
            workHeading = heading;
            reach = false;
            turn = 0;
            angleDesired = Utils.normalAbsoluteAngle((double)(Math.atan2(avoidPos.getX() - workPos.getX(), avoidPos.getY() - workPos.getY()) + 1.5707963267948966 - anglevar));
            while (!this.CheckFinal(workPos, turn, composeList)) {
                ++turn;
                if (!reach) {
                    variation = Rules.getTurnRateRadians((double)workVel);
                    var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
                    if (Math.abs(var) <= variation) {
                        workHeading = angleDesired;
                        reach = true;
                    } else {
                        workHeading = var > 0.0 ? (workHeading += variation) : (workHeading -= variation);
                    }
                }
                workVel = workVel > 1.0 ? (workVel -= 2.0) : (workVel -= 1.0);
                if (workVel < -8.0) {
                    workVel = -8.0;
                }
                workHeading = this.CheckBorder(workPos, workHeading, -1.0);
                workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
            }
        }
        this.angleBegin_ = Utils.normalAbsoluteAngle((double)(this.angle_ + this.angleLeft_));
        this.angleArc_ = Utils.normalAbsoluteAngle((double)(this.angleRight_ - this.angleLeft_));
    }

    public double CheckBorder(Point2D.Double posMovil, double heading, double direction) {
        if (posMovil.getX() < this.minLimit_) {
            posMovil.setLocation(this.minLimit_ + 1.0, posMovil.getY());
            heading = direction > 0.0 ? 0.0 : Math.PI;
        }
        if (posMovil.getX() > this.maxXLimit_) {
            posMovil.setLocation(this.maxXLimit_ - 1.0, posMovil.getY());
            heading = direction < 0.0 ? 0.0 : Math.PI;
        }
        if (posMovil.getY() < this.minLimit_) {
            posMovil.setLocation(posMovil.getX(), this.minLimit_ + 1.0);
            heading = direction > 0.0 ? 4.71238898038469 : 1.5707963267948966;
        }
        if (posMovil.getY() > this.maxYLimit_) {
            posMovil.setLocation(posMovil.getX(), this.maxYLimit_ - 1.0);
            heading = direction < 0.0 ? 4.71238898038469 : 1.5707963267948966;
        }
        return heading;
    }

    public boolean CheckFinal(Point2D.Double posMovil, int turn, boolean composeList) {
        double wang = Math.atan2(posMovil.getX() - this.firePos_.getX(), posMovil.getY() - this.firePos_.getY());
        wang -= this.angle_;
        wang = Utils.normalRelativeAngle((double)wang);
        double distance = posMovil.distance(this.firePos_);
        double bulletDist = this.bulletSpeed_ * (double)((long)turn + this.turnBulletOnFly_);
        if (composeList) {
            this.posiblePositions_.add(new Point2D.Double(posMovil.getX(), posMovil.getY()));
            this.positionsTurns_.add(turn);
        }
        if (wang < this.angleLeft_) {
            this.angleLeft_ = wang;
        }
        if (wang > this.angleRight_) {
            this.angleRight_ = wang;
        }
        if (distance > this.distance_) {
            this.distance_ = distance;
        }
        return distance < bulletDist - this.minLimit_;
    }

    public void CalculatePosiblePositionsToPoint(Point2D.Double posMovil, double vel, double heading, double bulletPower, Point2D.Double firePos, Point2D.Double targetPos, long turnBulletOnFly, boolean composeList, boolean appendList) {
        if (composeList && !appendList) {
            this.posiblePositions_.clear();
            this.positionsTurns_.clear();
        }
        Point2D.Double workPos = new Point2D.Double();
        int turn = 0;
        this.firePos_ = firePos;
        this.bulletSpeed_ = Rules.getBulletSpeed((double)bulletPower);
        this.angle_ = Math.atan2(targetPos.getX() - posMovil.getX(), targetPos.getY() - posMovil.getY());
        this.angleRight_ = 0.0;
        this.angleLeft_ = 0.0;
        this.distance_ = 0.0;
        this.turnBulletOnFly_ = turnBulletOnFly;
        workPos.setLocation(posMovil);
        double workVel = vel;
        double workHeading = heading;
        turn = 0;
        while (!this.CheckFinal(workPos, turn, composeList)) {
            ++turn;
            double angleDesired = Utils.normalRelativeAngle((double)(Math.atan2(targetPos.getX() - workPos.getX(), targetPos.getY() - workPos.getY()) - workHeading));
            double orderAhead = 1.0;
            if (Math.abs(angleDesired) > 1.5707963267948966) {
                angleDesired = Utils.normalRelativeAngle((double)(angleDesired + Math.PI));
                orderAhead = -orderAhead;
            }
            double variation = Rules.getTurnRateRadians((double)workVel);
            double var = Utils.normalRelativeAngle((double)(angleDesired - workHeading));
            workHeading = Math.abs(var) <= variation ? angleDesired : (var > 0.0 ? (workHeading += variation) : (workHeading -= variation));
            if (orderAhead > 0.0) {
                workVel = workVel < -1.0 ? (workVel += 2.0) : (workVel += 1.0);
                if (workVel > 8.0) {
                    workVel = 8.0;
                }
            } else {
                workVel = workVel > 1.0 ? (workVel -= 2.0) : (workVel -= 1.0);
                if (workVel < -8.0) {
                    workVel = -8.0;
                }
            }
            workPos.setLocation(workPos.getX() + Math.sin(workHeading) * workVel, workPos.getY() + Math.cos(workHeading) * workVel);
        }
        this.angleBegin_ = Utils.normalAbsoluteAngle((double)(this.angle_ + this.angleLeft_));
        this.angleArc_ = Utils.normalAbsoluteAngle((double)(this.angleRight_ - this.angleLeft_));
    }
}

