/*
 * Decompiled with CFR 0.152.
 */
package org.la4j;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.Vectors;
import org.la4j.iterator.VectorIterator;
import org.la4j.operation.VectorMatrixOperation;
import org.la4j.operation.VectorOperation;
import org.la4j.operation.VectorVectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;
import org.la4j.vector.VectorFactory;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorFunction;
import org.la4j.vector.functor.VectorPredicate;
import org.la4j.vector.functor.VectorProcedure;

public abstract class Vector
implements Iterable<Double> {
    private static final String DEFAULT_DELIMITER = " ";
    private static final NumberFormat DEFAULT_FORMATTER = new DecimalFormat("0.000");
    protected int length;

    public static Vector zero(int length) {
        return length > 1000 ? SparseVector.zero(length) : DenseVector.zero(length);
    }

    public static Vector constant(int length, double value) {
        return DenseVector.constant(length, value);
    }

    public static Vector unit(int length) {
        return DenseVector.constant(length, 1.0);
    }

    public static Vector random(int length, Random random) {
        return DenseVector.random(length, random);
    }

    public static Vector fromArray(double[] array) {
        return DenseVector.fromArray(array);
    }

    public static Vector fromCSV(String csv) {
        StringTokenizer tokenizer = new StringTokenizer(csv, ", ");
        int estimatedLength = csv.length() / 7 + 1;
        Vector result = DenseVector.zero(estimatedLength);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            if (result.length() == i) {
                result = result.copyOfLength(i * 3 / 2 + 1);
            }
            double x = Double.valueOf(tokenizer.nextToken());
            result.set(i++, x);
        }
        return result.copyOfLength(i);
    }

    public static Vector fromMatrixMarket(String mm) {
        StringTokenizer body = new StringTokenizer(mm);
        if (!"%%MatrixMarket".equals(body.nextToken())) {
            throw new IllegalArgumentException("Wrong input file format: can not read header '%%MatrixMarket'.");
        }
        String object = body.nextToken();
        if (!"vector".equals(object)) {
            throw new IllegalArgumentException("Unexpected object: " + object + ".");
        }
        String format = body.nextToken();
        if (!"coordinate".equals(format) && !"array".equals(format)) {
            throw new IllegalArgumentException("Unknown format: " + format + ".");
        }
        String field = body.nextToken();
        if (!"real".equals(field)) {
            throw new IllegalArgumentException("Unknown field type: " + field + ".");
        }
        int length = Integer.valueOf(body.nextToken());
        if ("coordinate".equals(format)) {
            int cardinality = Integer.valueOf(body.nextToken());
            SparseVector result = SparseVector.zero(length, cardinality);
            for (int k = 0; k < cardinality; ++k) {
                int i = Integer.valueOf(body.nextToken());
                double x = Double.valueOf(body.nextToken());
                result.set(i - 1, x);
            }
            return result;
        }
        DenseVector result = DenseVector.zero(length);
        for (int i = 0; i < length; ++i) {
            result.set(i, Double.valueOf(body.nextToken()));
        }
        return result;
    }

    public static Vector fromCollection(Collection<? extends Number> list) {
        return DenseVector.fromCollection(list);
    }

    public static Vector fromMap(Map<Integer, ? extends Number> map, int length) {
        return SparseVector.fromMap(map, length);
    }

    public Vector() {
        this(0);
    }

    public Vector(int length) {
        this.ensureLengthIsCorrect(length);
        this.length = length;
    }

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public abstract Vector blankOfLength(int var1);

    public abstract Vector copyOfLength(int var1);

    public abstract Matrix toRowMatrix();

    public abstract Matrix toColumnMatrix();

    public abstract Matrix toDiagonalMatrix();

    public abstract <T> T apply(VectorOperation<T> var1);

    public abstract <T> T apply(VectorVectorOperation<T> var1, Vector var2);

    public abstract <T> T apply(VectorMatrixOperation<T> var1, Matrix var2);

    public abstract byte[] toBinary();

    public abstract String toMatrixMarket(NumberFormat var1);

    public void setAll(double value) {
        VectorIterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.set(value);
        }
    }

    public int length() {
        return this.length;
    }

    public Vector add(double value) {
        VectorIterator it = this.iterator();
        Vector result = this.blank();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, x + value);
        }
        return result;
    }

    public Vector add(Vector that) {
        return this.apply(LinearAlgebra.OO_PLACE_VECTORS_ADDITION, that);
    }

    public Vector multiply(double value) {
        VectorIterator it = this.iterator();
        Vector result = this.blank();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, x * value);
        }
        return result;
    }

    public Vector hadamardProduct(Vector that) {
        return this.apply(LinearAlgebra.OO_PLACE_VECTOR_HADAMARD_PRODUCT, that);
    }

    public Vector multiply(Matrix that) {
        return this.apply(LinearAlgebra.OO_PLACE_VECTOR_BY_MATRIX_MULTIPLICATION, that);
    }

    public Vector subtract(double value) {
        return this.add(-value);
    }

    public Vector subtract(Vector that) {
        return this.apply(LinearAlgebra.OO_PLACE_VECTORS_SUBTRACTION, that);
    }

    public Vector divide(double value) {
        return this.multiply(1.0 / value);
    }

    public double product() {
        return this.fold(Vectors.asProductAccumulator(1.0));
    }

    public double sum() {
        return this.fold(Vectors.asSumAccumulator(0.0));
    }

    public double innerProduct(Vector that) {
        return this.apply(LinearAlgebra.OO_PLACE_INNER_PRODUCT, that);
    }

    public Matrix outerProduct(Vector that) {
        return this.apply(LinearAlgebra.OO_PLACE_OUTER_PRODUCT, that);
    }

    public double norm() {
        return this.euclideanNorm();
    }

    public double euclideanNorm() {
        return this.fold(Vectors.mkEuclideanNormAccumulator());
    }

    public double manhattanNorm() {
        return this.fold(Vectors.mkManhattanNormAccumulator());
    }

    public double infinityNorm() {
        return this.fold(Vectors.mkInfinityNormAccumulator());
    }

    public void swapElements(int i, int j) {
        if (i != j) {
            double s = this.get(i);
            this.set(i, this.get(j));
            this.set(j, s);
        }
    }

    public Vector blank() {
        return this.blankOfLength(this.length);
    }

    public Vector copy() {
        return this.copyOfLength(this.length);
    }

    public Vector shuffle() {
        Vector result = this.copy();
        Random random = new Random();
        for (int i = 0; i < this.length; ++i) {
            int j = random.nextInt(this.length - i) + i;
            this.swapElements(i, j);
        }
        return result;
    }

    public Vector slice(int from, int until) {
        if (until - from < 0) {
            this.fail("Wrong slice range: [" + from + ".." + until + "].");
        }
        Vector result = this.blankOfLength(until - from);
        for (int i = from; i < until; ++i) {
            result.set(i - from, this.get(i));
        }
        return result;
    }

    public Vector sliceLeft(int until) {
        return this.slice(0, until);
    }

    public Vector sliceRight(int from) {
        return this.slice(from, this.length);
    }

    public Vector select(int[] indices) {
        int newLength = indices.length;
        if (newLength == 0) {
            this.fail("No elements selected.");
        }
        Vector result = this.blankOfLength(newLength);
        for (int i = 0; i < newLength; ++i) {
            result.set(i, this.get(indices[i]));
        }
        return result;
    }

    public void each(VectorProcedure procedure) {
        VectorIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            procedure.apply(i, x);
        }
    }

    public double max() {
        return this.fold(Vectors.mkMaxAccumulator());
    }

    public double min() {
        return this.fold(Vectors.mkMinAccumulator());
    }

    public Vector transform(VectorFunction function) {
        VectorIterator it = this.iterator();
        Vector result = this.blank();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, function.evaluate(i, x));
        }
        return result;
    }

    public void update(VectorFunction function) {
        VectorIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            it.set(function.evaluate(i, x));
        }
    }

    public void updateAt(int i, VectorFunction function) {
        this.set(i, function.evaluate(i, this.get(i)));
    }

    public double fold(VectorAccumulator accumulator) {
        this.each(Vectors.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public boolean is(VectorPredicate predicate) {
        boolean result = true;
        VectorIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result = result && predicate.test(i, x);
        }
        return result;
    }

    public boolean non(VectorPredicate predicate) {
        return !this.is(predicate);
    }

    public boolean equals(Vector that, double precision) {
        if (this == that) {
            return true;
        }
        if (this.length != that.length()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; result && i < this.length; ++i) {
            double a = this.get(i);
            double b = that.get(i);
            double diff = Math.abs(a - b);
            result = a == b || diff < precision || diff / Math.max(Math.abs(a), Math.abs(b)) < precision;
        }
        return result;
    }

    public String mkString(NumberFormat formatter) {
        return this.mkString(formatter, DEFAULT_DELIMITER);
    }

    public String mkString(NumberFormat formatter, String delimiter) {
        StringBuilder sb = new StringBuilder();
        VectorIterator it = this.iterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            sb.append(formatter.format(x)).append(i < this.length - 1 ? delimiter : "");
        }
        return sb.toString();
    }

    public String toString() {
        return this.mkString(DEFAULT_FORMATTER, DEFAULT_DELIMITER);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Vector && this.equals((Vector)o, Vectors.EPS);
    }

    public int hashCode() {
        VectorIterator it = this.iterator();
        int result = 17;
        while (it.hasNext()) {
            long value = ((Double)it.next()).longValue();
            result = 37 * result + (int)(value ^ value >>> 32);
        }
        return result;
    }

    public VectorIterator iterator() {
        return new VectorIterator(this.length){
            private int i;
            {
                this.i = -1;
            }

            @Override
            public int index() {
                return this.i;
            }

            @Override
            public double get() {
                return Vector.this.get(this.i);
            }

            @Override
            public void set(double value) {
                Vector.this.set(this.i, value);
            }

            @Override
            public boolean hasNext() {
                return this.i + 1 < this.length;
            }

            @Override
            public Double next() {
                ++this.i;
                return this.get();
            }
        };
    }

    public <T extends Vector> T to(VectorFactory<T> factory) {
        VectorIterator it = this.iterator();
        T result = factory.apply(this.length);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            ((Vector)result).set(i, x);
        }
        return result;
    }

    public DenseVector toDenseVector() {
        return this.to(Vectors.DENSE);
    }

    public SparseVector toSparseVector() {
        return this.to(Vectors.SPARSE);
    }

    public String toCSV() {
        return this.toCSV(DEFAULT_FORMATTER);
    }

    public String toCSV(NumberFormat formatter) {
        return this.mkString(formatter, ", ");
    }

    public String toMatrixMarket() {
        return this.toMatrixMarket(DEFAULT_FORMATTER);
    }

    protected void ensureLengthIsCorrect(int length) {
        if (length < 0) {
            this.fail("Wrong vector length: " + length);
        }
        if (length == Integer.MAX_VALUE) {
            this.fail("Wrong vector length: use 'Integer.MAX_VALUE - 1' instead.");
        }
    }

    protected void fail(String message) {
        throw new IllegalArgumentException(message);
    }
}

