/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import org.la4j.Matrix;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.operation.VectorVectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;

public class OoPlaceOuterProduct
extends VectorVectorOperation<Matrix> {
    @Override
    public Matrix apply(SparseVector a, SparseVector b) {
        RowMajorSparseMatrix result = RowMajorSparseMatrix.zero(a.length(), b.length());
        VectorIterator these = a.nonZeroIterator();
        while (these.hasNext()) {
            double x = (Double)these.next();
            int i = these.index();
            VectorIterator those = b.nonZeroIterator();
            while (those.hasNext()) {
                double y = (Double)those.next();
                int j = those.index();
                result.set(i, j, x * y);
            }
        }
        return result;
    }

    @Override
    public Matrix apply(DenseVector a, DenseVector b) {
        DenseMatrix result = DenseMatrix.zero(a.length(), b.length());
        for (int i = 0; i < a.length(); ++i) {
            for (int j = 0; j < b.length(); ++j) {
                result.set(i, j, a.get(i) * b.get(j));
            }
        }
        return result;
    }

    @Override
    public Matrix apply(DenseVector a, SparseVector b) {
        ColumnMajorSparseMatrix result = ColumnMajorSparseMatrix.zero(a.length(), b.length());
        VectorIterator it = b.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            for (int i = 0; i < a.length(); ++i) {
                result.set(i, j, x * a.get(i));
            }
        }
        return result;
    }

    @Override
    public Matrix apply(SparseVector a, DenseVector b) {
        RowMajorSparseMatrix result = RowMajorSparseMatrix.zero(a.length(), b.length());
        VectorIterator it = a.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            for (int j = 0; j < b.length(); ++j) {
                result.set(i, j, x * b.get(j));
            }
        }
        return result;
    }
}

