/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Box;
import shrub.Heading;
import shrub.InterceptSolution;
import shrub.Location;
import shrub.MoveHistory;
import shrub.Movement;
import shrub.PredictorAPI;

public class CPPredictor
implements PredictorAPI {
    public CPPredictor() {
        this.Initialise();
    }

    public void Initialise() {
    }

    public void SetMovementArea(Box newValue) {
    }

    public void SetInterceptArea(Box newValue) {
    }

    public void SetMaxInterceptTime(long newValue) {
    }

    public final InterceptSolution Intercept(double minSpeedAllowed, double maxSpeedAllowed, Location subLocn, Heading subHdng, MoveHistory objHistory) {
        Movement objLastMove = objHistory.GetLastMove();
        Location objLocn = objLastMove.GetLocnNow();
        Heading hdngToObj = Heading.valueOfFromTo(subLocn, objLocn);
        double distanceToObj = subLocn.DistanceTo(objLocn);
        double angularTolRad = Math.atan(15.0 / distanceToObj);
        double angularTolDeg = Math.toDegrees(angularTolRad);
        Bearing angleOff = Bearing.valueOfFromTo(subHdng, hdngToObj);
        InterceptSolution intSoln = new InterceptSolution();
        if (angleOff.GetAbs() < angularTolDeg) {
            intSoln.mSpeed = minSpeedAllowed;
        } else if (angleOff.GetAbs() < 10.0) {
            intSoln.mBearing = angleOff.Get();
        }
        return intSoln;
    }
}

