/*
 * Decompiled with CFR 0.152.
 */
package ha2;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Gun {
    AdvancedRobot robot;
    ScannedRobotEvent e;
    static double lastEnemyHeading;
    double oldEnemyHeading = 0.0;

    public void circular_fire() {
        double maxBP = 3.0;
        if (this.e.getDistance() > 200.0) {
            maxBP = 2.4;
        }
        double bulletPower = Math.min(maxBP, Math.min(this.robot.getEnergy() / 10.0, this.e.getEnergy() / 4.0));
        double bulletSpeed = 20.0 - 3.0 * bulletPower;
        double absBearing = this.e.getBearingRadians() + this.robot.getHeadingRadians();
        double EX = this.robot.getX() + this.e.getDistance() * Math.sin(absBearing);
        double EY = this.robot.getY() + this.e.getDistance() * Math.cos(absBearing);
        double enemyHeading = this.e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
        this.oldEnemyHeading = enemyHeading;
        double deltaTime = 0.0;
        double predictedX = EX;
        double predictedY = EY;
        while (true) {
            double d;
            deltaTime += 1.0;
            if (!(d * bulletSpeed < Point2D.Double.distance(this.robot.getX(), this.robot.getY(), predictedX, predictedY))) break;
            predictedX += Math.sin(enemyHeading) * this.e.getVelocity();
            predictedY += Math.cos(enemyHeading) * this.e.getVelocity();
            enemyHeading += enemyHeadingChange;
            predictedX = Math.max(predictedX, 18.0);
            predictedY = Math.max(predictedY, 18.0);
            predictedX = Math.min(predictedX, this.robot.getBattleFieldWidth() - 18.0);
            predictedY = Math.min(predictedY, this.robot.getBattleFieldHeight() - 18.0);
        }
        double aim = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.robot.getX(), predictedY - this.robot.getY()));
        this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(aim - this.robot.getGunHeadingRadians())));
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(bulletPower);
        }
    }

    public void circular_ognia() {
        double dy;
        double dx;
        double firepower = 350.0 / this.e.getDistance();
        double w = this.e.getHeadingRadians() - lastEnemyHeading;
        lastEnemyHeading = this.e.getHeadingRadians();
        double absbearing = this.e.getBearingRadians() + this.robot.getHeadingRadians();
        double eX = this.e.getDistance() * Math.sin(absbearing);
        double eY = this.e.getDistance() * Math.cos(absbearing);
        double db = 0.0;
        double ww = lastEnemyHeading;
        do {
            dx = this.e.getVelocity() * Math.sin(ww);
            dy = this.e.getVelocity() * Math.cos(ww);
            ww += w;
        } while ((db += 11.0) * (20.0 - 3.0 * firepower) < Point2D.distance(0.0, 0.0, eX += dx, eY += dy));
        this.robot.setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - this.robot.getGunHeadingRadians())));
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(firepower);
        }
    }

    public Gun(AdvancedRobot robot, ScannedRobotEvent e) {
        this.robot = robot;
        this.e = e;
        this.ustaw();
    }

    public Gun(AdvancedRobot robot) {
        this.robot = robot;
    }

    public void sete(ScannedRobotEvent e) {
        this.e = e;
        this.ustaw();
    }

    public void ustaw() {
        if (this.e.getDistance() > 100.0) {
            this.circular_fire();
        } else {
            this.shootprosty(this.e);
        }
    }

    public void shootprosty(ScannedRobotEvent e) {
        double firepower = 350.0 / e.getDistance();
        double fireangle = this.robot.getGunHeading() - this.robot.getHeading() - e.getBearing();
        fireangle = this.fixAngle(fireangle);
        this.robot.setTurnGunLeft(fireangle);
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(firepower);
        }
    }

    public void shootAtEnemy(ScannedRobotEvent e) {
        double firepower = 350.0 / e.getDistance();
        double fireangle = this.robot.getGunHeading() - this.robot.getHeading() - e.getBearing() + Math.toDegrees(Math.asin(e.getVelocity() / (20.0 - 3.0 * firepower) * Math.sin(Math.toRadians(180.0 - this.robot.getHeading() - e.getBearing() + e.getHeading()))));
        fireangle = this.fixAngle(fireangle);
        this.robot.setTurnGunLeft(fireangle);
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(firepower);
        }
    }

    public double fixAngle(double angle) {
        if ((angle %= 360.0) > 180.0) {
            return angle - 360.0;
        }
        if (angle < -180.0) {
            return angle + 360.0;
        }
        return angle;
    }

    public double quickAngle(double angle) {
        if ((angle = this.fixAngle(angle)) > 90.0) {
            return angle - 180.0;
        }
        if (angle < -90.0) {
            return angle + 180.0;
        }
        return angle;
    }
}

