/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import dmonner.xlbp.util.ListSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<K> keys;
    private final Map<K, V> map;

    public ListMap() {
        this.keys = new LinkedList<K>();
        this.map = new HashMap();
    }

    public ListMap(ListMap<K, V> other) {
        this.keys = new LinkedList<K>(other.keys);
        this.map = new HashMap<K, V>(other.map);
    }

    public ListMap(Map<K, V> other) {
        this.keys = new LinkedList<K>(other.keySet());
        this.map = new HashMap<K, V>(other);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ListSet<Map.Entry<K, V>> set = new ListSet<Map.Entry<K, V>>();
        for (K key : this.keys) {
            set.add(new Entry<K, V>(key, this.map.get(key)));
        }
        return set;
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    public K getKey(int index) {
        return this.keys.get(index);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public List<K> keyList() {
        ArrayList<K> list = new ArrayList<K>();
        for (K key : this.keys) {
            list.add(key);
        }
        return list;
    }

    @Override
    public ListSet<K> keySet() {
        ListSet<K> set = new ListSet<K>();
        for (K key : this.keys) {
            set.add(key);
        }
        return set;
    }

    @Override
    public V put(K key, V value) {
        if (!this.map.containsKey(key)) {
            this.keys.add(key);
        }
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K key : m.keySet()) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public V remove(Object key) {
        this.keys.remove(key);
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public List<V> values() {
        LinkedList<V> set = new LinkedList<V>();
        for (K key : this.keys) {
            set.add(this.map.get(key));
        }
        return set;
    }

    public static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public V setValue(V value) {
            V rv = this.value;
            this.value = value;
            return rv;
        }
    }
}

