/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Wave {
    private Point2D startingLocation;
    private double bulletPower;
    private double velocity;
    private long startingTime;
    private double radius;
    private double diameter;
    private double maxRadius;
    private boolean waveIsDead = false;
    private double bulletDirectionHeadon;
    private double bulletDirectionLinear;
    private double bulletDirectionAdaptive;
    private Point2D bulletLocationHeadOn;
    private Point2D bulletLocationLinear;
    private ArrayList<Point2D> futureBulletLocations = new ArrayList();
    private double directAngle;
    private double enemyVelocity;
    private double lastEnemyVelocity;

    public Wave(Point2D startingLocation, double bulletPower, double velocity, long startingTime, double maxDiameter, double bulletDirectionHeadon, double bulletDirectionLinear, double bulletDirectionAdaptive, double directAngle, double enemyVelocity, double lastEnemyVelocity) {
        this.startingLocation = startingLocation;
        this.bulletPower = bulletPower;
        this.velocity = velocity;
        this.startingTime = startingTime - 1L;
        this.maxRadius = maxDiameter;
        this.bulletDirectionHeadon = bulletDirectionHeadon;
        this.bulletDirectionLinear = bulletDirectionLinear;
        this.bulletDirectionAdaptive = bulletDirectionAdaptive;
        this.directAngle = directAngle;
        this.enemyVelocity = enemyVelocity;
        this.lastEnemyVelocity = lastEnemyVelocity;
        this.updateBulletLocations();
    }

    public double getEnemyVelocity() {
        return this.enemyVelocity;
    }

    public double getLastEnemyVelocity() {
        return this.lastEnemyVelocity;
    }

    public Point2D getStartingLocation() {
        return this.startingLocation;
    }

    public ArrayList<Point2D> getBulletLocations() {
        ArrayList<Point2D> bulletLocations = new ArrayList<Point2D>();
        bulletLocations.add(this.bulletLocationHeadOn);
        bulletLocations.add(this.bulletLocationLinear);
        bulletLocations.addAll(this.futureBulletLocations);
        return bulletLocations;
    }

    public double getBulletDirectionAdaptive() {
        return this.bulletDirectionAdaptive;
    }

    public double getBulletPower() {
        return this.bulletPower;
    }

    private void updateBulletLocations() {
        this.bulletLocationHeadOn = DivineBot.project(this.startingLocation, this.bulletDirectionHeadon, this.radius);
        this.bulletLocationLinear = DivineBot.project(this.startingLocation, this.bulletDirectionLinear, this.radius);
        this.futureBulletLocations.clear();
        int x = 0;
        while (x <= 200) {
            this.futureBulletLocations.add(DivineBot.project(this.startingLocation, this.bulletDirectionHeadon, this.radius + (double)(x += 10)));
            this.futureBulletLocations.add(DivineBot.project(this.startingLocation, this.bulletDirectionLinear, this.radius + (double)x));
        }
    }

    public void update(long newTime) {
        this.radius = this.velocity * (double)(newTime - this.startingTime);
        this.diameter = this.radius * 2.0;
        if (this.radius > this.maxRadius) {
            this.waveIsDead = true;
        }
        this.updateBulletLocations();
    }

    public double getDistance(Point2D myLocation) {
        double distance = myLocation.distance(this.startingLocation) - this.radius;
        return distance;
    }

    public boolean isDead() {
        return this.waveIsDead;
    }

    public void paint(Graphics g, Color color) {
        g.setColor(color);
        g.drawOval((int)(this.startingLocation.getX() - this.radius), (int)(this.startingLocation.getY() - this.radius), (int)this.diameter, (int)this.diameter);
        g.drawLine((int)this.startingLocation.getX(), (int)this.startingLocation.getY(), (int)this.bulletLocationHeadOn.getX(), (int)this.bulletLocationHeadOn.getY());
        g.drawLine((int)this.startingLocation.getX(), (int)this.startingLocation.getY(), (int)this.bulletLocationLinear.getX(), (int)this.bulletLocationLinear.getY());
    }

    public void paintBulletLocations(Graphics g, Color color) {
        g.setColor(color);
        ArrayList<Point2D> bulletLocations = this.getBulletLocations();
        int ovalDrawRadius = 5;
        for (Point2D bulletLocation : bulletLocations) {
            g.drawOval((int)bulletLocation.getX() - ovalDrawRadius, (int)bulletLocation.getY() - ovalDrawRadius, ovalDrawRadius * 2, ovalDrawRadius * 2);
        }
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getDirectAngle() {
        return this.directAngle;
    }
}

