/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.DynamicMovementSequence;
import dmh.robocode.data.Location;
import dmh.robocode.data.Movement;
import dmh.robocode.data.RadarObservation;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategyUsingEnemySimulator;
import dmh.robocode.gunner.simulator.SteadyChangeEnemySimulator;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;

public class AimByRepeatingLastMove
extends CalibratedAimingStrategyUsingEnemySimulator {
    private Movement expectedMove;
    private Location targetLocation;
    long timeOfLastCalculation;
    int roundOfLastCalculation;

    public AimByRepeatingLastMove(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
        this.timeOfLastCalculation = myRobot.getTime() - 1L;
        this.roundOfLastCalculation = myRobot.getRoundNum() - 1;
        this.targetLocation = null;
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        this.calculateExpectedMoveAndTarget(bulletSpeed);
        if (this.targetLocation == null) {
            return 0.0;
        }
        double distance = Geometry.getDistanceBetweenLocations(this.getMyRobot().getLocation(), this.targetLocation);
        int bulletTravelTime = (int)(distance / bulletSpeed);
        int consistentMoves = this.getEnemy().getCurrentMovementSequence().getConsistentMoveCount(bulletTravelTime);
        int expectedMoves = this.getEnemy().getCurrentMovementSequence().countSameMovement(bulletTravelTime, this.expectedMove);
        return (50 * consistentMoves + 50 * expectedMoves) / bulletTravelTime;
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        this.calculateExpectedMoveAndTarget(bulletSpeed);
        return this.targetLocation;
    }

    private void calculateExpectedMoveAndTarget(double bulletSpeed) {
        if (this.timeOfLastCalculation != this.getMyRobot().getTime() || this.roundOfLastCalculation != this.getMyRobot().getRoundNum()) {
            DynamicMovementSequence currentMovements = this.getEnemy().getCurrentMovementSequence();
            RadarObservation latestObservation = this.getEnemy().getLatestRadarObservation();
            RadarObservation previousObservation = this.getEnemy().getPreviousRadarObservation();
            if (currentMovements.areUpToDate(this.getMyRobot().getTime()) && previousObservation != null) {
                double rateOfTurn = Geometry.getRelativeBearing(previousObservation.getHeading(), latestObservation.getHeading());
                double acceleration = latestObservation.getVelocity() - previousObservation.getVelocity();
                SteadyChangeEnemySimulator simulator = new SteadyChangeEnemySimulator(latestObservation.getLocation(), latestObservation.getVelocity(), latestObservation.getHeading(), acceleration, rateOfTurn);
                this.targetLocation = this.getSimulatorIntercept(simulator, bulletSpeed);
                this.expectedMove = new Movement(rateOfTurn, latestObservation.getVelocity());
                this.timeOfLastCalculation = this.getMyRobot().getTime();
                this.roundOfLastCalculation = this.getMyRobot().getRoundNum();
            } else if (this.roundOfLastCalculation != this.getMyRobot().getRoundNum() || this.timeOfLastCalculation + 10L < this.getMyRobot().getTime()) {
                this.targetLocation = null;
            }
        }
    }
}

