/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.CalibratedAimingStrategyUsingEnemySimulator;
import dmh.robocode.gunner.simulator.TimeMachineEnemySimulator;
import dmh.robocode.robot.CommandBasedRobot;
import java.awt.Color;

public class AimUsingFixedTimeMachineReplay
extends CalibratedAimingStrategyUsingEnemySimulator {
    private long fixedTimeOffset;

    public AimUsingFixedTimeMachineReplay(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, long fixedTimeOffset, Color color) {
        super(myRobot, enemy, isLearningAllowed, color);
        this.fixedTimeOffset = fixedTimeOffset;
    }

    @Override
    protected String getParametersAsString() {
        return Long.toString(this.fixedTimeOffset);
    }

    @Override
    public double getEstimatedSuccessOfShotUsingRules(double bulletSpeed) {
        if (this.getStartTime() >= 15L) {
            return this.getDefaultEstimatedSuccess(bulletSpeed);
        }
        if (this.getStartTime() >= 0L) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Location getTargetForShot(double bulletSpeed) {
        if (this.getStartTime() >= 0L) {
            Location enemyReplayLocation = this.getEnemy().getLocationAtTime(this.getStartTime());
            Location enemyLocationNow = this.getEnemy().getLatestRadarObservation().getLocation();
            if (enemyReplayLocation != null && enemyLocationNow != null) {
                double xDisplacement = enemyLocationNow.getX() - enemyReplayLocation.getX();
                double yDisplacement = enemyLocationNow.getY() - enemyReplayLocation.getY();
                TimeMachineEnemySimulator simulator = new TimeMachineEnemySimulator(this.getEnemy(), this.getStartTime(), this.getEndTime(), xDisplacement, yDisplacement);
                return this.getSimulatorIntercept(simulator, bulletSpeed);
            }
        }
        return null;
    }

    private long getStartTime() {
        return this.getMyRobot().getTime() - this.fixedTimeOffset;
    }

    private long getEndTime() {
        return this.getMyRobot().getTime();
    }

    @Override
    public String getUniqueShortId() {
        return super.getUniqueShortId() + ":" + this.fixedTimeOffset;
    }
}

