/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.navigator;

import dmh.robocode.data.Location;
import dmh.robocode.navigator.NavigateToLocation;
import dmh.robocode.navigator.NavigatorCommand;
import dmh.robocode.simulate.SimulateableRobot;
import java.awt.Graphics2D;

public class NavigateToLocations
implements NavigatorCommand {
    private Location[] targets;
    private int currentTarget = 0;
    private SimulateableRobot myRobot;
    private boolean stopAtFinalTarget = false;
    private NavigateToLocation subNavigator;
    private boolean isDoneAlready = false;

    public NavigateToLocations(Location[] targets, SimulateableRobot myRobot) {
        this.targets = targets;
        this.myRobot = myRobot;
        this.createSubNavigator();
    }

    public NavigateToLocations mustStopAtFinalTarget() {
        this.stopAtFinalTarget = true;
        return this;
    }

    @Override
    public void setWiggleFactor(int wiggleFactor) {
        if (this.subNavigator != null) {
            this.subNavigator.setWiggleFactor(wiggleFactor);
        }
    }

    @Override
    public int getWiggleFactor() {
        if (this.subNavigator != null) {
            return this.subNavigator.getWiggleFactor();
        }
        return 0;
    }

    @Override
    public void setWiggleExpiry(long wiggleExpiry) {
        if (this.subNavigator != null) {
            this.subNavigator.setWiggleExpiry(wiggleExpiry);
        }
    }

    @Override
    public long getWiggleExpiry() {
        if (this.subNavigator != null) {
            return this.subNavigator.getWiggleExpiry();
        }
        return 0L;
    }

    @Override
    public void reverseDirection() {
        this.subNavigator.reverseDirection();
    }

    private void createSubNavigator() {
        boolean bl = this.isDoneAlready = this.currentTarget >= this.targets.length;
        if (!this.isDoneAlready) {
            this.subNavigator = new NavigateToLocation(this.targets[this.currentTarget], this.myRobot);
            if (this.stopAtFinalTarget && this.currentTarget == this.targets.length - 1) {
                this.subNavigator.mustStopAtTarget();
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.isDoneAlready;
    }

    @Override
    public double getRightTurn() {
        return this.subNavigator.getRightTurn();
    }

    @Override
    public double getAhead() {
        return this.subNavigator.getAhead();
    }

    @Override
    public double getVelocity() {
        return this.subNavigator.getVelocity();
    }

    public Location[] getTargets() {
        return this.targets;
    }

    @Override
    public void executed() {
        if (!this.isDoneAlready && this.subNavigator.isDone()) {
            ++this.currentTarget;
            this.createSubNavigator();
        }
        this.subNavigator.executed();
    }

    @Override
    public void paint(Graphics2D g) {
        this.subNavigator.paint(g);
    }
}

