/*
 * Decompiled with CFR 0.152.
 */
package kawam;

import kawam.Coordinate;

public class Intercept {
    public static final double ROBOT_RADIUS = 10.0;
    public Coordinate impactPoint = new Coordinate(0.0, 0.0);
    public double bulletHeading_deg;
    protected Coordinate bulletStartingPoint = new Coordinate();
    protected Coordinate targetStartingPoint = new Coordinate();
    public double targetHeading;
    public double targetVelocity;
    public double bulletPower;
    public double angleThreshold;
    public double distance;
    protected double impactTime;
    protected double angularVelocity_rad_per_sec;

    public void calculate(double xb, double yb, double xt, double yt, double tHeading, double vt, double bPower, double angularVelocity_deg_per_sec) {
        this.angularVelocity_rad_per_sec = Math.toRadians(angularVelocity_deg_per_sec);
        this.bulletStartingPoint.set(xb, yb);
        this.targetStartingPoint.set(xt, yt);
        this.targetHeading = tHeading;
        this.targetVelocity = vt;
        this.bulletPower = bPower;
        double vb = 20.0 - 3.0 * this.bulletPower;
        this.impactTime = this.getImpactTime(10.0, 20.0, 0.01);
        this.impactPoint = this.getEstimatedPosition(this.impactTime);
        double dX = this.impactPoint.x - this.bulletStartingPoint.x;
        double dY = this.impactPoint.y - this.bulletStartingPoint.y;
        this.distance = Math.sqrt(dX * dX + dY * dY);
        this.bulletHeading_deg = Math.toDegrees(Math.atan2(dX, dY));
        this.angleThreshold = Math.toDegrees(Math.atan(10.0 / this.distance));
    }

    public void calculate2(double x, double y) {
        double dX = x - this.bulletStartingPoint.x;
        double dY = y - this.bulletStartingPoint.y;
        this.distance = Math.sqrt(dX * dX + dY * dY);
        this.bulletHeading_deg = Math.toDegrees(Math.atan2(dX, dY));
        this.angleThreshold = Math.toDegrees(Math.atan(10.0 / this.distance));
    }

    protected Coordinate getEstimatedPosition(double time) {
        double x = this.targetStartingPoint.x + this.targetVelocity * time * Math.sin(Math.toRadians(this.targetHeading));
        double y = this.targetStartingPoint.y + this.targetVelocity * time * Math.cos(Math.toRadians(this.targetHeading));
        return new Coordinate(x, y);
    }

    private double f(double time) {
        double vb = 20.0 - 3.0 * this.bulletPower;
        Coordinate targetPosition = this.getEstimatedPosition(time);
        double dX = targetPosition.x - this.bulletStartingPoint.x;
        double dY = targetPosition.y - this.bulletStartingPoint.y;
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }

    private double getImpactTime(double t0, double t1, double accuracy) {
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = this.f(lastX);
        while (Math.abs(X - lastX) >= accuracy && iterationCount < 15) {
            ++iterationCount;
            double fX = this.f(X);
            if (fX - lastfX == 0.0) break;
            double nextX = X - fX * (X - lastX) / (fX - lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        return X;
    }
}

