/*
 * Decompiled with CFR 0.152.
 */
package catcat20.helios;

import catcat20.helios.gun.HeliosGun;
import catcat20.helios.move.Surfing;
import catcat20.helios.rader.HeliosRadar;
import catcat20.helios.utils.HConstants;
import catcat20.helios.utils.HUtils;
import catcat20.helios.utils.PreciseWallSmooth;
import catcat20.jewel.iolite.utils.IUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.TimeUnit;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;

public class Helios
extends TeamRobot {
    public static final boolean TC_MODE = false;
    public static final boolean MC_MODE = false;
    public static HeliosRadar radar;
    public static Surfing surfing;
    public static HeliosGun gun;
    int count = 0;
    Point2D.Double _myLocation = new Point2D.Double();
    boolean won = false;
    double amp = 10.0;

    public void resetConstants() {
        HConstants.GUN_COOLING_RATE = this.getGunCoolingRate();
        HConstants.fieldWidth = this.getBattleFieldWidth();
        HConstants.fieldHeight = this.getBattleFieldHeight();
        HConstants.field = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        int margin = 20;
        HConstants.safeField = new Rectangle2D.Double(margin, margin, this.getBattleFieldWidth() - (double)margin, this.getBattleFieldHeight() - (double)margin);
        HConstants.fieldCenter = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        HConstants.preciseWallSmooth = new PreciseWallSmooth(this.getBattleFieldWidth(), this.getBattleFieldHeight());
    }

    public void run() {
        try {
            this.resetConstants();
            if (radar == null) {
                radar = new HeliosRadar(this);
            }
            if (surfing == null) {
                surfing = new Surfing(this);
            }
            if (gun == null) {
                gun = new HeliosGun(this);
            }
            radar.init();
            surfing.init();
            gun.init();
            this.setBodyColor(new Color(255, 200, 0));
            this.setGunColor(new Color(0, 0, 0));
            this.setRadarColor(new Color(255, 81, 0));
            this.setBulletColor(new Color(255, 81, 0));
            this.setScanColor(new Color(255, 161, 0));
            this.setAdjustRadarForRobotTurn(false);
            this.setAdjustRadarForGunTurn(false);
            this.setAdjustGunForRobotTurn(false);
            this.setTurnRightRadians(Double.POSITIVE_INFINITY);
            this.setTurnGunRightRadians(Double.POSITIVE_INFINITY);
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            String nearEnName = null;
            while (true) {
                if (HeliosRadar.nearestBot != null) {
                    nearEnName = HeliosRadar.nearestBot.name;
                }
                this._myLocation.setLocation(this.getX(), this.getY());
                if (this.won && Helios.surfing._waves.isEmpty()) {
                    this.setMaxVelocity(8.0);
                    this.setAdjustGunForRobotTurn(false);
                    this.setAdjustRadarForGunTurn(false);
                    this.setAdjustRadarForRobotTurn(false);
                    this.goTo(HeliosRadar.getBot((String)nearEnName).currentState.getPosition());
                    if (this._myLocation.distance(HeliosRadar.getBot((String)nearEnName).currentState.getPosition()) <= 3.0) {
                        this.setTurnRightRadians(Double.POSITIVE_INFINITY);
                        this.setMaxVelocity(Double.POSITIVE_INFINITY);
                        this.setAhead(Math.random() * 24.0 - 8.0);
                    }
                    this.setTurnGunRightRadians(Double.POSITIVE_INFINITY);
                    this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
                    this.setBulletColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
                    this.setScanColor(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
                    if (this.getEnergy() > IUtils.limit(0.1, this.getEnergy() / 7.5, 3.0)) {
                        this.setFire(IUtils.limit(0.1, this.getEnergy() / 7.5, 3.0));
                    }
                    this.execute();
                    continue;
                }
                if (this.count > 0) {
                    this.setAdjustGunForRobotTurn(true);
                    this.setAdjustRadarForGunTurn(true);
                    this.setAdjustRadarForRobotTurn(true);
                }
                radar.onTick();
                long then = System.nanoTime();
                surfing.onTick();
                long millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
                then = System.nanoTime();
                if (this.getEnergy() > 0.0) {
                    gun.onTick();
                }
                millis = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - then);
                this.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void goTo(Point2D.Double place) {
        double distance = this._myLocation.distance(place);
        double dir = 1.0;
        double angle = Utils.normalRelativeAngle((double)(HUtils.absoluteBearing(this._myLocation, place) - this.getHeadingRadians()));
        if (-1.0 < distance & distance < 1.0) {
            angle = 0.0;
        }
        if (Math.abs(angle) > 1.5707963267948966) {
            dir = -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.setTurnRightRadians(angle + Math.toRadians(this.amp * Math.sin(Math.toRadians(this.getTime() * 32L))));
        this.setAhead(this.distanceScale(distance, angle) * dir);
    }

    private double distanceScale(double oldDistance, double changeAngle) {
        return Math.abs(Math.cos(changeAngle)) * Math.min(20.0, oldDistance);
    }

    public void onWin(WinEvent e) {
        this.won = true;
        gun.onRoundEnded();
        surfing.onRoundEnded();
    }

    public void onDeath(DeathEvent e) {
        gun.onRoundEnded();
        surfing.onRoundEnded();
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        ++this.count;
        if (this.count <= 1) {
            if (this.getOthers() <= 1) {
                this.setTurnRightRadians(0.0);
                this.setTurnGunRightRadians(Double.NEGATIVE_INFINITY);
                this.setTurnRadarRightRadians(Double.NEGATIVE_INFINITY);
            } else {
                this.setTurnRightRadians(0.0);
                this.setTurnGunRightRadians(0.0);
                this.setTurnRadarRightRadians(0.0);
            }
        }
        radar.onScannedRobotEvent(e);
    }

    public final void onBulletHit(BulletHitEvent e) {
        gun.onBulletHit(e);
    }

    public final void onBulletHitBullet(BulletHitBulletEvent e) {
        gun.onBulletHitBullet(e);
        surfing.onBulletHitBullet(e);
    }

    public final void onHitByBullet(HitByBulletEvent e) {
        surfing.onHitByBullet(e);
    }

    public final void onRobotDeath(RobotDeathEvent e) {
        radar.onRobotDeath(e);
    }

    public final void onPaint(Graphics2D g) {
        surfing.onPaint(g);
        gun.onPaint(g);
    }
}

